/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.evalution.LinkAcademyLocations', {
	//  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.linkacademylocations',
	store: 'examinationcenters.evaluation.coverageDetails.AcademyLocationByPlan',
	title: getExaminationTranslation('LINK_ALS'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix: {
		headerFix: true,
		portalIdsWithStructure: {
			'academylocationstab': 1
		}
	},
	/* dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.evaluation.coverageDetails.AcademyLocationByPlan',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	        }],*/
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnLinkAlItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			style:{
//					marginLeft:'5px',
					marginRight:'10px'
			}
		},{
			xtype:'textfield',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			width: 300,
			name:'academyLocation',
			itemId:'academyLocationItemId',
			cls: 'SearchTextFieldWithSmallHeader'
		}]
	},{
		xtype: 'button',
		itemId: 'btnReset',
		tooltip: getExaminationTranslation('RESET'),
		text:getExaminationTranslation('RESET'),
		hidden:true
	}],
	columns: [{
		header: getExaminationTranslation('ACADEMY_LOCATION'),
		dataIndex: 'academyLocationName',
		flex:.9,
		sortable:true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
	}]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});