/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.examinationcenters.examresultpublish.BulkExamResultPublishFilter', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.bulkExamResultPublishFilter',
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'academyLocation',
            itemId: 'academyLocationIdBulkPublish',
            autoloadStore: true,
            width: 460,
            fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
            valueField: 'id',
            displayField: 'value',
            editable: false,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    },
                    afterRender: function (combo) {
                        combo.getStore().on("load", function (store, items) {
                            try {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            } catch (err) {
                                console.log(err);
                            }
                        });
                    }
                },
                cls: 'combo-word-break-all',
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTerm',
            itemId: 'academicTermBulkPublish',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            typeAhead: true,
            forceSelection: true,
            listeners: {
                render: function (combo) {
                    var store = Ext.create('Academia.store.common.AcademicTermStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'evaluationPlanId',
            itemId: 'evaluationPlanIdBulkPublish',
            store: Ext.create('Academia.store.examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanStore'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            displayField: 'display',
            queryParam: 'qry',
            minChars: 3,
            width: 226,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            allowBlank: false,
            disabled: true,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{display}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programItemIdBulkPublish',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.ManageAssessmentProgramStore'),
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'programName',
            minChars: 3,
            width: 226,
            disabled: true,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchItemIdBulkPublish',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.ManageAssessmentBatcheStore'),
            fieldLabel: getExaminationTranslation('BATCH'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'batch',
            minChars: 3,
            width: 226,
            disabled: true,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'periodId',
            itemId: 'periodItemIdBulkPublish',
            disabled: true,
            store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.MapUnmapPeriodForDynamic'),
            fieldLabel: getExaminationTranslation('PERIOD'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            width: 226,
            typeAhead: false,
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }, {
            xtype: 'multiselectcombofield',
            name: 'courseId',
            itemId: 'courseItemIdBulkPublish',
            store: Ext.create('Academia.store.examinationcenters.assessmentEvent.ManageAssessmentCoursesStore'),
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            cls: 'resetPasswordMultiselect',
            valueField: 'id',
            displayField: 'value',
            disabled: true,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            autoloadStore: false,
            maxLength: 500000,
            listConfig: {
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                },
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'groupingcombobox',
            name: 'evaluationLevel',
            itemId: 'evaluationLevelItemIdBulkPublish',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanLevelStore'),
            displayField: 'value',
            valueField: 'levelId',
            forceSelection: true,
            //typeAhead: true,
            //querymode: 'local',
            minChars: 3,
            disabled: true,
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getExaminationTranslation('BULK_PUBLISH'),
            itemId: 'bulkPublishBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            disabled: true
        }, {
            xtype: 'button',
            text: getExaminationTranslation('BULK_UNPUBLISH'),
            itemId: 'bulkUnpublishBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            disabled: true 
        }]
    }]
});