/**
 * @author bhanu pratap singh
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateFoilsWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.generatefoilswin',
	title:getExaminationTranslation('GENERATE_FOILS_REPORT'),
	modal: true,
	overflowX: 'hidden',
	overflowY: 'auto',
	maxHeight:500,
	width: '40%',
	height:'40%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
				layout: {
					type: 'hbox'
				},
				items: [{
				xtype: 'customcombobox',
				name: 'evaluationGroupId',
				itemId: 'evaluationGroupItemId',
				store:'examinationcenters.evalresultlisting.EvaluationGroup',
				displayField:'code',
				valueField:'id',
				forceSelection:true,
				width: 408,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
				matchFieldWidth:true,
				listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width-105; 
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                        '{value}'  +
                        '</div>';
                    }
                }
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				itemId:'chooseTemplate',
				name: 'chooseTemplateId',
				store:'setup.templatemapping.TemplateNameForFoils',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
				displayField:'code',
				valueField:'id',
				forceSelection:true,
				width:280,
				typeAhead:true,
				minChars:3,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width-105;
						}
					}
				},
				allowBlank:false,
				fieldLabel:getExaminationTranslation('TEMPLATE')
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				items:[{
					xtype: 'button',
					text:'Preview Template',
					itemId: 'previewTemplateBtn',
					buttonAlign: 'bottom',
					ui: 'CustomBtnThird',
					scale: CONSTANTS.BUTTONSIZE,
					//hidden:true
					formBind:true
				}]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox',
				width: 460
			},
			items:[{
				xtype : 'radiogroup',
				itemId:'studentTypeId',
				width: 460,
				hidden:true,
				fieldLabel: getExaminationTranslation('STUDENT_TYPE'), 
				defaults: {
					flex: .1
				},
				items : [{
					boxLabel : getExaminationTranslation('REGULAR'),
					name : 'studentType',
					inputValue : getExaminationTranslation('REGULAR'),
					checked : true

				},{
					boxLabel : getExaminationTranslation('EX'),
					name : 'studentType',
					inputValue : getExaminationTranslation('EX')
				}]
			}]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getServiceRequestTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE,
				listeners: {
					click: function(obj) {
						obj.up().up().up().close();
					}
				}
			}]
		}]
	}]
});