/**
 * @author kuldeep yadav
 */
Ext.define('Academia.view.examinationcenters.generatehallticket.GenerateHallTicketFilter', {
	extend: 'Ext.form.FormPanel',
    alias: 'widget.generatehallticketfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    standardSubmit : false,
    plugins : "formlabelrequired",
	    items: [{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTermId',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store :Ext.create('Academia.store.common.AcademicTermStore'),
				valueField : 'id',
				displayField : 'value',
				forceSelection:true,
				minChars:3,
				queryParam:'academicTermName',
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			 },{
		        	xtype: 'customcombobox',
		            name: 'evaluationGroupId',
		            itemId: 'evaluationGroupItemId',
		            store:Ext.create('Academia.store.examinationcenters.evalresultlisting.EvaluationGroup'),
		            displayField:'itemValue',
		            queryParam:'evaluationGroupCode',
		            minChars: 3,
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:false,
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	//	            disabled : true,
		            fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
	//	            allowBlank:true
		            allowBlank:false,		            
		        },{
		        	xtype: 'customcombobox',
		            name: 'studentType', 
		            itemId:'studentTypeId',
		            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.StudentResultStatusEnumStore'),
		            displayField: 'value',
		            valueField: 'id',
		            typeAhead: true,
				    forceSelection:true,  
		            fieldLabel:getExaminationTranslation('STUDENT_TYPE'),
		            hidden:false
	            },]
	    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
        		xtype: 'customcombobox',
				name:'program',
				itemId:'programItemId',
				store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.EGProgramStore'),
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width:460,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:true,
				disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
            },{
	        	xtype: 'customcombobox',
	            name: 'batchId',
	            itemId:'batchIdItemId',
	            store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.EGBatchStore'),
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            disabled : true,
	            fieldLabel:getExaminationTranslation('BATCH'),
	            allowBlank:true
            }]
	    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
		        	xtype: 'customcombobox',
		            name: 'periodId',
		            itemId:'periodItemId',
		            store:Ext.create('Academia.store.examinationcenters.manageEvaluation.evaluationgroup.EGPeriodStore'),
		            displayField:'value',
		            valueField:'id',
		            forceSelection:true,
		            typeAhead:true,
		            minChars:3,
		            disabled : true,
		            fieldLabel:getExaminationTranslation('PERIOD'),
		            allowBlank:true,
					queryParam:'name',
	            },{	
			xtype: 'customcombobox',
    		width:226,
			name:'hallticketgenerated',
			itemId:'hallticketgenerated',
			fieldLabel: getExaminationTranslation('Hall_Ticket_Generated_Report'),
			typeAhead:false,
			value:'ALL',
			valueField: 'id',
            displayField: 'name',
			forceSelection:true,
			store:'examinationcenters.evaluationgroup.HallTicketGeneratedReportStore',
			disabled:false,
			
			},{
			xtype: 'customcombobox',
    		width:226,
			name:'hallticketpublished',
			itemId:'hallticketpublished',
			fieldLabel: getExaminationTranslation('Hall_Ticket_Published_Report'),
			minChars:3,
			typeAhead:false,
			value:'ALL',
			valueField: 'id',
            displayField: 'name',
			forceSelection:true,
			store:'examinationcenters.evaluationgroup.HallTicketPublishedReportStore',
			disabled:false,	
			}]
	        },{   	
	        xtype:'fieldset',
	    	title: getTransportTranslation('MORE_FILTERS'),
	    	layout:'vbox',
	    	frame:true,	
	    	collapsible:true,
	    	collapsed:true,
	    	style:{marginTop: '33px!important',paddingTop:'25px!important'},
	    	width:'100%',
	    	items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 240,
					labelAlign: 'top'
				},
		        items: [{
					xtype: 'customcombobox',
					name:'admissionId',
					itemId:'admissionItemId',
					store: Ext.create('Academia.store.examinationcenters.evaluationgrouplisting.ExamHallTicketStudent'),//'examinationcenters.evaluationgroup.studentcovered.StundentNameCombo',
					fieldLabel: getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:true,
					disabled:true,
					width: 460,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
	        	   xtype: 'customcombobox',
	        	   name: 'hallTicketNo',
	        	   itemId: 'hallTicketNoId',
	        	   displayField: 'value',
	        	   store:Ext.create('Academia.store.examinationcenters.evaluationgroup.StudentHallTicketStore'),
	        	   valueField: 'value',
	        	   minChars:3,
	        	   typeAhead: true,
	        	   forceSelection:true,
					
	        	   disabled:true,
	        	   fieldLabel: getExaminationTranslation('HALL_TICKET_NO'),
	        	   emptyText: getCommonTranslation('ENTER_THREE_CHAR')
	            },]
	    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 240,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	        	name: 'applicationStatus',
	        	store: Ext.create('Academia.store.examinationcenters.evaluationgrouplisting.EvalGroupApplicationStatusForFilter'),
	        	displayField: 'value',
	        	valueField: 'id',
	        	fieldLabel: getExaminationTranslation('APPLICATION_STATUS'),
	        	allowBlank:true,
	        	typeAhead: true,
                forceSelection:true
	        },{
	        	xtype: 'customcombobox',
	        	name: 'feeStatus', 
	        	itemId:'feeStatusId',
	        	store: Ext.create('Academia.store.examinationcenters.evaluationgroup.BillStatusForHallTicket'),
	        	displayField: 'value',
	        	valueField: 'id',
	        	typeAhead: true,
	        	fieldLabel:getExaminationTranslation('FEE_STATUS'),
	        	hidden:false,
                forceSelection:true,
	        	width: 240,
	        }]
	    },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 240,
	            labelAlign: 'top'
	        },
	        items: [{
            	  xtype: 'customcombobox',
	              name: 'centerStatus',
	              fieldLabel: getExaminationTranslation('CENTER_ALLOCATION_STATUS'),
	              store: Ext.create('Academia.store.examinationcenters.roomallocation.StudentBookingStatus'),
	              displayField: 'value',
	              valueField: 'id',
	              allowBlank:true,
                  forceSelection:true,
	              typeAhead: true
            },{
	        	xtype: 'customcombobox',
	            name: 'documentStatus', 
	            itemId:'documentStatusId',
	            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.EvalDocumentPendingSubmittedStatus'),
	            displayField: 'value',
	            valueField: 'id',
	            typeAhead: true,
                forceSelection:true,
	            fieldLabel:getExaminationTranslation('DOCUMENT_STATUS'),
	            hidden:false
            }]
       }]
	},{
		    xtype: 'fieldcontainer',
	        width:'100%',
	        cls:'windowBtnPos',
	        items: [ {
	            xtype: 'button',
	            itemId:'searchBtn',
	            text: getCommonTranslation('SEARCH'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
	            xtype: 'button',
	            text: getExaminationTranslation('GENERATE_HALL_TICKET'),
	            itemId:'generateHallTicket',
	            ui: 'CustomBtnThird',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        }]
	   }]
});