/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.markgrade.markgradedetail.markgradetransformation.StudentBasedTransformationGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.studentbasedtransformationgrid',
    store: 'examinationcenters.markgrade.StudentBasedTransformation',
    border: true,
    autoScroll: true,
    frame:false,
    title:getExaminationTranslation('STUDENT_BASED_LIST'),
    viewConfig: {
        stripeRows:  CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.markgrade.StudentBasedTransformation',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
    columns: [{
        header: getExaminationTranslation('GRADE'),
        dataIndex: 'grade',
        flex:.4,
        sortable:true
    },{
        header: getExaminationTranslation('FROM_RANK'),
        dataIndex: 'rankFrom',
        flex:.3,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name:'rankFrom',
            itemId:'prcntStdFromItemId',
            minValue:0,
            maxValue:999
	    },    
        renderer:function(value,meta){
        	 if(isNullOrEmpty(value)) {
             	meta.tdCls = 'gridInputCustomStyle'; 
             	return getExaminationTranslation('CLICK_TO_ENTER');
             }else{
             	return value;
             }
        }
    }, {
        header: getExaminationTranslation('TO_RANK'),
        dataIndex: 'rankTo',
        flex:.3,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name:'rankTo',
            itemId:'prcntStdTillItemId',
            minValue:0,
            maxValue:999
	    },    
        renderer:function(value,meta){
        	 if(isNullOrEmpty(value)) {
             	meta.tdCls = 'gridInputCustomStyle'; 
             	return getExaminationTranslation('CLICK_TO_ENTER');
             }else{
             	return value;
             }         
        }
    }, {
        header: getExaminationTranslation('MARK_RANGE_FROM'),
        dataIndex: 'markRangeFrom',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('MARK_RANGE_TO'),
        dataIndex: 'markRangeTo',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('STUDENT_COUNT'),
        dataIndex: 'studentCount',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('ALLOW_GRADES'),
        dataIndex: 'allowGrade',
        flex:.3,
        sortable: true,
        editor: {
        	 xtype : 'radiogroup',
		   	 items : [{
		   		 boxLabel : getExaminationTranslation('YES'),
		   		 name : 'grades',
		   		 inputValue : true,
		   		 checked : true
		   	 },{
		   		 boxLabel : getExaminationTranslation('NO'),
		   		 name : 'grades',
		   		 inputValue : false
		   		 
		   	 }]
	    },
	    renderer:function(value){
	    	if(value.grades==false){
	    		return getExaminationTranslation('NO');
	    	}else {
	    		return getExaminationTranslation('YES');
	    	}
	    }
    }],
	plugins: [
             {
                ptype : 'cellediting',
                clicksToEdit: 1
            }
	        ]
});
