/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.DetentionReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.detentionreportform',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	items:[{
    	xtype: 'fieldcontainer',
    	width: '100%',
		layout : 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('INTAKE_YEAR'),
		name : 'intakeYear',
		itemId : 'intakeYear',
		displayField:'value',
		valueField:'id',
		width:226,
		typeAhead:true,
		forceSelection:true,
		minChars:3,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}'  +
				'</div>';
			}
		},
		listeners  :{
			render : function(combo){
				var store=Ext.create('Academia.store.common.IntakeYearStoreByBatchId');
				combo.bindStore(store)
			}
		}
	},{
		xtype : 'customcombobox',
		fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
		name : 'academicTerm',
		itemId : 'academicTerm',
		displayField : 'value',
		valueField : 'id',
		//store:'Academia.store.program.AcademicTermByProgramCategoryStore',
		typeAhead : true,
		allowBlank:false,
		forceSelection : true,
		listeners  :{
			beforerender : function(combo){
				var store=Ext.create('Academia.store.program.AcademicTermByProgramCategoryStore');
				combo.bindStore(store)
			}
		}
	}]},{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'program.programDetails.programBatches.courseParameter.ProgramCourseByCourseIdStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			disabled: true,
			displayField: 'valueCode',
			queryParam:'programName',
			minChars:3,
			//width:460,
			//allowBlank:false,
			//typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			/*listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}*/
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'common.BatchesByProgramId',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			width:226,
			disabled:true,
			//allowBlank:false,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			disabled:true,
			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			width:226,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionItemId',
			disabled:true,
			store:'attendance.SectionAndFacultyByPeriodID',
			fieldLabel:getExaminationTranslation('SECTION'),
			valueField: 'sectionId',
			displayField: 'sectionCode',
			width:226,
			typeAhead:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'evaluationplanno',
			itemId:'evalautionPlanNoItemId',
			store:'examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanDetainedStudent',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'evaluationPlanNumber',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}	
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
		    store:'attendance.VariantMappedToPlan',
			displayField: 'value',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			disabled:true
		}]	
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
        	xtype : 'customcombobox',
        	name : 'detailSequenceId',
        	itemId:'detailSequenceItemId',
        	fieldLabel : getExaminationTranslation('DETAILED_SQUENCE'),
        	store : 'examinationcenters.manageEvaluation.DetailSequence',
        	valueField : 'id',
        	displayField : 'value',
        	typeAhead:true,
			forceSelection:true,
			disabled:true
       },{
           xtype: 'checkboxfield',
           width: 'auto',
           labelAlign: 'right',
           itemId:'viewAllowedStudentListItemId',
           name: 'isAllowedStudent',
           boxLabel: getExaminationTranslation('VIEW_ALLOWED_STUDENT_LIST'),
           inputValue : true,
           uncheckedValue: false,
           style:{
       	   marginTop:'28px'
           }
       }]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
