/**
 * @author AkasH
 */
Ext.define('Academia.view.examinationcenters.reports.PeriodWiseExamLevelReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.periodwiseexamlevelreportgrid',
    store: 'examinationcenters.reports.PeriodWiseExamLevelReportStore',
    title: getExaminationTranslation('PERIOD_LEVEL_REPORT'),
    border: true,
    refreshStoreData: true,
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.reports.PeriodWiseExamLevelReportStore',
            emptyMsg: getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: ['->', {
        xtype: 'button',
        itemId: 'viewSaveTabulationReportsId',
        tooltip: getCommonTranslation('VIEW_SAVED_TABULATION_REGISTERS'),
        text: getCommonTranslation('VIEW_SAVED_TABULATION_REGISTERS'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'exportTabulationReportsId',
        tooltip: getCommonTranslation('EXPORT_GENERATE_TABULATION_REGISTOR'),
        text: getCommonTranslation('EXPORT_GENERATE_TABULATION_REGISTOR'),
        disabled: true
    }, {
        xtype: 'button',
        itemId: 'exportReportBtn',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('ADMISSION_CODE'),
        dataIndex: 'admissionCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('FIRST_NAME'),
        dataIndex: 'firstName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('MIDDLE_NAME'),
        dataIndex: 'middleName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('LAST_NAME'),
        dataIndex: 'lastName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('BATCH_NAME'),
        dataIndex: 'batchName',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('PERIOD_NAME'),
        dataIndex: 'periodName',
        flex: 1
    }, {
        header: getCommonTranslation('OUT_OF_MARKS'),
        dataIndex: 'marksObtainedFrom',
        flex: 1
    }, {
        header: getCommonTranslation('MARKS_OBTAINED'),
        dataIndex: 'obtainedMarks',
        flex: 1
    }, {
        header: getCommonTranslation('TOTAL_CREDIT_SUM_A'),
        dataIndex: 'creditSum',
        flex: 1
    }, {
        header: getCommonTranslation('OBTAIN_CREDIT_SUM'),
        dataIndex: 'obtainedCreditSum',
        flex: 1
    }, {
        header: getCommonTranslation('CREDIT_GRADE_POINT_SUM_A'),
        dataIndex: 'creditGradePointSum',
        flex: 1
    }, {
        header: getCommonTranslation('OBTAIN_GRADE_POINT_SUM'),
        dataIndex: 'obtainedGradePointSum',
        flex: 1
    }, {
        header: getCommonTranslation('ACCUMULATIVE_CREDIT_SUM'),
        dataIndex: 'accumulatedCreditSum',
        flex: 1
    }, {
        header: getCommonTranslation('ACCUMULATIVE_CGPA'),
        dataIndex: 'accumulatedCGPA',
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD_RANK'),
        dataIndex: 'periodRank',
        flex: 1
    }, {
        header: getCommonTranslation('SGPA'),
        dataIndex: 'sgpa',
        flex: 1
    }, {
        header: getCommonTranslation('EXAM_RESULT_STATUS'),
        dataIndex: 'status',
        flex: 1,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(value))
                return getExaminationTranslation(value);
            else
                return '';
        }
    }, {
        header: getCommonTranslation('STATUS'),
        dataIndex: 'activeInactiveStatus',
        flex: 1,
        hidden: true,
        renderer: function (value, meta, record) {
            if (!isNullOrEmpty(value))
                return getExaminationTranslation(value);
            else
                return '';
        }
    }, {
        header: getCommonTranslation('GPA'),
        dataIndex: 'academicTermGpa',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('ACADEMICS_STANDING'),
        dataIndex: 'academicStanding',
        flex: 2
    }, {
        header: getCommonTranslation('SPA'),
        dataIndex: 'spa',
        flex: 1,
        hidden: true
    }, {
        header: getCommonTranslation('CPA'),
        dataIndex: 'cpa',
        flex: 1,
        hidden: true
    }]
});
