/**
 * @author Deepika P
 */
Ext.define('Academia.view.examinationcenters.reports.StudentLevelRemarkReportGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentlevelremarkreportgrid',
	store: 'examinationcenters.remark.StudentLevelRemarkReportGridStore',
	title:getCommonTranslation('STUDENT_LEVEL_REMARK_REPORT'),
	border: true,
	cls: 'assignRemarkTableLayout',
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.remark.StudentLevelRemarkReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [],
	columns: [{
		header: getCommonTranslation('SERIAL_NO'),
		xtype: 'rownumberer',
		sortable: false,
		align:'center',
		flex:.1,
		dataIndex:'rownumberer',
		locked: false,
		renderer: function (value, meta, record, rowIndex) {
			if(isNullOrEmpty(record.get('fromTransferSectionId'))){
				meta.tdCls = 'blackCell';
			}
			return rowIndex+1;
		}
	},{
		header: getCommonTranslation('STUDENT_IMAGE'),
		dataIndex: 'photoUrl',
		sortable:false,
		flex:.1,
		renderer: function(value, metaData) {
			if(!isNullOrEmpty(this.xtype) && this.xtype.toLowerCase() != "exportallgrid"){
				metaData.tdAttr = 'type="gridImageCell"';
				if(!isNullOrEmpty(value) && value !=0){
					//var extension=value.substring(value.length-4, value.length);
					var extensionArr = value.split(".");
					var imageUrl="resources/images/uploads"+extensionArr[extensionArr.length - 2]+"_icon."+extensionArr[extensionArr.length - 1];
					value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px;">';
					return value;
				}else{
					var imageUrl="resources/images/profile_student.png";
					value='<img src="'+imageUrl+'" height="50" width="50" style="margin-top:-10px; margin-bottom:-10px">';
					return value;
				}
			}
		}
	},{
		header: getCommonTranslation('ADMISSION_CODE'),
		dataIndex: 'admissionCode',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('FIRST_NAME'),
		dataIndex: 'firstName',
		flex:.1
	},{
		header: getCommonTranslation('MIDDLE_NAME'),
		dataIndex: 'middleName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('LAST_NAME'),
		dataIndex: 'lastName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('GENDER'),
		dataIndex: 'gender',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				return getExaminationTranslation(val);
			}
		}
	},{
		header: getCommonTranslation('SECTION_ID'),
		dataIndex: 'sectionId',
		flex:.1
	},{
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable: true
	},{
		header: getCommonTranslation('AVERAGE_MARKS'),
		dataIndex: 'marksAverage',
		flex:.1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val) && val>0){
				return val;
			}else{
				return '-';
			}
		}
	},{
		header: getCommonTranslation('STUDENT_REMARK'),
		dataIndex: 'remark',
		flex:.2,
		sortable:true,
		editor : {
			xtype: 'textfield',
			name:'remarkValue',
			itemId:'remarkValueItemId',
			maxLength:2048,
			editable:false,

		},
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
				return null;
			}else{
				rec.tdAttr = 'data-qtip="' + val + '"';
				rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
				rec.tdCls ="assign-remark-column-cls";
				return val;
			}
		}
	}]
});
