/**
 * @author Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.reports.ViewSaveTabulationRegisterWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.viewsavetabulationregisterwin',
	title : getCommonTranslation('VIEW_SAVED_TABULATION_REGISTERS'),
	modal: true,
	autoScroll:true,
	//maxHeight:250,
	width: '65%',
	height:'40%',
	items: [{
		xtype:'grid',
		itemId:'viewSaveTabulationRegisterGrid',
		store :  'examinationcenters.reports.ViewSavedTabulationGridStore',
		border: true,
		autoScroll: false,
		refreshStoreData:true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store :    'examinationcenters.reports.ViewSavedTabulationGridStore',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		
		columns: [
		{
			header : getCommonTranslation('EVALUATION_GROUP'),
			dataIndex : 'evaluationGroupName',
			flex : 1,
			sortable:true
		},
		{
			header : getCommonTranslation('TABULATION_REGISTER_NAME'),
			dataIndex : 'tabulationRegisterName',
			flex : 1,
			sortable:true,
			renderer :function(value,record){
				if(!isNullOrEmpty(value)){
    				return  getExaminationTranslation(value);
    			}
			}
		},
		{
			header : getCommonTranslation('GENERATED_BY'),
			dataIndex : 'generatedBy',
			flex : 1,
			sortable:true
		},{
			header : getCommonTranslation('GENERATION_DATE'),
			dataIndex : 'generatedDate',
			flex : 1,
			sortable:true,
			renderer :function(value,record){
				if(!isNullOrEmpty(value)){
					var val = new Date(value);
					var formatedDate = moment(val, "DD/MM/YYYY").format("DD/MM/Y");
					return formatedDate;
    			}
			}
			
		},{
			header : getCommonTranslation('TABULATION_REGISTER'),
			dataIndex : 'path',
			flex : 1,
			sortable:true,
			renderer :function(value,record){
				if(!isNullOrEmpty(value)){
    				return  '<a href="#">'+value+'</a>';
    			}
			}
		}]
	}]
});