/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.examinationcenters.roomallocation.studentallocation.CenterRoomAllocationGrid', {
  //  extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.centerroomallocationgrid',
    store : 'examinationcenters.roomallocation.CenterRoomAllocation',
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('CENTER_ROOM_ALLOCATION_LIST'),
    viewConfig: {
        stripeRows: true
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
	            store : 'examinationcenters.roomallocation.CenterRoomAllocation',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },

    tbar: [{
    	xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getExaminationTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getExaminationTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getExaminationTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getExaminationTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{	
		xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getCommonTranslation('MOREACTIONS'),//More Actions
        menu:[{
            text:getExaminationTranslation('STUDENT_ROOM_ALLOCATION'),
            itemId:'studentRoomAllocationLink'
        },{
            text:getExaminationTranslation('ASSIGN_INVIGILATOR'),
            itemId:'assignInvigilatorLink'
        }],
        listeners: { click: function() { this.showMenu(); } }
    }],
    columns: [{
		  	header : getExaminationTranslation('EVALUATION_GROUP'),
		  	dataIndex : 'evaluationGroupCode',
		  	flex:1
       },{
            header : getExaminationTranslation('COURSE_NAME'),
	        dataIndex : 'courseName', 
	        flex:1
       },{
            header : getExaminationTranslation('CENTER_NAME'),
	        dataIndex : 'centerName',
	        flex:1
       },{
           header : getExaminationTranslation('SCHEDULE_DATE'),
	        dataIndex : 'scheduleDate',
	        flex:1,
	        renderer:function(val){		
				return dateRender(val);
			}
       },{
           header : getExaminationTranslation('BATCH_NAME'),
	        dataIndex : 'batchName',
	        flex:1
       },{
           header : getExaminationTranslation('ROOM_NO'),
	        dataIndex : 'roomNo',
	        flex:1
       },{
           header : getExaminationTranslation('ROOM_CAPACITY'),
	        dataIndex : 'roomCapacity',
	        flex:1
      },{
           header : getExaminationTranslation('INVIGILATOR'),
	        dataIndex : 'invigilator',
	        flex:1
	    }]
});
