/**
 * Raghavendra.Soni
 **/
var ThesisManagementGridStore = Ext.create('Academia.store.examinationcenters.thesisManagement.ThesisManagementGridStore');
Ext.define('Academia.view.examinationcenters.thesisManagement.StudentThesisManagementGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentthesismanagementgrid',
	store: ThesisManagementGridStore,
    title: getCommonTranslation('THESIS_MANAGEMENT_LIST'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'personinfostudentportal': (localStorage.getItem("portalId")==7) ? 7 : 3
		}
	},
	isGridConfigurable: true,
	//enableColumnHide: false,
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: ThesisManagementGridStore,
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnSubmitThesis',
		text:getCommonTranslation('SUBMIT_THESIS'),
		disabled:true
	}],
    columns: [{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: 1,
        sortable: true,
    }, {
        header: getCommonTranslation('THESIS_STATUS'),
        dataIndex: 'thesisStatus',
        flex: 1,
        sortable: true
    }, {
    	header: getCommonTranslation('SUPERVISIOR'),
    	dataIndex: 'supervisorName',
    	flex: 1,
    	sortable: true,
    	hidden: true,
    	renderer: function(value, meta, record) {
    		if (!isNullOrEmpty(record.data.supervisorCount) && record.data.supervisorCount > 1) {
    			return "<a href='#'>" + record.data.supervisorCount + "</a>";
    		}
    		return value;
    	}
    }, {
        header: getCommonTranslation('THESIS_DOCUMENT'),
        dataIndex: 'thesisDocument',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
        	if (!isNullOrEmpty(record.raw.thesisDocumentCount) && record.raw.thesisDocumentCount > 0) {
        		return "<a href='#'>"+"View Details"+"</a>";
        	}else{
        		return "-"; 
        	}
        }
    }]
});
