/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.examinationdegreeremark.DegreeClassificationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.degreeclassificationgrid',
    title: getCommonTranslation('DEGREE_CLASSIFICATION_LIST'),
    store:'examinationdegreeremark.DegreeClassificationGridStore',
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
       xtype: 'button',
       itemId: 'btnAdd_dc',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
   }, {
       xtype: 'button',
       itemId: 'btnEdit_dc',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnDelete_dc',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnApplyTo_dc',
       tooltip: getCommonTranslation('APPLY_TO'),
       text: getCommonTranslation('APPLY_TO'),
       disabled: true
   }],
    columns: [{
        header: getCommonTranslation('DEGREE_CLASSIFICATION_NAME'),
        dataIndex: 'classificationName',
        flex:1
    },{
        header: getCommonTranslation('DEGREE_CLASSIFICATION_FOR'),
        dataIndex: 'degreeClassificationType',
        flex:1,
        renderer: function(value){
        	if(!isNullOrEmpty(value) && value!=0){
        		return getCommonTranslation(value);
        	}else{
        		return '';
        	}
        }
    },{
        header: getCommonTranslation('MARKING_TYPE'),
        dataIndex: 'programMarkingType',
        flex:1,
        renderer: function(value){
        	if(!isNullOrEmpty(value) && value!=0){
        		return getCommonTranslation(value);
        	}else{
        		return '';
        	}
        }
    }, {
        header: getCommonTranslation('PROGRAMS_ASSOCIATED'),
        dataIndex: 'programsAssociated',
        flex:1,
        renderer: function(value){
        	if(!isNullOrEmpty(value) && value!=0){
        		return '<a href="#">'+value+'</a>';
        	}else{
        		return '';
        	}
        }
    }],
    initComponent: function() {
        var this$ = this;
        Ext.apply(this$, {
            store: 'examinationdegreeremark.DegreeClassificationGridStore',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: 'examinationdegreeremark.DegreeClassificationGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    }
});