/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of academy locations in grid
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingFormAcademyLocationGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookingacadlocgrid',
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    title: getCommonTranslation('LIST_OF_Academy_Location'), //List Of Academy-Location		
    selType: 'checkboxmodel',    
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'), //Academy Location
        dataIndex: 'value',
        flex: .3
    }],
    initComponent: function() {
        Ext.apply(this, {
        	selModel:Ext.create('Ext.selection.CheckboxModel',{            	
        		checkOnly: false,
        		multiSelect :true,
        	    mode: 'SIMPLE',
            	showHeaderCheckbox : false
            }),
        	//selType: 'checkboxmodel',
        	store: Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationListByUserStore')
        });
        this.callParent(arguments);
    },
    tbar:[{
        xtype: 'checkboxfield',
        boxLabel: getCommonTranslation('ORG_SCHEDULE_EVENTS'), //Show event in Organization schedule
        itemId: 'orgScheduleEvents',
        name: 'orgScheduleEvents',
        inputValue: 'true',
        uncheckedValue: 'false'        
    },{
	    xtype: 'button',
	    tooltip: getCommonTranslation('VIEW_CALENDAR'), //View Calendar  
	    itemId: 'btnViewCalendar',
	    text:getCommonTranslation('VIEW_CALENDAR') //View Calendar
	}]
});