/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show list of events (booking resources). 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.ResourceBookingGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.resourcebookinggrid',
    store: 'facilitiesresources.resourcebooking.ResourceBookingStore',
   /* requires : ['Academia.view.facilitiesresources.resourcebooking.ResourceFeedBackWindow' ], */
    title: getCommonTranslation('LIST_OF_SCHEDULED_EVENTS'), //List of scheduled events
    border: true,
	autoScroll:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getCommonTranslation('EVENT_ID'), //Event ID
        dataIndex: 'id',
        flex: .1
    }, {
        header: getCommonTranslation('EVENT_NAME'), //Event Name
        dataIndex: 'eventName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('PURPOSE'), //Purpose
        dataIndex: 'bookingPurpose',
        flex: .2,
        renderer: function(object) {
            return comboRender(object, 'value');
        }
    }, {
        header: getCommonTranslation('CREATED_BY'), //Created By
        dataIndex: 'bookedBy',
        flex: .1,
        renderer: function(object) {
            return comboRender(object, 'value');
        }
    }, {
        header: getCommonTranslation('EVENT_DATE'), //Event Date
        dataIndex: 'eventDate',
        flex: .1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('PROGRAM_BATCH_SECTION'), //Program-Batch-Section
        dataIndex: 'resourceBookingPrograms',
        flex: .1,
        renderer: function(value) {
            var programBatchSection = "";
            if (value instanceof Array) {
                Ext.each(value, function(object) {
                    programBatchSection += ((isNullOrEmpty(comboRender(object.program, 'value'))) ? 'Not Available' : comboRender(object.program, 'value')) + '  -  ';
                    programBatchSection += ((isNullOrEmpty(comboRender(object.batch, 'value'))) ? 'Not Available' : comboRender(object.batch, 'value')) + '  -  ';
                    programBatchSection += (isNullOrEmpty(comboRender(object.section, 'value'))) ? 'Not Available' : comboRender(object.section, 'value');
                    programBatchSection += ',<br>';
                });
                if (programBatchSection.length > 0) {
                    return programBatchSection = programBatchSection.substring(0, programBatchSection.length - 5);
                }
            } else {
                return programBatchSection;
            }
        }
    }, {
        header: getCommonTranslation('COURSE'), //Course
        dataIndex: 'courses',
        flex: .1,
        renderer: function(value) {
            var courses = "";
            if (value instanceof Array) {
                Ext.each(value, function(object) {
                    courses += (isNullOrEmpty(comboRender(object, 'value'))) ? 'Not Available' : comboRender(object, 'value');
                    courses += '<br>,';
                });
                if (courses.length > 0) {
                    return courses = courses.substring(0, courses.length - 1);
                }
            } else {
                return courses;
            }
        }
    }, {
        header: getCommonTranslation('CONFIRM_ADHOC_RESOURCE'), //Confirm Adhoc Resource
        dataIndex: 'adhocStatus',
        flex: .1,
        renderer: function(value) {            
            if (value === getCommonTranslation('CONFIRMED')) {
                return getCommonTranslation('CONFIRMED');
            } else if(value === getCommonTranslation('PENDING')) {
                return getCommonTranslation('PENDING');
            }else if(value === getCommonTranslation('UNAVAILABLE')) {
            	return '-';
            }else{
            	return '';
            }
        }
    }],
    tbar: [
    	{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD_RESOURCE_BOOKING_DETAILS'),
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, 
    {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT_RESOURCE_BOOKING_DETAILS'),
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW_RESOURCE_BOOKING_DETAILS'),
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE_RESOURCE_BOOKING'),
        glyph: ICONGLYPH.DELETEGLYPH
        //text : getCommonTranslation('DELETE')
    }, {
        xtype: 'splitbutton',
        itemId: 'spBtnResourceBookingMoreActions',
        text: getCommonTranslation('MOREACTIONS'), //More Actions
        tooltip: getCommonTranslation('MOREACTIONS'), //Click on this you can perform some extra operations
        menu: [{
            text: getCommonTranslation('FEEDBACK'), //Feedback
            itemId: 'resourceFeedbackMenu',
            tooltip: getCommonTranslation('FEEDBACK_QTIP') //Enter feedback of assigned resources to a selected event
        }, {
            text: getCommonTranslation('CONFIRM_ADHOC_RESOURCE'), //Confirm Adhoc Resource
            itemId: 'resourceADhocConfirmMenu',
            tooltip: getCommonTranslation('ADHOC_RESOURCE_QTIP') //Confirm/delete adhoc resource request of selected event 
        }],
        listeners: { click: function() { this.showMenu(); } }
    }],
    dockedItems: [{
    	xtype: 'toolbar',
    	dock: 'bottom',
    	items: [{
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		displayInfo: true,
    		emptyMsg: getCommonTranslation('EMPTY_RESOURCE_BOOKING_MESSAGE'), //No scheduled events to display
    		store: 'facilitiesresources.resourcebooking.ResourceBookingStore'
    	}]
    }],
    showResourceFeedbackWindow: function() {
        var winResourceFeedback = Ext.widget('resourcefeedbackwindow');
        winResourceFeedback.show();
    }
});