/*
 * This static grid is used for to excel export.  
 *
 *
 *
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.staticgridexcelexport',
    requires: 'Ext.form.action.StandardSubmit',
    reserveScrollbar: true,
    exportToolBarItems: [
       '->',{
        xtype: 'splitbutton',
        itemId: 'btnExportToPDF',
        cls: 'CustomToolbarBtnExport export-cls',
        iconCls:'export-pdf-icon',
        menu: [{
            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
            itemId: 'exportPDFCurrentPage',
            handler: function(item, e, eOpts) {
           	    var grid=item.up('splitbutton').gridRef;
           	    if(grid.xtype == 'evaluationremarkgrid') {
           	    	var frm = grid.up('evaluationremarkmasterstructure').down('evaluationremarkquickfilter');
           	        var formValues = frm.getValues();
           	        if(formValues.evaluationplantype == 'ACADEMICS') {
	           	    	grid.exportExamAssignRemarkReport('currentPDF');
	           	    	return;
           	        }
           	    }
           	    if(grid.xtype=="studentcoursereportgrid" || grid.xtype=="studentcoursereportbyperiodgrid"){
           	    	try{
           	    		var currentTab = grid.up('contentpanel').getActiveTab();
           	    		var personInfo = currentTab.personInfo;
           	    		var studentName = (!isNullOrEmpty(personInfo.firstName)?personInfo.firstName:"")+(!isNullOrEmpty(personInfo.middleName)?" "+personInfo.middleName:"")+(!isNullOrEmpty(personInfo.lastName)?" "+personInfo.lastName:"");
           	    		var studentId = !isNullOrEmpty(personInfo.code)?personInfo.code:currentTab.title;
           	    		if(portalId==7){
           	    			var studentId = this$.getCurrentlyLoggedInUserInfoForPortal().student.code;
           	    		}
           	    		grid.studentName = studentName;
           	    		grid.studentId = studentId;
           	    	}
           	    	catch(e){
           	    		
           	    	}
           	    }
           	    
           	    if(Ext.isDefined(grid.itemId) && ( grid.itemId=='studentEducationHistoryGrid' || grid.itemId=='applicantEducationHistoryGrid' || grid.itemId=='facultyEducationHistoryGrid'))
           	    {
           	    	grid.exportAllGridData(grid,true,false);  
           	    }else{
           	    	if( Ext.isDefined(grid.xtype) && grid.xtype=='educationdetailgrid' ){
           	    		grid.exportAllGridData(grid,true,false);
           	    	} else{
           	    		grid.exportCurrentPdfData(grid);
           	    	}
           	    }
        		setTimeout(function(){
            		refreshHeader(grid); 
        		},500);              	        
            }		            	
        }, {
            text: getCommonTranslation('EXPORT_ALL_COMMON'), 
            itemId: 'exportPDFAll',
            handler: function(item, e, eOpts) {            	
            	var grid=item.up('splitbutton').gridRef;
            	if(grid){
            		if(grid.xtype == 'evaluationremarkgrid') {
            			var frm = grid.up('evaluationremarkmasterstructure').down('evaluationremarkquickfilter');
               	        var formValues = frm.getValues();
               	        if(formValues.evaluationplantype == 'ACADEMICS') {
	            			grid.exportExamAssignRemarkReport('allPDF');
	               	    	return;
               	        }
               	    }
            		
            		if(grid.xtype == "billheaderpcgrid"){
                        grid.exportManageBillGridExcel(grid,'allPDF');
                        return;
                   }
            		
            		if(grid.xtype=="studentcoursereportgrid" || grid.xtype=="studentcoursereportbyperiodgrid"){
               	    	try{
               	    		var currentTab = grid.up('contentpanel').getActiveTab();
               	    		var personInfo = currentTab.personInfo;
               	    		var studentName = (!isNullOrEmpty(personInfo.firstName)?personInfo.firstName:"")+(!isNullOrEmpty(personInfo.middleName)?" "+personInfo.middleName:"")+(!isNullOrEmpty(personInfo.lastName)?" "+personInfo.lastName:"");
               	    		var studentId = !isNullOrEmpty(personInfo.code)?personInfo.code:currentTab.title;
               	    		if(portalId==7){
               	    			var studentId = this$.getCurrentlyLoggedInUserInfoForPortal().student.code;
               	    		}
               	    		grid.studentName = studentName;
               	    		grid.studentId = studentId;
               	    	}
               	    	catch(e){
               	    		
               	    	}
               	    }
            		
            		try{
            			refreshHeader(grid);
            		}
            		catch(e){}
            		if(Ext.isDefined(grid.itemId) && (grid.itemId=='compareRoleGridItemId' || grid.itemId=='definetopiccoverageformgridItemId' || grid.itemId=='assigncourseslistItemId' || grid.xtype== "editcoursesectionlistgrid" || grid.xtype== "studentjourneycoreerpgrid" || grid.xtype== "prereqnotmetreportgrid")){
            			grid.exportCurrentPdfData(grid);
            		}
            		else{
            			grid.exportAllGridData(grid,true,false);                	                    	
            		}            	     
            		setTimeout(function(){
                		refreshHeader(grid); 
            		},500);       
            	}		     
            }		     
        } ]
    },{
        xtype: 'splitbutton',
        itemId: 'btnExportToExcel',
        cls: 'CustomToolbarBtnExport export-cls',
        iconCls:'export-excel-icon',
        menu: [{
            text: getCommonTranslation('EXPORT_CURRENT_PAGE_COMMON'), 
            itemId: 'exportExcelCurrentPage',
            handler: function(item, e, eOpts) {
            	var grid=item.up('splitbutton').gridRef;
            	if(grid.xtype == 'evaluationremarkgrid') {
            		var frm = grid.up('evaluationremarkmasterstructure').down('evaluationremarkquickfilter');
           	        var formValues = frm.getValues();
           	        if(formValues.evaluationplantype == 'ACADEMICS') {
           	        	grid.exportExamAssignRemarkReport('currentExcel');
           	        	return;
           	        }
           	    }
            	if(grid.xtype == "placementdetailreportgrid" || grid.xtype=="studentcoursereportgrid" || grid.xtype=="studentcoursereportbyperiodgrid"){
           	    	try{
           	    		var currentTab = grid.up('contentpanel').getActiveTab();
           	    		var personInfo = currentTab.personInfo;
           	    		var studentName = (!isNullOrEmpty(personInfo.firstName)?personInfo.firstName:"")+(!isNullOrEmpty(personInfo.middleName)?" "+personInfo.middleName:"")+(!isNullOrEmpty(personInfo.lastName)?" "+personInfo.lastName:"");
           	    		var studentId = !isNullOrEmpty(personInfo.code)?personInfo.code:currentTab.title;
           	    		if(portalId==7){
           	    			var studentId = this$.getCurrentlyLoggedInUserInfoForPortal().student.code;
           	    		}
           	    		grid.studentName = studentName;
           	    		grid.studentId = studentId;
           	    	}
           	    	catch(e){
           	    		
           	    	}
           	    }
            	grid.exportCurrentExcelData(grid);
            	setTimeout(function(){
            		refreshHeader(grid); 
            	},500); 
            }
        }, {
            text: getCommonTranslation('EXPORT_ALL_COMMON'), 
            itemId: 'exportExcelAll',
            handler: function(item, e, eOpts) {            	
            	var grid=item.up('splitbutton').gridRef;
            	if(grid){
            		if(grid.xtype == 'evaluationremarkgrid') {
            			var frm = grid.up('evaluationremarkmasterstructure').down('evaluationremarkquickfilter');
               	        var formValues = frm.getValues();
               	        if(formValues.evaluationplantype == 'ACADEMICS') {
	            			grid.exportExamAssignRemarkReport('allExcel');
	               	    	return;
               	        }
               	    }
            		if(grid.xtype == "receiptheaderlist"){
            			grid.exportreceiptheaderlistexcel(grid);
            			return;
            		}else if(grid.xtype == "receiptheaderlistforapplicant"){
						grid.exportreceiptheaderApplicantlistexcel(grid);
					    return;
					}

               /*    -------------- Adding for Exporting Statement of Account ------------*/

					if(grid.xtype == "actualaccountstatementgrid" || grid.xtype == 'actualapplicantaccountstatementgrid' || grid.xtype == 'actualsponsoraccountstatementgrid' ){
                         grid.exportActualaccountStatementGridExcel(grid);
                         return;
                    }
					
		               /*    -------------- Adding for Exporting Manage Bill ------------*/

					if(grid.xtype == "billheaderpcgrid"){
                        grid.exportManageBillGridExcel(grid,'allExcel');
                        return;
                   }
					
				   /*    -------------- Adding for Exporting intellimali export all screen ------------*/
					if(grid.xtype == "intellimaligrid"){
                        grid.exportIntellimaliGridExcel(grid);
                        return;
                   }

            		else if(grid.xtype == "bulkExamResultPublishGrid") {
            			grid.exportBulkExamResultPublishExcel(grid);
            			return;
            		}
            		else if(grid.xtype=="studentcoursereportgrid" || grid.xtype=="studentcoursereportbyperiodgrid"){
               	    	try{
               	    		var currentTab = grid.up('contentpanel').getActiveTab();
               	    		var personInfo = currentTab.personInfo;
               	    		var studentName = (!isNullOrEmpty(personInfo.firstName)?personInfo.firstName:"")+(!isNullOrEmpty(personInfo.middleName)?" "+personInfo.middleName:"")+(!isNullOrEmpty(personInfo.lastName)?" "+personInfo.lastName:"");
               	    		var studentId = !isNullOrEmpty(personInfo.code)?personInfo.code:currentTab.title;
               	    		if(portalId==7){
               	    			var studentId = this$.getCurrentlyLoggedInUserInfoForPortal().student.code;
               	    		}
               	    		grid.studentName = studentName;
               	    		grid.studentId = studentId;
               	    	}
               	    	catch(e){
               	    		
               	    	}
               	    }
            		try{
            			refreshHeader(grid);
            		}
            		catch(e){} // V2D-103990
            		if(Ext.isDefined(grid.itemId) && (/*grid.itemId=='evaluationremarkgridId' || grid.itemId=='classteacherremarkgridId' || */
            				grid.itemId=='compareRoleGridItemId' || grid.itemId=='definetopiccoverageformgridItemId' || grid.itemId=='assigncourseslistItemId' || grid.xtype== "editcoursesectionlistgrid" || grid.xtype== "studentjourneycoreerpgrid" || grid.xtype== "prereqnotmetreportgrid")){
            			grid.exportCurrentExcelData(grid);
            		}
            		else{
            			//if ( grid.xtype != 'programgroupcombinationsgrid') {
            				grid.exportAllGridData(grid,false,true);  
    					//}
            		}
            		setTimeout(function(){
                		refreshHeader(grid); 
            		},500);
            	}        
            }		     
        }]
    }],
    //*******************************Export Current Pdf******************************************
    exportCurrentPdfData:function(grid){
    	try{
	    	var baseController=Academia.app.getController('base.BaseController');
	    	var gridStore=grid.getStore();
	    	var records = gridStore.getRange();
    		if(grid.xtype == 'applicationdocumentsandnotesgrid' && records.length > 0){
    			for(var i in records){
	      			if(!isNullOrEmpty(records[i].get('description')) && records[i].get('description').length > 10000) {
	      				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UNABLE_TO_DOWNLOAD_PDF'));
	      				return;
	  				  }
    		     } 
			}else if(grid.xtype == 'academicstopicquicksearchgrid' && records.length > 0){
    			for(var i in records){
	      			if(!isNullOrEmpty(records[i].get('description')) && records[i].get('description').length > 10000) {
	      				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UNABLE_TO_DOWNLOAD_PDF'));
	      				return;
	  				  }
    		     } 
			}
	    	var currentPageSize = gridStore.pageSize;
	    	var activeTab=baseController.getTabReferenceByTabTitle("");
	    	if(activeTab){
	    		if(!grid.removeSerialColumn){
	    			var headerCount = grid.columnManager.getColumns().length+1; //+1 for S.No.
	    	    	
	    		}else{
	    			var headerCount = grid.columnManager.getColumns().length;
	    		}
	    		var academyLocation=baseController.getCurrentAcademyLocation();
	    		if(!isNullOrEmpty(academyLocation)){
	    			var params=new Object();
	    			params.academyLocationId=academyLocation;
	    			var displayName = baseController.getAcademyLocationDisplayName(academyLocation);
	    			baseController.sendGetAjaxRequest(SERVERURL.GET_ACADEMY_LOCATION_LOGO, 'GET', params, function(option, success, response) {
	    				if(success){
	    					var myMask = new Ext.LoadMask(activeTab,{msg:"Please wait..."});
	    					myMask.show();
	    					if(!isNullOrEmpty(response.responseText)){
	    						var imageDataObject = Ext.decode(response.responseText);
	    						if(!isEmpty(imageDataObject)){
	    							
	    							var isExport = exportToPDF(grid.id,myMask,grid.title,imageDataObject.code,imageDataObject.value,displayName, headerCount,grid);
	    							if(isExport){
	    								Ext.getBody().unmask();
	    							}
	    						}   
	    					}else{ //For Default Logo
	    						baseController.sendGetAjaxRequest(SERVERURL.GET_ACADEMY_LOCATION_DEFAULT_LOGO, 'GET', null, function(option, success, response) {
	    							if(success){               
	    								if(!isNullOrEmpty(response.responseText)){
	    									var imageDataObject = Ext.decode(response.responseText);
	    									if(!isEmpty(imageDataObject)){
	    										var isExport = exportToPDF(grid.id,myMask,grid.title,imageDataObject.code,imageDataObject.value,displayName, headerCount,grid);
	    										if(isExport){
	    											Ext.getBody().unmask();
	    										}
	    									}
	    								}                                        			
	    							}
	    						});	
	    					}                        			
	    				}
	    			});
	    		}            			            			        				   
	    	}             		             	                	   
    	} catch(e){
    		//TODO 
    		Ext.getBody().unmask();
    		console.log(e);
    	}
     },
    //******************************Export Current Excel ********************************************
    exportCurrentExcelData:function(grid){
    	var baseController=Academia.app.getController('base.BaseController');
    	if(grid){  
     		var activeTab=baseController.getTabReferenceByTabTitle("");
     		if(activeTab){
     			var academyLocation=baseController.getCurrentAcademyLocation();
    			if(!isNullOrEmpty(academyLocation)){
    				var params=new Object();
    				params.academyLocationId=academyLocation;
    				var displayName = baseController.getAcademyLocationDisplayName(academyLocation);
   					var myMask = new Ext.LoadMask(activeTab, {msg:"Please wait..."});
			       	myMask.show();
			       	isExported=grid.downloadExcelXml(grid.id,grid,displayName);
			       	if(isExported){
			       		myMask.hide();
			       	}                            	
    			}	
     		}             		             	                	   
     	}
    },
    //*****************************************************************************************************
    getParentPanel:function(grid){
    	var parentPanel=grid;
    	while(parentPanel.up('panel').xtype != "contentpanel" && parentPanel.up('panel').xtype != "panel" ){
    		parentPanel=parentPanel.up('panel');
    	}
    	return parentPanel;
    },
    copyColumnsFormColumnManager:function(grid,cloneGrid){    
    	var cloneGridColumns=[];
    	Ext.each(grid.columnManager.columns, function(column){
    		
    		var headerText=column.header;
    		if(!headerText)
    			headerText=column.text;
    		 var data={
					   header:headerText,
  					   dataIndex:column.dataIndex,
  					   flex:column.flex
			     };
    		 
			cloneGridColumns.push(data);
		});
    	cloneGrid.columns=cloneGridColumns;
    	
    },
    /*
    	Add export tool bar items to extended grid panel
    */
    exportAllGridData:function(grid,isPDFAllExport,isExcelAllExport){
    	try{
        	if(grid){
        		var gridStore=grid.getStore();
        		var records = gridStore.getRange();
        		if(grid.xtype == 'applicationdocumentsandnotesgrid' && records.length > 0 && isPDFAllExport){
        			for(var i in records){
    	      			if(!isNullOrEmpty(records[i].get('description')) && records[i].get('description').length > 10000) {
    	      				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UNABLE_TO_DOWNLOAD_PDF'));
    	      				return;
    	  				  }
        		     } 
    			}else if(grid.xtype == 'academicstopicquicksearchgrid' && records.length > 0 && isPDFAllExport){
        			for(var i in records){
    	      			if(!isNullOrEmpty(records[i].get('description')) && records[i].get('description').length > 10000) {
    	      				showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('UNABLE_TO_DOWNLOAD_PDF'));
    	      				return;
    	  				  }
        		     } 
    			}
        		var currentPageSize = gridStore.pageSize;

        		/*** Taking Parent Panel of grid ***/
        		var parentPanel=grid.up('panel');

        		if(parentPanel.xtype==="tabpanel"){
        			parentPanel=parentPanel.up('panel'); 
        		}

        		if(parentPanel.xtype==="contentpanel"){
        			parentPanel=grid;   
        		}else if(grid.xtype==='griddashlet'){
        			parentPanel=grid.up('dashboardhomepage');
        		}else if(parentPanel.xtype==="panel"){
        			parentPanel=grid;
        		}

        		//In case of window add new wrapper panel around the grid
        		if(parentPanel==null && grid.up('window')){
        			parentPanel=grid.up('#wrapperPanel');
        		}

        		//var parentPanel=this.getParentPanel(grid);


        		var proxyType = gridStore.getProxy().type;

        		var exportAllstore;
        		if(parentPanel){
        			var itemCount=parentPanel.items.length;
        			/*** Create dynamic store with all data ***/

        			if(proxyType === "jsonajax"){
        				
        				//--get sorting info
    					var sortDirection = '';
    					var sortProperty = '';
    					if(Ext.isDefined(grid.getStore().sorters)){
    						if(grid.getStore().sorters.length){
    							var sortDirection = grid.getStore().sorters.items[0].direction;
    							var sortProperty = grid.getStore().sorters.items[0].property;
    						}
    					}
    					
        				exportAllstore = Ext.create('Ext.data.Store', {                				
        					model: gridStore.model,
        					autoLoad: false,
        					pageSize : -1,
        					proxy: {
        						type: 'jsonajax',
        						api: {
        							read: gridStore.getProxy().api.read
        						},
        						extraParams:{
        							limit: undefined,
        							size:50
        						},    			         
        						reader: {
        							type: 'json',
        							root: 'rows',
        							totalProperty: 'records',
        							successProperty: 'success'
        						}
        					}
        				});   
        			}else if(proxyType === "rest"){
        				//--get sorting info
    					var sortDirection = '';
    					var sortProperty = '';
    					if(Ext.isDefined(grid.getStore().sorters)){
    						if(grid.getStore().sorters.length){
    							var sortDirection = grid.getStore().sorters.items[0].direction;
    							var sortProperty = grid.getStore().sorters.items[0].property;
    						}
    					}

        				exportAllstore = Ext.create('Ext.data.Store', {                				
        					model: gridStore.model,
        					autoLoad: false,
        					pageSize : -1,
        					proxy: {
        						type: 'rest',
        						api: {
        							read: gridStore.getProxy().api.read
        						},
        						extraParams:{
        							limit: undefined,
        							size:50
        						},    			         
        						reader: {
        							type: 'json',
        							root: 'rows',
        							totalProperty: 'records',
        							successProperty: 'success'
        						}
        					}
        				});   

        			}

        			if(!isEmpty(gridStore.proxy.actionMethods)){
        				if(!isNullOrEmpty(gridStore.proxy.actionMethods.read)){
        					exportAllstore.proxy.actionMethods=gridStore.proxy.actionMethods;                        
        					exportAllstore.proxy.header=gridStore.proxy.header; 
        					exportAllstore.proxy.extraParams=gridStore.proxy.extraParams;                        
        				}
        			}
        			var hiddenDataIndexGridColumns = {};
        			Ext.each(grid.columnManager.getColumns(), function(column){
        				if(!isNullOrEmpty(column.dataIndex) && isNullOrEmpty(column.hidden)){
        					hiddenDataIndexGridColumns[column.dataIndex] = true;
        				}else if(!isNullOrEmpty(column.dataIndex) && !isNullOrEmpty(column.hidden)){
        					hiddenDataIndexGridColumns[column.dataIndex] = column.hidden;
        				}

        			});
        			var cloneGrid=grid.cloneConfig();
        			if(grid.xtype == 'businessruleapplytostudentgroupgrid' || grid.xtype == 'studenthealthinformationreportgrid') {
        				this.copyColumnsFormColumnManager(grid,cloneGrid);
        			}
        			var headerCount = grid.columnManager.getColumns().length;
        			var cloneGridColumns = [];
        			if(cloneGrid.columns && cloneGrid.columns.length < 1){
        				this.copyColumnsFormColumnManager(grid,cloneGrid);
        			}
        			Ext.each(cloneGrid.columns, function(column){
        				if(!isNullOrEmpty(column.dataIndex) 
        						&& hiddenDataIndexGridColumns.hasOwnProperty(column.dataIndex)){
        					column.hidden = hiddenDataIndexGridColumns[column.dataIndex];
        				}else{
        					column.hidden = true;
        				}
        				// text undefined so apply try catch
        				try{
        					if(column.text!=grid.columns[column.getIndex()].text && column.dataIndex==grid.columns[column.getIndex()].dataIndex){
            					column.text=grid.columns[column.getIndex()].text;
            				}
        				}catch(e){
        				}
                       // condition to remove the column if no data in grid //  V2D-209702
        				if(grid.getStore().getCount()>0) {
            				cloneGridColumns.push(column);
                        }

        			});
        			/*** Create dynamic export grid for exporting all data through PDF or Excel ***/
        			if(grid.xtype == 'planwisegrid') {
        				for(cnt = 0; cnt < cloneGridColumns.length; cnt++) {
        					cloneGridColumns[cnt].renderer = null;
        				}
        			}
        			var exportAllGridObject={
        					xtype:'exportallgrid',	
        					itemId: "exportAllGrid",
        					title: this.title,
        					store: exportAllstore,
        					columns:  cloneGridColumns,
        					removeSerialColumn:grid.removeSerialColumn ? true:false
        			};   
        			
        			if(!isNullOrEmpty(this.studentId) && !isNullOrEmpty(this.studentName)){
        				exportAllGridObject.studentId = this.studentId;
        				exportAllGridObject.studentName = this.studentName;
        			}

        			if(exportAllGridObject){
        				//parentPanel.insert(itemCount,exportAllGrid);
        				parentPanel.add(exportAllGridObject);
        				try{
            				refreshHeader(grid);
        				}
        				catch(e){}
        				parentPanel.doLayout();
    					
        				var exportAllGrid=parentPanel.down("#exportAllGrid");
        				//exportAllGrid.setVisible(false);
        				//exportAllGrid.getView().setLoading(false);

        				var showSummaryRow = false;
        				if(grid && grid.xtype =='paymentreceivedhistorygrid' && grid.getStore().data.items[0] && portalId==3){
        					showSummaryRow = grid.getStore().data.items[0].data.whetherDisplayTotal;
        					exportAllGrid.getView().getFeature(0).toggleSummaryRow(showSummaryRow);
        				}
        				
        				var paramObject=new Object();
        				if(!isEmpty(gridStore.lastOptions) && !isEmpty(gridStore.lastOptions.params)){
        					paramObject=gridStore.lastOptions.params;
        				}
        				if (!isEmpty(grid.itemId) && grid.itemId == 'facultyDocumentGrid') {
    						exportAllGrid.getStore().getProxy().extraParams = paramObject;
        				} else {
        					paramObject =  exportAllGrid.getStore().getProxy().extraParams;
        				}
        					
        				paramObject['limit'] = -1;
        				/*** load all data in dynamic export grid ***/
    					var baseController=Academia.app.getController('base.BaseController');
    					var activeTab=baseController.getTabReferenceByTabTitle("");
        				var myMask = new Ext.LoadMask(activeTab, {msg:"Please wait..."});
    					myMask.show();
        				exportAllGrid.getStore().load({
        					params:paramObject,
        					callback: function(records, operation, success) {
        						if(grid.xtype == 'assessmenteventgrid'){     //V2D-239142
        							if(records.length >0){
        								for(var i=0;i<records.length ;i++){
        									if(records[i].data.examStatus == "PENDING"){
        										records[i].set('examStatus', "Pending");
        	        					    	  } else if(records[i].data.examStatus == "CLOSED"){
        	        					    		  records[i].set('examStatus', "Result Declared");
        	        					    	  } else if(records[i].data.examStatus =="CONDUCTED"){
        	        					    		  records[i].set('examStatus', "Open For Mark Entry");
        	        					    	  } else{
        	        					    		  records[i].set('examStatus', records[i].data.examStatus);
        	        					    	  }
        										if(!Ext.isDate(records[i].data.conductedDate)) {
        											records[i].set('conductedDate', dateRender(new Date(records[i].data.conductedDate)));
        										}
        								}
        							}
        						}
        						if(grid.xtype == 'planwisegrid' && records.length > 0) {
        	        				for(cnt = 0; cnt < records.length; cnt++) {
        	        					records[cnt].set('eventName', "");
        	        					if(!isNullOrEmpty(records[cnt].get('newEventName'))){
        	        						records[cnt].set('eventName', records[cnt].get('newEventName'));
        	        		        	}
        	        					if(isNullOrEmpty(records[cnt].get('presentAbsId'))){
        	        						//var grid = view;
        	        						var store = grid.getStore();
        	        						var models = grid.getStore().getRange();
        	        						models[cnt].set("presentAbsId","Present");
        	        						models[cnt].set("malPracticeStatus",null);
        	        						if(records[cnt].data.whetherExamAttended){
        	        							records[cnt].set('presentAbsId', "Present");
        	        						}
        	        						else {
        	        							try {
        	        								models[cnt].set("presentAbsId","Absent");
            	        							records[cnt].set('presentAbsId', "Absent");
        	        							}
        	        							catch(err) {}
        	        						}
        	        					} else {
        	        						return records[cnt].get('presentAbsId');
        	        					}
        	        					
        	        					var store = grid.getStore();
            	        				var models = grid.getStore().getRange();
            	        				if(store.data.items[cnt].data.presentAbsId!="Absent"){
            	        					if(!isNullOrEmpty(records[cnt].data.examMalPracticType) && (records[cnt].get('malPracticeStatus')=='' || records[cnt].get('malPracticeStatus')== undefined)){
            	        						models[cnt].set("malPracticeStatus",""+records[cnt].data.examMalPracticType);
            	        						records[cnt].set('malPracticeStatus', records[cnt].data.examMalPracticType);
            	        					} else if(records[cnt].get('malPracticeStatus')!='' && records[cnt].get('malPracticeStatus')!= undefined){
            	        						models[cnt].set("malPracticeStatus",""+records[cnt].data.malPracticeStatus);
            	        						records[cnt].set('malPracticeStatus', records[cnt].data.malPracticeStatus);
            	        					} else {
            	        						records[cnt].set('malPracticeStatus', getExaminationTranslation('CLICK_TO_ENTER'));
            	        					}	
            	        				} else {
            	        					records[cnt].set('malPracticeStatus', getExaminationTranslation('CLICK_TO_ENTER'));
            	        				}
        	        				}
        	        			}
        						
        						var isExported=false;
        						var baseController=Academia.app.getController('base.BaseController');
        						var academyLocation=baseController.getCurrentAcademyLocation();
        						
        						if(!isNullOrEmpty(sortDirection) && !isNullOrEmpty(sortProperty)){
        							//exportAllGrid.getStore().sort(sortProperty, sortDirection);
        							exportAllGrid.getStore().sort({
        								property : sortProperty,
        								direction : sortDirection,
        								sorterFn : function(v1, v2) {
        									var reA = /[^a-zA-Z]/g;
        									var reN = /[^0-9]/g;
        									if (!isNullOrEmpty(v1.get(sortProperty))
        											&& !isNullOrEmpty(v2.get(sortProperty))) {
        										if (typeof (v1.get(sortProperty)) == "string" && typeof (v2.get(sortProperty)) == "string") {
        											v1 = v1.get(sortProperty);
        											v2 = v2.get(sortProperty);
        											var aA = v1.replace(reA, "");
        											var bA = v2.replace(reA, "");
        											if(aA.toLowerCase() === bA.toLowerCase()) {
        												var aN = parseInt(v1.replace(reN, ""), 10);
        												var bN = parseInt(v2.replace(reN, ""), 10);
        												return aN === bN ? 0 : aN > bN ? 1 : -1;
        											} else {
        												return aA.toLowerCase() > bA.toLowerCase() ? 1 : -1;
        											}
        										} else {
        											v1 = v1.get(sortProperty);
        											v2 = v2.get(sortProperty);
        											return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
        										}
        									} else {
        										if (isNullOrEmpty(v1.get(sortProperty))) {
        											v1.set(sortProperty, '');
        										}
        										if (isNullOrEmpty(v2.get(sortProperty))) {
        											v2.set(sortProperty, '');
        										}
        										v1 = v1.get(sortProperty);
        										v2 = v2.get(sortProperty);
        										return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
        									}
        								}
        							});
        							exportAllGrid.getView().refresh();
        						}
        						
        						if(!isNullOrEmpty(academyLocation)){
        							var params=new Object();
        							params.academyLocationId=academyLocation;
        							var displayName = baseController.getAcademyLocationDisplayName(academyLocation);                					                         

        							/*** Give a call for PDF export  ***/
        							if(isPDFAllExport){        							
        								var activeTab=baseController.getTabReferenceByTabTitle("");
        								if(activeTab){
        									/*var myMask = new Ext.LoadMask(activeTab, {msg:"Please wait..."});
        									myMask.show();*/

        									baseController.sendGetAjaxRequest(SERVERURL.GET_ACADEMY_LOCATION_LOGO, 'GET', params, function(option, success, response) {
        										if(success){
        											if(!isNullOrEmpty(response.responseText)){
        												var imageDataObject = Ext.decode(response.responseText);
        												if(!isEmpty(imageDataObject)){
        													isExported=exportToPDF(exportAllGrid.id,myMask,grid.title,imageDataObject.code,imageDataObject.value,displayName, headerCount, grid);

        													/*** After exporting destroy export grid and store ***/
        													if(isExported){        		
        														Ext.getBody().unmask();
        														exportAllstore.destroyStore();                                    			      				   	
        														exportAllGrid.close();
        														parentPanel.doLayout();
        														cloneGrid.destroy();
        													}
        												}
        											}else{
        												baseController.sendGetAjaxRequest(SERVERURL.GET_ACADEMY_LOCATION_DEFAULT_LOGO, 'GET', null, function(option, success, response) {
        													if(success){
        														if(!isNullOrEmpty(response.responseText)){
        															var imageDataObject = Ext.decode(response.responseText);
        															if(!isEmpty(imageDataObject)){
        																isExported=exportToPDF(exportAllGrid.id,myMask,grid.title,imageDataObject.code,imageDataObject.value,displayName, headerCount,grid);

        																/*** After exporting destroy export grid and store ***/
        																if(isExported){     
        																	Ext.getBody().unmask();
        																	exportAllstore.destroyStore();                                                			      				   	
        																	exportAllGrid.close();
        																	parentPanel.doLayout();
        																	cloneGrid.destroy();
        																}
        															}	
        														}                                                                 			
        													}
        												});	
        											}                                                    			
        										}
        									});

        								}             		             	                	           			            	            						
        							}

        							/*** Give a call for Excel export  ***/
        							if(isExcelAllExport){        							
        								var activeTab=baseController.getTabReferenceByTabTitle("");
        								if(activeTab){
        									if(!isNullOrEmpty(grid) && !isNullOrEmpty(grid.config.searchFilterForm)){
        										exportAllGrid.config.searchFilterForm = grid.config.searchFilterForm;
        									}
        									isExported=exportAllGrid.downloadExcelXml(exportAllGrid.id,exportAllGrid,displayName,grid);
        									setTimeout(function() {
        										/*** After exporting destroy export grid and store ***/
        										if(isExported){
        											Ext.getBody().unmask();
        											myMask.hide();
        											exportAllstore.destroyStore();            	    							                            									
        											exportAllGrid.close();
        											parentPanel.doLayout();
        											cloneGrid.destroy();
        										}
        									},-1);
        								}	
        							}

        						}		   						    						    						
        					}
        				});
        			}
        		}        	
        	}
        	/*used for reset grid store with current limit*/ 
        	if(gridStore){
        		gridStore.pageSize = currentPageSize;
        		gridStore.getProxy().setExtraParam('limit', currentPageSize);
  			}
        
    	} catch(error){
    		//TODO
    		Ext.getBody().unmask();
    		console.log(error);
    	}
    },
    
    
    addExportToolBarInParent:function(grid,parent,isSplitterIncluded){
		for(var exportItem=0;exportItem<grid.exportToolBarItems.length;exportItem++){
    			
	    	if(!isNullOrEmpty(isSplitterIncluded) && isSplitterIncluded==false && exportItem==0){ 
	    		
	    	}else{
	    		var button=grid.exportToolBarItems[exportItem];
	    		button.gridRef=grid;
	    		parent.addTool(button);
    		}    	
    	}
    },
    	
    
    removExportToolBarFromParent:function(grid,parent,isSplitterIncluded){
    	for(var exportItem=0;exportItem<grid.exportToolBarItems.length;exportItem++){
    		var button=grid.exportToolBarItems[exportItem];
    		parent.header.remove(parent.down('#'+button.itemId));
    	}
    },
    /*
        Add export tool bar items to extended grid panel
    */
    
    addExportToolBarItems:function(grid,isSplitterIncluded){
    	var tbarItems =new Array();
    	var toolBarItems=grid.tbar;
    	
    	if(isEmpty(toolBarItems)){
    		for(var exportItem=0;exportItem<grid.exportToolBarItems.length;exportItem++){
    			var button=grid.exportToolBarItems[exportItem];
	    		button.gridRef=grid;
    		}
    		tbarItems=grid.exportToolBarItems;
    	}else{    		
    		for(var exportItem=0;exportItem<grid.exportToolBarItems.length;exportItem++){
    			
    			/***** If grid toolbar already having splitter then no need to add extra splitter*******/
    	    	if(!isNullOrEmpty(isSplitterIncluded) && isSplitterIncluded==false && exportItem==0){    	    		
    	    	}else{
    	    		var button=grid.exportToolBarItems[exportItem];
    	    		button.gridRef=grid;
    	    		toolBarItems.push(button);
    	    	}    			    			
    		}    	
    		tbarItems=toolBarItems;
    	}        
    	
        Ext.apply(this, {            
            tbar: tbarItems
        });
    },

    /*
        Kick off process
    */

    downloadExcelXml: function(renderId,grid,displayName,mainGrid,includeHidden, title) {

    	title=isNullOrEmpty(grid.title)?getCommonTranslation("EXPORT_LIST"):grid.title; 
    	//title = getCommonTranslation("EXPORT_LIST");
    	//title="<![CDATA["+title+"]]>";
    	if(title.indexOf('&')>0){
    		title = title.replace(/&/g, "&amp;");
    	}
    	
    	// @auther Bhanu PS
    	var showSummaryRow = false;
    	var showSumRow = false;
    	if(grid.features != undefined && !isNullOrEmpty(grid.features)) {
    		for(var i in grid.features) {
        		if(grid.features[i].ftype.toLowerCase() == "summary".toLowerCase()) {
        			showSummaryRow=true;
        		}
        		if(mainGrid && mainGrid.xtype =='paymentreceivedhistorygrid' && mainGrid.getStore().data.items[0] && portalId==3){
        		   showSumRow = mainGrid.getStore().data.items[0].data.whetherDisplayTotal;
        		   grid.getView().getFeature(0).toggleSummaryRow(showSumRow);
        		}
        	}
    	}
    	
    	var vExportContent;
    	if(mainGrid && mainGrid.xtype =='paymentreceivedhistorygrid' && portalId==3){
    	   vExportContent = grid.getExcelXml(renderId,includeHidden, title,displayName, showSumRow,grid,mainGrid);
    	}else{
    	   vExportContent = grid.getExcelXml(renderId,includeHidden, title,displayName, showSummaryRow,grid,mainGrid);
    	}
        
       //console.log("final xml",vExportContent);

        var location = 'data:application/vnd.ms-excel;base64,' + Base64.encode(vExportContent);
       // console.log("final locationn",location);
        /* 
          dynamically create and anchor tag to force download with suggested filename 
          note: download attribute is Google Chrome specific
        */
		
        //document.location='data:application/vnd.ms-excel;base64,' + Base64.encode(vExportContent);
        
        //if (Ext.isChrome || Ext.isGecko) {
        	
        	var blob = new Blob([vExportContent], {type: 'text/csv'});
            var filename =  title + "-" + Ext.Date.format(new Date(), 'Y-m-d Hi') + '.xls';
            if(window.navigator.msSaveOrOpenBlob) {
                window.navigator.msSaveBlob(blob, filename);
            }
            else{
                var elem = window.document.createElement('a');
                elem.href = window.URL.createObjectURL(blob);
                elem.download = filename;
                document.body.appendChild(elem);
                elem.click();
                document.body.removeChild(elem);
            }
            return true;
        	
            /*var gridEl = grid.getEl();

            var el = Ext.DomHelper.append(gridEl, {
                tag: "a",
                download: title + "-" + Ext.Date.format(new Date(), 'Y-m-d Hi') + '.xls',
                href: location
            });

            el.click();

            Ext.fly(el).destroy();

            return true;*/
            
        /*} else {

            var form = grid.down('form#uploadForm');
            if (form) {
                form.destroy();
            }
            form = grid.add({
                xtype: 'form',
                itemId: 'uploadForm',
                hidden: true,
                standardSubmit: true,
                url: 'http://webapps.figleaf.com/dataservices/Excel.cfc?method=echo&mimetype=application/vnd.ms-excel&filename=' + escape(title + ".xls"),
                items: [{
                    xtype: 'hiddenfield',
                    name: 'data',
                    value: vExportContent
                }]
            });
           // console.log("niint",form);  
            form.getForm().submit();
            
            return true;
        }*/
    },

    /*

        Welcome to XML Hell
        See: http://msdn.microsoft.com/en-us/library/office/aa140066(v=office.10).aspx
        for more details

    */
    getExcelXml: function(renderId,includeHidden, title,displayName, showSummaryRow,grid,mainGrid) {

        var theTitle = title || this.title;

        var worksheet = this.createWorksheet(renderId,includeHidden, theTitle,displayName, showSummaryRow,grid,mainGrid);

        return ''.concat(
            '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>',
            '<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">',
            '<DocumentProperties xmlns="urn:schemas-microsoft-com:office:office"><Title>' + "<![CDATA["+theTitle+"]]>" + '</Title></DocumentProperties>',
            '<OfficeDocumentSettings xmlns="urn:schemas-microsoft-com:office:office"><AllowPNG/></OfficeDocumentSettings>',
            '<ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">',
            '<WindowHeight>' + worksheet.height + '</WindowHeight>',
            '<WindowWidth>' + worksheet.width + '</WindowWidth>',
            '<ProtectStructure>False</ProtectStructure>',
            '<ProtectWindows>False</ProtectWindows>',
            '</ExcelWorkbook>',

            '<Styles>',
            
            '<Style ss:ID="Default" ss:Name="Normal">',
            '<Alignment ss:Vertical="Bottom"/>',
            '<Borders/>',
            '<Font ss:FontName="Calibri" x:Family="Swiss" ss:Size="11" ss:Color="#000000"/>',
            '<Interior/>',
            '<NumberFormat/>',
            '<Protection/>',
            '</Style>',

            '<Style ss:ID="title">',
            '<Borders />',
            '<Font ss:FontName="Calibri" ss:Bold="1" ss:Size="14" />',
            '<Alignment ss:Horizontal="Center" ss:Vertical="Center" ss:WrapText="1" />',
            '<NumberFormat ss:Format="@" />',
            '</Style>',
            
            '<Style ss:ID="Keys">',
            '<Borders />',
            '<Font ss:FontName="Calibri" ss:Bold="1" ss:Size="14" />',
            '<Alignment ss:Vertical="Center" ss:WrapText="1" />',
            '<NumberFormat ss:Format="@" />',
            '</Style>',

            '<Style ss:ID="headercell">',
            '<Font ss:FontName="Calibri" ss:Bold="1" ss:Size="11" />',
            '<Alignment ss:Horizontal="Center" ss:WrapText="1" />',            
            '</Style>',            
            
            '<Style ss:ID="even">',
            '<Interior ss:Color="#CCFFFF" ss:Pattern="Solid" />',
            '</Style>',


            '<Style ss:ID="evendate" ss:Parent="even">',
            '<NumberFormat ss:Format="yyyy-mm-dd" />',
            '</Style>',


            '<Style ss:ID="evenint" ss:Parent="even">',
            '<Numberformat ss:Format="0" />',
            '</Style>',

            '<Style ss:ID="evenfloat" ss:Parent="even">',
            '<Numberformat ss:Format="0.00" />',
            '</Style>',

            '<Style ss:ID="odd">',
            '<Interior ss:Color="#CCCCFF" ss:Pattern="Solid" />',
            '</Style>',

            '<Style ss:ID="groupSeparator">',
            '<Interior ss:Color="#D3D3D3" ss:Pattern="Solid" />',
            '</Style>',

            '<Style ss:ID="odddate" ss:Parent="odd">',
            '<NumberFormat ss:Format="yyyy-mm-dd" />',
            '</Style>',

            '<Style ss:ID="oddint" ss:Parent="odd">',
            '<NumberFormat Format="0" />',
            '</Style>',

            '<Style ss:ID="oddfloat" ss:Parent="odd">',
            '<NumberFormat Format="0.00" />',
            '</Style>',

            '<Style ss:ID="redFont">',
            '<Font ss:Color="#ff0000"/>',
            '</Style>',
            
            '<Style ss:ID="wrapContent">',
            '<Alignment ss:Vertical="Center" ss:WrapText="1" />',
            '</Style>',
            
            '<Style ss:ID="titleReport">',
            '<Font ss:FontName="Calibri" ss:Bold="1" ss:Size="11" />',
            '<Alignment ss:Vertical="Center" ss:WrapText="1" />',            
            '</Style>',
            
            '</Styles>',
            worksheet.xml,
            '</Workbook>'
        );
    },

    /*

        Support function to return field info from store based on fieldname

    */

    getModelField: function(fieldName) {

        var fields = this.store.model.getFields();
        for (var i = 0; i < fields.length; i++) {
            if (fields[i].name === fieldName) {
                return fields[i];
            }
        }
    },

    /*
        
        Convert store into Excel Worksheet

    */
    generateEmptyGroupRow: function(dataIndex, value, cellTypes, includeHidden) {


        var cm = this.columnManager.columns;
        var colCount = cm.length;
        var rowTpl = '<Row ss:AutoFitHeight="0"><Cell ss:StyleID="groupSeparator" ss:MergeAcross="{0}"><Data ss:Type="String"><html:b>{1}</html:b></Data></Cell></Row>';
        var visibleCols = 0;

        // rowXml += '<Cell ss:StyleID="groupSeparator">'

        for (var j = 0; j < colCount; j++) {
            if (cm[j].xtype != 'actioncolumn' && (cm[j].dataIndex != '') && (includeHidden || !cm[j].hidden)) {
                // rowXml += '<Cell ss:StyleID="groupSeparator"/>';
                visibleCols++;
            }
        }

        // rowXml += "</Row>";

        return Ext.String.format(rowTpl, visibleCols - 1, value);
    },


    createWorksheet: function(renderId,includeHidden, theTitle,displayName, showSummaryRow,grid,mainGrid) {
        // Calculate cell data types and extra class names which affect formatting
        var cellType = [];
        var cellTypeClass = [];
        var cm = this.columns;
        console.log('cm1-----------',cm);
        if(cm.length==0){
        	console.log('cm.length',cm.length);
        	cm = this.columnManager.columns;
        }
        if(grid.xtype == 'businessruleapplytostudentgroupgrid') {
        	cm = this.columnManager.getColumns();
		}

        //--Adding Extra Column S.No.
        if(!Ext.getCmp(renderId).removeSerialColumn){
        	var extraColumn = {
            		xtype: 'gridcolumn',
            		dataIndex: '-',
            		hidden: false,
            		el: '-',
            		text: getCommonTranslation('SERIAL_NO'),
            		itemId: '-',
            		getEl:function(){return this.el;}
            };
            
            var ncm = [];
            for(var cl=0;cl<=cm.length;cl++){
            	if(cl==0 && !Ext.getCmp(renderId).removeSerialColumn){
            		ncm.push(extraColumn);
            	}
            	else{
            		if(cm[cl-1].dataIndex=="addButton" || cm[cl-1].dataIndex=="deleteButton" || cm[cl-1].dataIndex=="sel"){
            			cm[cl-1].xtype = 'actioncolumn';
            		}
            		ncm.push(cm[cl-1]);
            	}
            }
            
            cm=ncm;
        }
        
        
        console.log('cm2*******',cm);
        //var onn=cm[0].on();
       // console.log('onn***',onn);
        var el=cm[0].getEl();
        console.log('el*******',el);
        var extraLines=2; //here value 2 means one title and one table headers
        var universityName=displayName; //Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();
        var universityAddress=""; // Ext.ComponentQuery.query('customcombobox#cmbGlobalAcademyLocation')[0].getRawValue();
        var baseController=Academia.app.getController('base.BaseController');
   	    var loggedInUser=baseController.getCurrentlyLoggedInUser();
        var generatedBy=getCommonTranslation("GENERATED_BY")+":"+loggedInUser.value;
        var poweredBy=getCommonTranslation("POWERED_BY")+":"+"Academia ERP";
        var onDate=getCommonTranslation("ON")+":"+dateRender(new Date())+" "+timeRender(new Date());
        
        var totalWidthInPixels = 0;
        var colXml = '';        
        var headerXml = '';        
        var visibleColumnCountReduction = 0;
//        cm[cm.length+1]=new Object();
//        cm.push("");
        var colCount = cm.length;
       // console.log("total column in xls",colCount);
        for (var i = 0; i < colCount; i++) {
            if (cm[i].xtype != 'actioncolumn' && (cm[i].dataIndex != '') && (includeHidden || !cm[i].hidden)) {
                if(!isNullOrEmpty(cm[i].getEl())){
                	if(typeof cm[i].getEl()=="string" && cm[i].getEl()=="-"){
                		var w = 50;
                	}
                	else{
                    	var w = cm[i].getEl().getWidth();
                	}
                    totalWidthInPixels += w;

                if (cm[i].text === "" || cm[i].itemId=="checkboxHeaderItemId") {
                    cellType.push("None");
                    cellTypeClass.push("");
                    ++visibleColumnCountReduction;
                } else {
                    colXml += '<Column ss:AutoFitWidth="1" ss:Width="' + w + '" />';
                    headerXml += '<Cell ss:StyleID="headercell">' +
                        '<Data ss:Type="String">' + cm[i].text + '</Data>' +
                        '<NamedCell ss:Name="Print_Titles"></NamedCell></Cell>';

                    if(cm[i].dataIndex){
	                    var fld = this.getModelField(cm[i].dataIndex);
	                    if(cm[i].dataIndex=="-"){
	                    	cellType.push("Number");
                            cellTypeClass.push("int");
	                    }
	                    if(fld && fld.type){
	                    	switch (fld.type.type) {
		                        case "int":
		                            cellType.push("Number");
		                            cellTypeClass.push("int");
		                            break;
		                        case "float":
		                            cellType.push("Number");
		                            cellTypeClass.push("float");
		                            break;
		
		                        case "bool":
		
		                        case "boolean":
		                            cellType.push("String");
		                            cellTypeClass.push("");
		                            break;
		                        case "date":
		                            cellType.push("DateTime");
		                            cellTypeClass.push("date");
		                            break;
		                        default:
		                            cellType.push("String");
		                            cellTypeClass.push("");
		                            break;
		                    }
	                    }
                    }
                }
                }
            }
        }
        var visibleColumnCount = cellType.length - visibleColumnCountReduction;

        var result = {
            height: 9000,
            width: Math.floor(totalWidthInPixels * 30) + 50
        };

        // Generate worksheet header details.

        // determine number of rows
        extraLines=extraLines+6; //Empty Rows
        extraLines=extraLines+1; //University Name Row
        extraLines=extraLines+1; //University Address Row
        extraLines=extraLines+1; //Generated By
        extraLines=extraLines+1; //Powered By Row
        extraLines=extraLines+1; //On Date Row
        extraLines=extraLines+10; //For filter rows
        
        if(!isNullOrEmpty(Ext.getCmp(renderId).studentId) && !isNullOrEmpty(Ext.getCmp(renderId).studentName)){
            extraLines=extraLines+1; //Student ID & Name
			var studentUpdatedRowData = Ext.getCmp(renderId).studentId + " / " + Ext.getCmp(renderId).studentName;
			var studentRowData=''.concat('<Row ss:AutoFitHeight="1">',
				   	'<Cell ss:StyleID="redFont">',
						   '<Data ss:Type="String">')+ studentUpdatedRowData +''.concat('</Data>',
						   '</Cell>','</Row>') +',';
        }
        else{
			 var studentRowData=''.concat('<Row ss:AutoFitHeight="1">',
					   	'<Cell ss:StyleID="redFont">',
							   '<Data ss:Type="String"></Data>',
							   '</Cell>',
					   	'</Row>')+',';
        }
        
        // @auther Bhanu PS
        if(showSummaryRow != undefined && showSummaryRow){
        	extraLines=extraLines+1;//For Total Count on xl export
        }
        var numGridRows = this.store.getCount() + extraLines;
        if (!Ext.isEmpty(this.store.groupField) || this.store.groupers.items.length > 0) {
            numGridRows = numGridRows + this.store.getGroups().length;
        }

        
        var t;
        
        /***************Start Code added for show filter data on Excel Export Report **************/
        
        if(!isNullOrEmpty(mainGrid)){
        	grid = mainGrid;
        }
        if(grid.xtype == 'scholarshipRequestListGridStudent' || grid.xtype == 'scholarshipRequestListGridApplicant'){
        	visibleColumnCount=cm.length-2;
        }

        var fileTitleBottom = theTitle.replace(/\*|\?|\[|\]|:|\/|@|#|\$|%|\^|\(|\)|=|-|\"|\'|\;|\+|{|}|\,|\_/g,'');
        fileTitleBottom = fileTitleBottom.replace('&amp;','');
   	    fileTitleBottom = fileTitleBottom.replace('&amp','');
        fileTitleBottom.replaceAll(' ','');
        theTitle = theTitle.replace('/','&#47;');
        theTitle = theTitle.replace('*','&#42;;');
        theTitle = theTitle.replace('?','&#63;;');
        theTitle = theTitle.replace(':','&#58;');
        theTitle = theTitle.replace('[','&#91;');
        theTitle = theTitle.replace(']','&#93;');
    	var fileTitleBottom = theTitle.replace(/\*|\?|\[|\]|:|\/|@|#|\$|%|\^|\(|\)|=|-|\"|\'|\;|\+|{|}|\,|\_/g,'');
    	 fileTitleBottom = fileTitleBottom.replace('&amp;','');
    	 fileTitleBottom = fileTitleBottom.replace('&amp','');
    	 fileTitleBottom.replaceAll(' ','');
    	theTitle = theTitle.replace('/','&#47;');
    	theTitle = theTitle.replace('*','&#42;;');
    	theTitle = theTitle.replace('?','&#63;;');
    	theTitle = theTitle.replace(':','&#58;');
    	theTitle = theTitle.replace('[','&#91;');
    	theTitle = theTitle.replace(']','&#93;');
    	
        if((!isNullOrEmpty(grid) && !isNullOrEmpty(grid.config.searchFilterForm)) || !isNullOrEmpty(grid.config.htmlFilterExcel)){
        	var htmlFilter = '';
        	var htmlFilterPdf = '';
        	if(!isNullOrEmpty(grid.config.searchFilterForm)){
        		var form = grid.config.searchFilterForm.getForm();
            	if(!isNullOrEmpty(form)){
            		grid.config.htmlFilterExcel = null;
            		form.getFields().each(function(field) {
            			if(field.isVisible()){
            				if(field.xtype=='statusCombo'||field.xtype=='textfield' || field.xtype=='textarea' || field.xtype=='checkboxfield' ||  
                					field.xtype=='datefield' || field.xtype=='numberfield' || field.xtype=='textareafield'||field.xtype=='timefield'
                						|| field.xtype=='customcombobox' || field.xtype=='nestedJsonCombo' || field.xtype=='combo'
                							|| field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield' || field.xtype=='livesearchcombo' || field.xtype=='groupingcombobox'){

            					if(field.xtype=='multiselectcombofield' || field.xtype=='multiselectcombofield2' || field.xtype=='multiselectfield'){
									if(!isNullOrEmpty(field.valueModels) && field.valueModels.length>0){
										var fieldLabel = field.getFieldLabel();
										
										if(!isNullOrEmpty(field.el) && !isNullOrEmpty(field.el.dom)){
											var innerItems = field.el.dom.getElementsByClassName('x-boxselect-item');
											if(innerItems.length>0){
												var str = '';
												for (var i = 0; i < innerItems.length; i++) { 
										            str = str + innerItems[i].title + ', ';
										        }
												str = str.replace(/,\s*$/, "");
												htmlFilter += '<Cell ss:MergeAcross="0">' +
		                                        '<Data ss:Type="String">' + fieldLabel+' : ' + str + '</Data>' +
		                                        '</Cell>';
												
												htmlFilterPdf = htmlFilterPdf + '<div>'+fieldLabel+' : ' + str + '</div>';
											}
										}
									}
								}
            					else{
            						var fieldLabel = field.getFieldLabel();
                    				var rawValue = field.getRawValue();
                    				
                    				if(!isNullOrEmpty(fieldLabel) && !isNullOrEmpty(rawValue)){
                    					htmlFilter += '<Cell ss:MergeAcross="0">' +
                                        '<Data ss:Type="String">' + fieldLabel+' : ' + rawValue + '</Data>' +
                                        '</Cell>';
                    					
                    					htmlFilterPdf = htmlFilterPdf + '<div>'+fieldLabel+' : ' + rawValue + '</div>';	
            						}
            						else if(!isNullOrEmpty(field.boxLabel)){
            							if(field.getValue()){
            								fieldLabel = field.boxLabel;
                							htmlFilter += '<Cell ss:MergeAcross="0">' +
                                            '<Data ss:Type="String">' + fieldLabel+' : ' + rawValue + '</Data>' +
                                            '</Cell>';
                							
                							htmlFilterPdf = htmlFilterPdf + '<div>'+fieldLabel+' : ' + rawValue + '</div>';		
            							}
            						}
            					}
                				
                			}
            			}
            		});
            		if(!isNullOrEmpty(htmlFilter)){
						grid.config.htmlFilterExcel = htmlFilter;
						grid.config.htmlFilter =  htmlFilterPdf;
						grid.config.searchFilterForm = null;
					}
            	}
        	}
        	else if(!isNullOrEmpty(grid.config.htmlFilterExcel)){
        		htmlFilter = grid.config.htmlFilterExcel;
        	}
        	
        	try{
        		var countCellDouble = (htmlFilter.match(/Cell/g) || []).length;
            	
            	if(countCellDouble>0){
            		var countCell = countCellDouble/2;
            		var filterRows = (countCell%4>0) ? parseInt(countCell/4)+1 : parseInt(countCell/4);
            		var htmlFilterBr = htmlFilter.replaceAll("</Cell><Cell","</Cell>--<Cell");
            		var htmlFilterCellArray = htmlFilterBr.split("--");
            		
            		var rowInc = 0;
            		var columnInc = 0;
            		var columnNum = 0;
            		
            		var newHtmlFilter = '';
            		
            		for(rowInc=0;rowInc<filterRows;rowInc++){
            			newHtmlFilter = newHtmlFilter+'<Row ss:AutoFitHeight="1">';
            			for(columnInc=0;columnInc<4;columnInc++){
            				if(typeof htmlFilterCellArray[columnNum] == "undefined"){
            					htmlFilterCellArray[columnNum] = '<Cell ss:MergeAcross="0"><Data ss:Type="String"> </Data></Cell>';
            				}
                			newHtmlFilter = newHtmlFilter+htmlFilterCellArray[columnNum];
            				columnNum = columnNum+1;
            			}
    	       			newHtmlFilter = newHtmlFilter+'</Row>'
            		}
            	}
            	else{
            		newHtmlFilter = '<Row ss:AutoFitHeight="1">'+htmlFilter+'</Row>';
            	}
        	}
        	catch(e){
        		newHtmlFilter = '<Row ss:AutoFitHeight="1">'+htmlFilter+'</Row>';
        	}
        	// create header for worksheet
        	t = ''.concat(
        			'<Worksheet ss:Name="' + fileTitleBottom + '">',

        			'<Names>',
        			'<NamedRange ss:Name="Print_Titles" ss:RefersTo="=\'' + fileTitleBottom + '\'!R1:R2">',
        			'</NamedRange></Names>',

        			'<Table ss:ExpandedColumnCount="' + (visibleColumnCount + 2),
        			'" ss:ExpandedRowCount="' + numGridRows + '" x:FullColumns="1" x:FullRows="1" ss:DefaultColumnWidth="65" ss:DefaultRowHeight="15">',
        			colXml,            
        			'<Row></Row>',
        			'<Row ss:AutoFitHeight="1">',

        			'<Cell ss:MergeAcross="' + (visibleColumnCount - 1) + '" ss:StyleID="Keys">',
        			'<Data ss:Type="String" xmlns:html="http://www.w3.org/TR/REC-html40">',
        			'<html:b>' + universityName + '</html:b></Data><NamedCell ss:Name="Print_Keys">',
        			'</NamedCell></Cell>',

        			'</Row>',
        			'<Row ss:AutoFitHeight="1">',
        			'<Cell>',
        			'<Data ss:Type="String">'+ universityAddress + '</Data>',
        			'</Cell>',
        			'</Row>',
        			+studentRowData+
        			'<Row ss:AutoFitHeight="1">',   
        			'<Cell ss:MergeAcross="1" ss:StyleID="titleReport">',
        			'<Data ss:Type="String" xmlns:html="http://www.w3.org/TR/REC-html40">',
        			'<html:b>Report Name: ' + theTitle + '</html:b></Data><NamedCell ss:Name="Print_Titles">',
        			'</NamedCell></Cell>',
        			'</Row>',
        			'<Row></Row>',
        			//'<Row ss:AutoFitHeight="1">',
        			newHtmlFilter +
        			// '</Row>',
        			'<Row></Row>',
        			'<Row ss:AutoFitHeight="1">',
        			headerXml +
        			'</Row>'
        	);
        	
        	/***************End Code added for show filter data on Excel Export Report **************/
        
        }
        else{
        	// create header for worksheet
        	t = ''.concat(
        			'<Worksheet ss:Name="' + fileTitleBottom + '">',

        			'<Names>',
        			'<NamedRange ss:Name="Print_Titles" ss:RefersTo="=\'' + fileTitleBottom + '\'!R1:R2">',
        			'</NamedRange></Names>',

        			'<Table ss:ExpandedColumnCount="' + (visibleColumnCount + 2),
        			'" ss:ExpandedRowCount="' + numGridRows + '" x:FullColumns="1" x:FullRows="1" ss:DefaultColumnWidth="65" ss:DefaultRowHeight="15">',
        			colXml,            
        			'<Row></Row>',
        			'<Row ss:AutoFitHeight="1">',
        			'<Cell ss:StyleID="Keys">',
        			'<Data ss:Type="String">',
        			'<html:b>' + universityName + '</html:b></Data>',
        			'</Cell>',
        			'</Row>',
        			'<Row ss:AutoFitHeight="1">',
        			'<Cell>',
        			'<Data ss:Type="String">'+ universityAddress + '</Data>',
        			'</Cell>',
        			'</Row>',
        			+studentRowData+
        			'<Row></Row>',
        			'<Row ss:AutoFitHeight="1">',
        			'<Cell ss:MergeAcross="' + (visibleColumnCount - 1) + '" ss:StyleID="title">',
        			'<Data ss:Type="String" xmlns:html="http://www.w3.org/TR/REC-html40">',
        			'<html:b>' + theTitle + '</html:b></Data><NamedCell ss:Name="Print_Titles">',
        			'</NamedCell></Cell>',
        			'</Row>',            
        			'<Row></Row>',
        			'<Row ss:AutoFitHeight="1">',
        			headerXml +
        			'</Row>'
        	);
        }
       
       //console.log("header file is",t)
        // Generate the data rows from the data in the Store
        var groupVal = "";
        var groupField = "";
        /*if (this.store.groupers.keys.length > 0) {
            groupField = this.store.groupers.keys[0];
        }*/
        
     
        var tableElement = $('#' + renderId).find('table');
        //var textContent=tableElement[0].textContent;
       // var tableElement=replaceSpecialChar(tableElements[0].textContent);
       // console.log('tableElement',tableElement[0].textContent);
		if(tableElement){
            var tableBodyElement = tableElement.find('tbody');
            if(tableBodyElement){
                var tableRowElements = tableBodyElement.find('.x-grid-row');
                for (var i = 0, it = this.store.data.items, len = it.length,p=tableRowElements.length; i < len && i<p; i++) {

                    if (!Ext.isEmpty(groupField)) {
                        if (groupVal != this.store.getAt(i).get(groupField)) {
                            groupVal = this.store.getAt(i).get(groupField);
                            t += this.generateEmptyGroupRow(groupField, groupVal, cellType, includeHidden);
                        }
                    }
            
                    t += '<Row>';
                    var cellClass = (i & 1) ? 'odd' : 'even';
                    //r = it[i].data;
                    var k = 0;
                    var cellData=null;
					if (!tableRowElements[i] || !tableRowElements[i].id) {
					    continue;
					}
                    var tableRowDataElements = tableBodyElement.find("#"+tableRowElements[i].id).find('.x-grid-cell');
                    for (var j = 0, l = 0;j <= colCount && l<tableRowDataElements.length; j++) {
//                        if (cm[j].xtype != 'actioncolumn' && (cm[j].dataIndex != '') && (includeHidden || !cm[j].hidden)) {
                            //var v = r[cm[j].dataIndex];
                    	if(!Ext.getCmp(renderId).removeSerialColumn){
                    		if(j==0){ //--For S.No. Column
                    			var v=(i+1);
                    			t += '<Cell ><Data ss:Type="String"><![CDATA['+v+']]></Data></Cell>';
                    		}
                    	}
                    		
	                        
                            var v = tableRowDataElements[l].textContent.replace('Click to enter','');
                            
	                        if(grid.xtype == "studentportalenrollmentdetailgrid" || grid.xtype == "coreerpstudentenrollmentdetailgrid"){
	                        	if($('#'+tableRowDataElements[l].id+" .yearlyBadgeCls").length && v.length && v[0]=="Y"){
	                        		v = v.substring(1);
	                        	}
	                        }
                            
                            if(tableRowDataElements[l].classList.contains("hideGridDataCls")){
                            	v = '';
                            }
                           // console.log("**************v**************",v);
                             //v=this.replaceSpecialChar(v);
                            cellData="<![CDATA["+v+"]]>";
                            
                            //console.log("**************v1**************",v);
                            if(tableRowDataElements[l].classList.contains("x-grid-cell-row-checker") || (tableRowDataElements[l].classList.contains("x-grid-cell-row-numberer") && !(parseInt(v) > 0))){
                            	l++;
                            }else if (cellType[k] !== "None") {
                            	if(l!=0 || v.trim().length) {
	                                //ss:StyleID="' + cellClass + cellTypeClass[k] + '"
	                                t += '<Cell ><Data ss:Type="String">';
	                                if (cellType[k] == 'DateTime') {
	                                    t += Ext.Date.format(v, 'Y-m-d');
	                                } else {
	                                    t += cellData;
	                                }
	                                t += '</Data></Cell>';
                            	} else if(Ext.isDefined(cm) && cm[j].hidden==false && cm[j].text.trim().length != 0 &&  v==" "){
                            		t += '<Cell ><Data ss:Type="String">';
	                                if (cellType[k] == 'DateTime') {
	                                    t += Ext.Date.format(v, 'Y-m-d');
	                                } else {
	                                    t += cellData;
	                                }
	                                t += '</Data></Cell>';
                            	} /*else if (v.trim().length == 0) {
	                                t += '<Cell ><Data ss:Type="String">';
	                                t += '</Data></Cell>';
                            	}*/
                            	l++;
                            }
                        k++;
//                        }
                    }
                    len++;
                        t += '</Row>';
                }
                // @auther Bhanu PS
                if(showSummaryRow != undefined && showSummaryRow){
                	var tableSummeryData = tableElement.find('.x-grid-row-summary');
                	t += '<Row>';
                	//V2D-64143
                	if(this.selType !='checkboxmodel'){
                		t +='<Cell ></Cell>';//--For S.No. Column  
                	}
                	if(tableSummeryData[0] != undefined)
                	{
                		for (var j=0; j<tableSummeryData[0].cells.length; j++) {
                			var v = tableSummeryData[0].cells[j].textContent;
                			cellData="<![CDATA["+v+"]]>";
                			t += '<Cell ><Data ss:Type="String">';
                			t += cellData;
                			t += '</Data></Cell>';
                		}
                	}
                	t += '</Row>';
                }
            }
        }
        
        /*for (var i = 0, it = this.store.data.items, l = it.length; i < l; i++) {

            if (!Ext.isEmpty(groupField)) {
                if (groupVal != this.store.getAt(i).get(groupField)) {
                    groupVal = this.store.getAt(i).get(groupField);
                    t += this.generateEmptyGroupRow(groupField, groupVal, cellType, includeHidden);
                }
            }
            t += '<Row>';
            var cellClass = (i & 1) ? 'odd' : 'even';
            r = it[i].data;
            var k = 0;
            for (var j = 0; j < colCount; j++) {
                if (cm[j].xtype != 'actioncolumn' && (cm[j].dataIndex != '') && (includeHidden || !cm[j].hidden)) {
                    var v = r[cm[j].dataIndex];
                    if (cellType[k] !== "None") {
                    	//ss:StyleID="' + cellClass + cellTypeClass[k] + '"
                        t += '<Cell ><Data ss:Type="' + cellType[k] + '">';
                        if (cellType[k] == 'DateTime') {
                            t += Ext.Date.format(v, 'Y-m-d');
                        } else {
                            t += v;
                        }
                        t += '</Data></Cell>';
                    }
                    k++;
                }
            }
            t += '</Row>';
        }*/

		//t +=  ;
		
        result.xml = t.concat(        		
        	'<Row></Row>',
        	'<Row></Row>',
        	'<Row ss:AutoFitHeight="1">',        	
            '<Cell ss:MergeAcross="2">',
            '<Data ss:Type="String">' + generatedBy + '</Data>',
            '</Cell>',        
            '</Row>',
            '<Row ss:AutoFitHeight="1">',                
            '<Cell ss:MergeAcross="2">',
            '<Data ss:Type="String">' + poweredBy + '</Data>',
            '</Cell>',
            '</Row>',
            '<Row ss:AutoFitHeight="1">',
            '<Cell>',
            '<Data ss:Type="String">' + onDate + '</Data>',
            '</Cell>',            
            '</Row>',
            '</Table>',
            '<WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">',
            '<PageLayoutZoom>0</PageLayoutZoom>',
            '<Selected/>',
            '<Panes>',
            '<Pane>',
            '<Number>3</Number>',
            '<ActiveRow>2</ActiveRow>',
            '</Pane>',
            '</Panes>',
            '<ProtectObjects>False</ProtectObjects>',
            '<ProtectScenarios>False</ProtectScenarios>',
            '</WorksheetOptions>',
            '</Worksheet>'
        );
        //console.log(result);
        return result;
    },
    replaceSpecialChar : function(string){
    	/*var strIndex = string.indexOf("View");
    	  if(strIndex != -1) {
    		  string = string.replace("View", "")
    	  }*/
    	/*if(string.contains('View')){
    		string = string.replace("View", "");
    		}*/
  
    	 string = string.replace(/&/g, "&amp;");
         //string = string.replace(/$/g, "&dollar;");
         string = string.replace(/#/g, "&num;");
         string = string.replace(/@/g, "&commat;");
         string = string.replace(/!/g, "&excl;");
         string = string.replace(/`/g, "&grave;");
         string = string.replace(/~/g, "&tilde;");
         //string = string.replace(/^/g, "&circ;");
         string = string.replace(/</g, "&lt;");
         string = string.replace(/>/g, "&gt;");
         return string;
    },
    
    exportreceiptheaderlistexcel: function(){
    	var me = this;
    	var exportUrl = SERVERURL.PATH_GRID_DATA_FOR_PANDC_AND_SERVICE_PROVIDED_EXCEL_REPORT;
    	
    	var frm = this.up('receiptstructure').down('receiptheaderform');
    	var formValues = frm.getValues();
    	
    	var billedUserTypeEnumValue = frm.down("#billFor").getRawValue();
 		var billedUserType = frm.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;

    	var filetype="application/.vnd.ms-excel";
    	var baseController=Academia.app.getController('base.BaseController');
    	var user=baseController.getCurrentlyLoggedInUser();

    	var reportParams =new Object();
    	
    	var programsId = [];
    	for(var i in formValues.program){
    		if(Ext.isObject(formValues.program[i])){
    			programsId.push(formValues.program[i].data.id);
    		}else{
    			programsId.push(formValues.program[i]);
    		}
    	}
    	var programId = programsId.join();
    	
    	var batchId = [];
    	for(var i in formValues.batch){
    		if(Ext.isObject(formValues.batch[i])){
    			batchId.push(formValues.batch[i].data.id);
    		}else{
    			batchId.push(formValues.batch[i]);
    		}
    	}
    	var batchIds = batchId.join();
    	
    	var sectionId = [];
    	for(var i in formValues.section){
    		if(Ext.isObject(formValues.section[i])){
    			sectionId.push(formValues.section[i].data.id);
    		}else{
    			sectionId.push(formValues.section[i]);
    		}
    	}
    	var sectionIds = sectionId.join();

    	var programsId = [];
    	for(var i in formValues.program){
    		if(Ext.isObject(formValues.program[i])){
    			programsId.push(formValues.program[i].data.id);
    		}else{
    			programsId.push(formValues.program[i]);
    		}
    	}
    	var programId = programsId.join();
    	
    	var batchId = [];
    	for(var i in formValues.batch){
    		if(Ext.isObject(formValues.batch[i])){
    			batchId.push(formValues.batch[i].data.id);
    		}else{
    			batchId.push(formValues.batch[i]);
    		}
    	}
    	var batchIds = batchId.join();
    	
    	var sectionId = [];
    	for(var i in formValues.section){
    		if(Ext.isObject(formValues.section[i])){
    			sectionId.push(formValues.section[i].data.id);
    		}else{
    			sectionId.push(formValues.section[i]);
    		}
    	}
    	var sectionIds = sectionId.join();

    	reportParams.currencyId = formValues.receiptCurrency;
    	reportParams.costCenterId = formValues.costCentre;
    	reportParams.programId = programId;
    	reportParams.batchId = batchIds;
    	reportParams.sectionId = sectionIds;
    	reportParams.status = formValues.receiptStatus;
    	reportParams.voucherMode = formValues.voucherMode;
    	reportParams.receiptType = formValues.receiptType;
    	reportParams.billStatus = formValues.billStatus;
    	reportParams.billingfromdate = formValues.billDateFrom;
    	reportParams.billingtodate = formValues.billDateTill;
    	reportParams.billingduefromdate = formValues.billDueDateFrom;
    	reportParams.billingduetodate = formValues.billDueDateTill;
    	reportParams.studentId = formValues.student;
    	reportParams.receiptNo = formValues.receiptNo;
    	reportParams.bankAccountId = formValues.bankId;
    	reportParams.billedUserType = billedUserType;
    	reportParams.billGenerationType = formValues.generationType;
    	reportParams.receiptDateFrom = formValues.receiptDateFrom;
    	reportParams.receiptDateTo = formValues.receiptDateTo;
    	reportParams.billHeaderId = frm.down("#billNo").getValue();
    	reportParams.receiptHeaderId = frm.down("#receiptNo").getValue();
    	reportParams.paymentModeId = formValues.paymentMode;
    	var academyLocationId = frm.down("#fnpMultiBrandCampusItemId").getValue();
    	        var alIds = [];
    	            var academyLocationIds = null;
    	         if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
    	                for (var i in academyLocationId) {
    	                    if (Ext.isObject(academyLocationId[0])) {
    	                        if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
    	                            alIds.push(academyLocationId[i].get("id"));
    	                        }else{
    	                            alIds.push(academyLocationId[i]);
    	                        }
    	                    } else {
    	                        alIds.push(academyLocationId[i]);
    	                    }
    	                }
    	                academyLocationIds = alIds.join();
    	            }else{
    	                academyLocationIds = academyLocationId;
    	            }  
    	         reportParams.academyLocationId = academyLocationIds;
    
    	reportParams.academyLocationIds = formValues.fnpMultiBrandCampusName.join();
    	reportParams.whetherDeleted = frm.down("#whetherDeleted").getValue();
    	reportParams.onlyInactiveStudent = frm.down("#inactiveStudentId").getValue();
    	reportParams.raiseBillType = formValues.billType;
		  	reportParams.code = "LIST OF RECEIPT";


    	reportParams.headerList = {};
    	
    	Ext.each(me.columnManager.columns, function(currentColumn){
    		if(!currentColumn.hidden && currentColumn.getIndex() != 0){
    			reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
    		}
    	});
    	
    	var exportDocumentData =new Object();
    	exportDocumentData.code="LIST OF RECEIPT";
    	exportDocumentData.userId=user.code;
    	exportDocumentData.reportParams=reportParams;
    	exportDocumentData.academyLocationId=baseController.getCurrentAcademyLocation();
    	exportDocumentData.reportTitle="LIST OF RECEIPT";
    	

    	var csvForm = Ext.create('Ext.form.Panel',{
    		items:[{
    			xtype : 'textfield',
    			maxLength:1000000,
    			itemId : 'exportDocumentData',
    			name : 'exportDocumentData'
    		}]
    	}); 
    	if(exportDocumentData.reportParams){
    		delete exportDocumentData.reportParams.costCenterId;
    	}
    	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));
    	
    	csvForm.getForm().submit({
    		target: '_blank',
    		method:'POST',
    		params :{access_token : Ext.Ajax.defaultHeaders.access_token},
    		headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    		url : exportUrl,
    		standardSubmit :true
    	});
    },
    
    exportManageBillGridExcel : function(grid,type){
		    	 var me = this;
		    	 var exportUrl = SERVERURL.PATH_MANAGE_BILL_EXPORT_ALL_EXCEL_REPORT;
		         var filetype="application/.vnd.ms-excel";
		         var frm =  this.up('billstructure').down('billheaderpcsearchform');
		         var formValues = frm.getValues();
		         var REPORT_NAME = "Manage Bill";
		         var baseController=Academia.app.getController('base.BaseController');
		         var user=baseController.getCurrentlyLoggedInUser();
		
		         var reportParams =new Object();
		
		         reportParams.raiseBillType = formValues.billType;
		         reportParams.billedUserType = formValues.billView;
		         reportParams.billGenerationType = formValues.billGenerationType;
		         reportParams.raiseBillCategory = formValues.raiseBillCategory;
		         var currencyId = formValues.currency;
		         reportParams.currencyId = currencyId;
		         var sectionId = formValues.sectionId;
		         reportParams.sectionId = sectionId;
		         reportParams.billStatus = formValues.billStatus;
		         var studentId = formValues.student;
		         reportParams.studentId = studentId;
		         reportParams.billingfromdate = formValues.billDateForm;
		         reportParams.billingtodate = formValues.billDateTill;
		         reportParams.billingduefromdate = formValues.billDueDateForm;
		         reportParams.billingduetodate = formValues.billDueDateTill;
		         var intakeYear = formValues.intakeYear;
		         reportParams.intakeYear = intakeYear;
		         var discountCodeId = formValues.discountCode;
		         reportParams.discountCodeId = discountCodeId;
		         reportParams.whetherDeleted = formValues.whetherDeleted;
		         var programGroupId = formValues.programGroup;
		         reportParams.programGroupId = programGroupId;
		         var programCategoryId = formValues.programCategory;
		         reportParams.programCategoryId = programCategoryId;
		         reportParams.billNo = formValues.billNo;
		         reportParams.isFlagEnable = formValues.isFlagEnable;  
		         reportParams.isInactiveStudentId = formValues.inactiveStudent;
		         reportParams.isInactiveAdmissionId = formValues.inactiveAdmission;
		         var admissionId = formValues.admission;
		         reportParams.admissionId = admissionId;
		         reportParams.billNo = formValues.invoiceOrCreditNoteNum;
		         reportParams.loggedAl = '1';
		         



		         // al ids
		         var academyLocationId = frm.down("#fnpMultiBrandCampusManageBillId").getValue();
		         		var alIds = [];
		          	   	var academyLocationIds = null;
		         	 	if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
		         	 		   for (var i in academyLocationId) {
		         	 			   if (Ext.isObject(academyLocationId[0])) {
		         	 				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
		         	 					   alIds.push(academyLocationId[i].get("id"));
		         	 				   }else{
		         	 					   alIds.push(academyLocationId[i]);
		         	 				   }
		         	 			   } else {
		         	 				   alIds.push(academyLocationId[i]);
		         	 			   }
		         	 		   }
		         	 		   academyLocationIds = alIds.join();
		         	 	   }else{
		         	 		   academyLocationIds = academyLocationId;
		         	 	   }
		         reportParams.academyLocationId = academyLocationIds;
         
         		// program
		        var programId = frm.down("#programId").getValue();
		  		var pIds = [];
		   	   	var programIds = null;
		  	 	if (!isNullOrEmpty(programId) && programId.length > 0 && !isNullOrEmpty(programId[0])) {
		  	 		   for (var i in programId) {
		  	 			   if (Ext.isObject(programId[0])) {
		  	 				   if(Ext.isObject(programId[i]) && programId[i]!=""){
		  	 					pIds.push(programId[i].get("id"));
		  	 				   }else{
		  	 					pIds.push(programId[i]);
		  	 				   }
		  	 			   } else {
		  	 				pIds.push(programId[i]);
		  	 			   }
		  	 		   }
		  	 		programIds = pIds.join();
		  	 	   }else{
		  	 		programIds = programId;
		  	 	   }
		  	 	reportParams.programId = programIds;

  
  	 			// batch
		  	 	var batchId = frm.down("#batchId").getValue();
		  	 	if (isNullOrEmpty(batchId) || (Array.isArray(batchId) && batchId.length === 1 && batchId[0] === '')) {
		  	 	    batchId = null;
		  	 	}
		  	 	var bIds = [];
		  	 	var batchIds = null;
		  	 	if (!isNullOrEmpty(batchId) && batchId.length > 0 && !isNullOrEmpty(batchId[0])) {
				   for (var i in batchId) {
					   if (Ext.isObject(batchId[0])) {
						   if(Ext.isObject(batchId[i]) && batchId[i]!=""){
							   bIds.push(batchId[i].get("id"));
						   }else{
							   bIds.push(batchId[i]);
						   }
					   } else {
						   bIds.push(batchId[i]);
					   }
				   }
				   batchIds = bIds.join();
		  	 	}else{
				   batchIds = batchId;
		  	 	}
		  	 	reportParams.batchId = batchIds;
		  	 	
  	 			// billLabelIds
		  	 	var billLabelId = frm.down("#billLabelId").getValue();
		  	 	var blIds = [];
		  	 	var billLabelIds = null;
		  	 	if (!isNullOrEmpty(billLabelId) && billLabelId.length > 0 && !isNullOrEmpty(billLabelId[0])) {
				   for (var i in batchId) {
					   if (Ext.isObject(billLabelId[0])) {
						   if(Ext.isObject(billLabelId[i]) && billLabelId[i]!=""){
							   blIds.push(billLabelId[i].get("id"));
						   }else{
							   blIds.push(billLabelId[i]);
						   }
					   } else {
						   blIds.push(billLabelId[i]);
					   }
				   }
				   billLabelIds = bIds.join();
		  	 	}else{
		  	 		billLabelIds = billLabelId;
		  	 	}
		  	 	reportParams.billLabelIds = billLabelIds;
		
		         reportParams.headerList = {};
		         Ext.each(me.columnManager.columns, function(currentColumn){
		             		if(!currentColumn.hidden && currentColumn.getIndex() != 0){
		             			reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
		             		}
		             	});


                 var exportDocumentData =new Object();

             	exportDocumentData.code=REPORT_NAME;
             	exportDocumentData.userId=user.code;
             	exportDocumentData.reportParams=reportParams;
             	exportDocumentData.academyLocationId=baseController.getCurrentAcademyLocation();
             	exportDocumentData.reportTitle=REPORT_NAME;
             	if(type === 'allPDF'){
		    		 exportUrl = SERVERURL.PATH_MANAGE_BILL_PDF_GENERATE;
		    		 filetype = "application/pdf";
		    		 reportParams.reportCode="LIST_OF_INVOICES_AND_CREDIT_NOTES";
		    		 reportParams.reportTitle="List Of Invoices And Credit Notes";
		    	 }
             	

             	var csvForm = Ext.create('Ext.form.Panel',{
             		items:[{
             			xtype : 'textfield',
             			maxLength:1000000,
             			itemId : 'exportDocumentData',
             			name : 'exportDocumentData'
             		}]
             	});
             	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));

             	csvForm.getForm().submit({
             		target: '_blank',
             		method:'POST',
             		params :{access_token : Ext.Ajax.defaultHeaders.access_token},
             		headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
             		url : exportUrl,
             		standardSubmit :true
             	});
        
    	
    },
    exportActualaccountStatementGridExcel : function(grid)
    {
            var me = this;
            var exportUrl = SERVERURL.PATH_GRID_TRANSACTIONAL_STATEMENT_OF_ACCOUNT_EXPORT_ALL;
            var frm = this.up('accountstatmentstructure').down('accountstatementsearch');
            var formValues = frm.getValues();
            var REPORT_NAME = "";
            if(grid.xtype == "actualaccountstatementgrid")
            {
                REPORT_NAME = "List of Student";
            }else if (grid.xtype == 'actualapplicantaccountstatementgrid')
            {
                REPORT_NAME = "List of Applicant";
            }else if(grid.xtype == 'actualsponsoraccountstatementgrid')
            {
                REPORT_NAME = "List of Sponsor";
            }


            var filetype="application/.vnd.ms-excel";
            var baseController=Academia.app.getController('base.BaseController');
            var user=baseController.getCurrentlyLoggedInUser();

            var reportParams =new Object();

            reportParams.applicant = formValues.applicant;
            reportParams.programCategory = formValues.programCategory;
            reportParams.programGroup = formValues.programGroup;
            reportParams.programName = formValues.programName;
            reportParams.batchName = formValues.batchName;
            reportParams.recieptView = formValues.recieptView;
            reportParams.sponsors = formValues.sponsors;
            reportParams.startDate = formValues.startDate;
            reportParams.student = formValues.student;
            reportParams.seatType = formValues.seatType;
            reportParams.tillDate = formValues.tillDate;
            reportParams.transactionType = formValues.transactionType;
            reportParams.STATUS = formValues.STATUS;
            reportParams.showAllStudents = formValues.showAllStudents;
            reportParams.includeAllCancelledTransaction = formValues.includeAllCancelledTransaction;


            var academyLocationId = frm.down("#academyLocationId").getValue();
            		var alIds = [];
             	   	var academyLocationIds = null;
            	 	if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
            	 		   for (var i in academyLocationId) {
            	 			   if (Ext.isObject(academyLocationId[0])) {
            	 				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
            	 					   alIds.push(academyLocationId[i].get("id"));
            	 				   }else{
            	 					   alIds.push(academyLocationId[i]);
            	 				   }
            	 			   } else {
            	 				   alIds.push(academyLocationId[i]);
            	 			   }
            	 		   }
            	 		   academyLocationIds = alIds.join();
            	 	   }else{
            	 		   academyLocationIds = academyLocationId;
            	 	   }
            reportParams.academyLocationId = academyLocationIds;


            reportParams.headerList = {};
            Ext.each(me.columnManager.columns, function(currentColumn){
                		if(!currentColumn.hidden && currentColumn.getIndex() != 0){
                			reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
                		}
                	});


                    var exportDocumentData =new Object();

                	exportDocumentData.code=REPORT_NAME;
                	exportDocumentData.userId=user.code;
                	exportDocumentData.reportParams=reportParams;
                	exportDocumentData.academyLocationId=baseController.getCurrentAcademyLocation();

                	exportDocumentData.reportTitle=REPORT_NAME;

                	var csvForm = Ext.create('Ext.form.Panel',{
                		items:[{
                			xtype : 'textfield',
                			maxLength:1000000,
                			itemId : 'exportDocumentData',
                			name : 'exportDocumentData'
                		}]
                	});
                	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));

                	csvForm.getForm().submit({
                		target: '_blank',
                		method:'POST',
                		params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                		headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                		url : exportUrl,
                		standardSubmit :true
                	});

    },
    exportIntellimaliGridExcel : function(grid)
    {
            var me = this;
            var exportUrl = SERVERURL.PATH_INTELLIMALI_GRID_DATA_EXPORT_ALL;
            var frm = this.up('intellimaliscreen').down('intellimalisearchfilter');
            var formValues = frm.getValues();
            var REPORT_NAME = "";
            if(grid.xtype == "intellimaligrid")
            {
                REPORT_NAME = "List of Intellimali";
            }

            var filetype="application/.vnd.ms-excel";
            var baseController=Academia.app.getController('base.BaseController');
            var user=baseController.getCurrentlyLoggedInUser();
            
            var reportParams =new Object();

            reportParams.accountingYearId = formValues.intellimaliAccountingYear;
            reportParams.studentId = formValues.student;
            reportParams.startDate = formValues.fromdate;
            reportParams.endDate = formValues.todate;
            reportParams.fundAllocationType = formValues.fundAllocation;
            reportParams.status = formValues.status;

            var academyLocationId = frm.down("#intellimaliBrandCampusName").getValue();
            		var alIds = [];
             	   	var academyLocationIds = null;
            	 	if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
            	 		   for (var i in academyLocationId) {
            	 			   if (Ext.isObject(academyLocationId[0])) {
            	 				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
            	 					   alIds.push(academyLocationId[i].get("id"));
            	 				   }else{
            	 					   alIds.push(academyLocationId[i]);
            	 				   }
            	 			   } else {
            	 				   alIds.push(academyLocationId[i]);
            	 			   }
            	 		   }
            	 		   academyLocationIds = alIds.join();
            	 	   }else{
            	 		   academyLocationIds = academyLocationId;
            	 	   }
            reportParams.academyLocationId = academyLocationIds;


            reportParams.headerList = {};
            Ext.each(me.columnManager.columns, function(currentColumn){
                		if(!currentColumn.hidden && currentColumn.getIndex() != 0){
                			reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
                		}
                	});


                    var exportDocumentData =new Object();

                	exportDocumentData.code=REPORT_NAME;
                	exportDocumentData.userId=user.code;
                	exportDocumentData.reportParams=reportParams;
                	exportDocumentData.academyLocationId=baseController.getCurrentAcademyLocation();

                	exportDocumentData.reportTitle=REPORT_NAME;

                	var csvForm = Ext.create('Ext.form.Panel',{
                		items:[{
                			xtype : 'textfield',
                			maxLength:1000000,
                			itemId : 'exportDocumentData',
                			name : 'exportDocumentData'
                		}]
                	});
                	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));

                	csvForm.getForm().submit({
                		target: '_blank',
                		method:'POST',
                		params :{access_token : Ext.Ajax.defaultHeaders.access_token},
                		headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
                		url : exportUrl,
                		standardSubmit :true
                	});

    },
     exportreceiptheaderApplicantlistexcel: function(){
    	var me = this;
    	var exportUrl = SERVERURL.PATH_EXPORT_ALL_GRID_DATA_FOR_APPLICANT;
    	
    	var frm = this.up('receiptstructure').down('receiptheaderform');
    	var formValues = frm.getValues();
    	
    	var billedUserTypeEnumValue = frm.down("#billFor").getRawValue();
 		var billedUserType = frm.down("#billFor").store.findRecord('value', billedUserTypeEnumValue).data.displayValue;

    	var filetype="application/.vnd.ms-excel";
    	var baseController=Academia.app.getController('base.BaseController');
    	var user=baseController.getCurrentlyLoggedInUser();

    	var reportParams =new Object();

    	reportParams.currencyId = formValues.receiptCurrency;
    	reportParams.costCenterId = formValues.costCentre;
    	reportParams.programId = formValues.program;
    	reportParams.batchId = formValues.batch;
    	reportParams.sectionId = formValues.section;
    	reportParams.status = formValues.receiptStatus;
    	reportParams.voucherMode = formValues.voucherMode;
    	reportParams.receiptType = formValues.receiptType;
    	reportParams.billStatus = formValues.billStatus;
    	reportParams.billingfromdate = formValues.billDateFrom;
    	reportParams.billingtodate = formValues.billDateTill;
    	reportParams.billingduefromdate = formValues.billDueDateFrom;
    	reportParams.billingduetodate = formValues.billDueDateTill;
    	reportParams.studentId = formValues.student;
    	reportParams.receiptNo = formValues.receiptNo;
    	reportParams.bankAccountId = formValues.bankId;
    	reportParams.billedUserType = billedUserType;
    	reportParams.billGenerationType = formValues.generationType;
    	reportParams.receiptDateFrom = formValues.receiptDateFrom;
    	reportParams.receiptDateTo = formValues.receiptDateTo;
    	reportParams.billHeaderId = frm.down("#billNo").getValue();
    	reportParams.receiptHeaderId = frm.down("#receiptNo").getValue();
    	reportParams.paymentModeId = formValues.paymentMode;
    	//reportParams.academyLocationIds = formValues.fnpMultiBrandCampusName.join();
    	
    	var academyLocationId = frm.down("#fnpMultiBrandCampusItemId").getValue();
		var alIds = [];
 	   	var academyLocationIds = null;
	 	if (!isNullOrEmpty(academyLocationId) && academyLocationId.length > 0 && !isNullOrEmpty(academyLocationId[0])) {
	 		   for (var i in academyLocationId) {
	 			   if (Ext.isObject(academyLocationId[0])) {
	 				   if(Ext.isObject(academyLocationId[i]) && academyLocationId[i]!=""){
	 					   alIds.push(academyLocationId[i].get("id"));
	 				   }else{
	 					   alIds.push(academyLocationId[i]);
	 				   }
	 			   } else {
	 				   alIds.push(academyLocationId[i]);
	 			   }
	 		   }
	 		   academyLocationIds = alIds.join();
	 	   }else{
	 		   academyLocationIds = academyLocationId;
	 	   }
	 	reportParams.academyLocationId = academyLocationIds;
	 	
    	reportParams.whetherDeleted = frm.down("#whetherDeleted").getValue();
    	reportParams.onlyInactiveStudent = frm.down("#inactiveStudentId").getValue();
    	reportParams.raiseBillType = formValues.billType;
    	
    	//reportParams.academyLocationId = formValues.fnpMultiBrandCampusName.join();
    	/*if(formValues.fnpMultiBrandCampusName.length==1){
			reportParams.academyLocationId = Ext.pluck(Ext.pluck(formValues.fnpMultiBrandCampusName,'data'),'id').join();
		}else{
			reportParams.academyLocationId = formValues.fnpMultiBrandCampusName.join();
		}*/
    	reportParams.code = "LIST OF RECEIPT";
    	reportParams.personId=frm.down("#applicant").getValue();
    	


    	reportParams.headerList = {};
    	
    	Ext.each(me.columnManager.columns, function(currentColumn){
    		if(!currentColumn.hidden && currentColumn.getIndex() != 0){
    			reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
    		}
    	});
    	
    	var exportDocumentData =new Object();
    	exportDocumentData.code="LIST OF RECEIPT";
    	exportDocumentData.userId=user.code;
    	exportDocumentData.reportParams=reportParams;
    	exportDocumentData.academyLocationId=baseController.getCurrentAcademyLocation();
    	exportDocumentData.reportTitle="LIST OF RECEIPT";
    	

    	var csvForm = Ext.create('Ext.form.Panel',{
    		items:[{
    			xtype : 'textfield',
    			maxLength:1000000,
    			itemId : 'exportDocumentData',
    			name : 'exportDocumentData'
    		}]
    	}); 
    	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));
    	
    	csvForm.getForm().submit({
    		target: '_blank',
    		method:'POST',
    		params :{access_token : Ext.Ajax.defaultHeaders.access_token},
    		headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
    		url : exportUrl,
    		standardSubmit :true
    	});
    },
    
    exportBulkExamResultPublishExcel: function () {
    	var academyLocationIdsArr = [];
        var me = this;
        var exportUrl = SERVERURL.PATH_EXPORT_BULK_RESULT_PUBLISH_DATA;

        var frm = this.up('bulkExamResultPublishTab').down('bulkExamResultPublishFilter');
        var formValues = frm.getValues();

        var filetype = "application/.vnd.ms-excel";
        var baseController = Academia.app.getController('base.BaseController');
        var user = baseController.getCurrentlyLoggedInUser();

        var reportParams = new Object();

        var courseIds = [];
        if (!isNullOrEmpty(formValues.courseId) && !isNullOrEmpty(formValues.courseId[0])) {
            for (var r = 0; r < formValues.courseId.length; r++) {
                courseIds.push(formValues.courseId[r].get("id"));
            }
        }

        var levelOneId = null;
        var levelTwoId = null;
        var levelThreeId = null;
        var levelFourId = null;
        var assessmentSchemeLevel = frm.down('#evaluationLevelItemIdBulkPublish');
        var record = assessmentSchemeLevel.lastSelection;
        var filterPlanId = null;
        if (record && record.length && !isNullOrEmpty(record[0].data.code)) {
            if (record[0].data.code == "Assessment Method") {
                levelThreeId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Sub Type") {
                levelTwoId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Type") {
                levelOneId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Event") {
                levelFourId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Scheme") {
                filterPlanId = record[0].data.levelId;
            }
        }
        if(typeof formValues.academyLocation == 'object'){
        	formValues.academyLocation.forEach(function(obj){
		  		if(!isNaN(obj)) {
					academyLocationIdsArr.push(obj);
				}
				else {
		  			academyLocationIdsArr.push(obj.get('id'));
		  		}
		  	});
		}
		else{
			academyLocationIdsArr.push(formValues.academyLocation)
		}
        reportParams.academicTermId = formValues.academicTerm;
        reportParams.academyLocationIds = academyLocationIdsArr.join();
        reportParams.evaluationPlanId = formValues.evaluationPlanId;
        reportParams.programId = formValues.programId;
        reportParams.batchId = formValues.batchId;
        reportParams.courseIds = courseIds.join(",");
        reportParams.filterPlanId = filterPlanId;
        reportParams.evaluationPlanOneId = levelOneId;
        reportParams.evaluationPlanTwoId = levelTwoId;
        reportParams.evaluationSequenceId = levelThreeId;
        reportParams.eventId = levelFourId;
        reportParams.code = getCommonTranslation('EXAMINATION_RESULT_PUBLISH');

        reportParams.headerList = {};

        Ext.each(me.columnManager.columns, function (currentColumn) {
            if (!currentColumn.hidden && currentColumn.getIndex() != 0) {
                reportParams.headerList[currentColumn.dataIndex] = currentColumn.text;
            }
        });

        var exportDocumentData = new Object();
        exportDocumentData.code = getCommonTranslation('EXAMINATION_RESULT_PUBLISH');
        exportDocumentData.userId = user.code;
        exportDocumentData.reportParams = reportParams;
        exportDocumentData.academyLocationId = baseController.getCurrentAcademyLocation();
        if(formValues.publishResultAsHostFaculty) {
			exportDocumentData.academyLocationId = null;
		}
        exportDocumentData.reportTitle = getCommonTranslation('EXAMINATION_RESULT_PUBLISH');

        var csvForm = Ext.create('Ext.form.Panel', {
            items: [{
                xtype: 'textfield',
                maxLength: 1000000,
                itemId: 'exportDocumentData',
                name: 'exportDocumentData'
            }]
        });
        csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));

        csvForm.getForm().submit({
            target: '_blank',
            method: 'POST',
            params: {
                access_token: Ext.Ajax.defaultHeaders.access_token
            },
            headers: {
                'Accept': filetype,
                'Content-Type': 'application/json',
                'Authorization': Ext.Ajax.defaultHeaders.Authorization
            },
            url: exportUrl,
            standardSubmit: true
        });
    },
    
    exportExamAssignRemarkReport: function (type) {
    	var academyLocationIdsArr = [];
        var me = this;
        var exportUrl = SERVERURL.EXAM_PATH_REMARK_REPORT_PDF_AND_EXCEL;

        var frm = this.up('evaluationremarkmasterstructure').down('evaluationremarkquickfilter');
        var formValues = frm.getValues();

        var filetype = "application/.vnd.ms-excel";
        var baseController = Academia.app.getController('base.BaseController');
        var user = baseController.getCurrentlyLoggedInUser();

        var reportParams = new Object();

        var levelOneId = null;
        var levelTwoId = null;
        var levelThreeId = null;
        var levelFourId = null;
        var assessmentSchemeLevel = frm.down('#evalPlanLevelItemId');
        var record = assessmentSchemeLevel.lastSelection;
        var filterPlanId = null;
        var facultyId = null;
        
        if (record && record.length && !isNullOrEmpty(record[0].data.code)) {
            if (record[0].data.code == "Assessment Method") {
                levelThreeId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Sub Type") {
                levelTwoId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Type") {
                levelOneId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Event") {
                levelFourId = record[0].data.levelId;
            } else if (record[0].data.code == "Assessment Scheme") {
                filterPlanId = record[0].data.levelId;
            }
        }

        var exportDocumentData = new Object();

        /*exportDocumentData.headerList = {};

        Ext.each(me.columnManager.columns, function (currentColumn) {
            if (!currentColumn.hidden && currentColumn.getIndex() != 0) {
            	exportDocumentData.headerList[currentColumn.dataIndex] = currentColumn.text;
            }
        });*/
        
        /** Only fetch the faculty Id in-case of faculty portal */
        if(portalId==2){
			facultyId = baseController.getCurrentlyLoggedInUser().id;
		}

        
	    exportDocumentData.academyLocationId = baseController.getCurrentAcademyLocation();
        exportDocumentData.academicTermId = formValues.academicTerm;
        exportDocumentData.courseId = formValues.courseId;
        exportDocumentData.courseVariantId = formValues.courseVariant;
        exportDocumentData.evaluationPlanId = formValues.evaluationPlan;
        exportDocumentData.evaluationPlanLevelOneId = levelOneId;
        exportDocumentData.evaluationPlanLevelTwoId = levelTwoId;
        exportDocumentData.evaluationSequenceId = levelThreeId;
        exportDocumentData.userId = user.code;
       
        exportDocumentData.remarkStatus = formValues.subjectRemarkStatusId;
        exportDocumentData.facultyId = facultyId;
        exportDocumentData.isHostFaculty = formValues.remarkAsHostFaculty;
        
        try{
        	exportDocumentData.planName = frm.down('#evaluationPlanItemId').lastSelection[0].get('value');
        	exportDocumentData.levelName = frm.down('#evalPlanLevelItemId').lastSelection[0].get('value');
        }
        catch(e) {}
        
        exportDocumentData.code = type.indexOf('PDF') != -1 ? 'VELOCITY_EXAM_REMARK_REPORT_PDF' : 'VELOCITY_EXAM_REMARK_REPORT_EXCEL';
        exportDocumentData.reportTitle = getExaminationTranslation('MANAGE_EVALUATION_REMARK_LIST');
        
        var store = me.getStore();
        var sortInfo = store.getSorters();
        exportDocumentData.page = store.currentPage;
        exportDocumentData.limit = store.pageSize;
        exportDocumentData.type = type;
        try {
        	if(sortInfo && sortInfo[0]) {
            	exportDocumentData.sort = Ext.encode([{
                	property: sortInfo[0].property,
                	direction: sortInfo[0].direction
                }]);
            }
        }
        catch(e) {}

        var csvForm = Ext.create('Ext.form.Panel', {
            items: [{
                xtype: 'textfield',
                maxLength: 1000000,
                itemId: 'exportDocumentData',
                name: 'exportDocumentData'
            }]
        });
        csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));

        csvForm.getForm().submit({
            target: '_blank',
            method: 'POST',
            params: {
                access_token: Ext.Ajax.defaultHeaders.access_token
            },
            headers: {
                'Accept': filetype,
                'Content-Type': 'application/json',
                'Authorization': Ext.Ajax.defaultHeaders.Authorization
            },
            url: exportUrl,
            standardSubmit: true
        });
    }
});
   

var Base64 = (function() {
    // Private property
    var keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    // Private method for UTF-8 encoding

    function utf8Encode(string) {
    	//console.log('String...data....',string);
        string = string.replace(/\r\n/g, "\n");

       // string = string.replace(/&/g, "&amp;");
       /* string = string.replace(/$/g, "&dollar;");
        string = string.replace(/#/g, "&num;");
        string = string.replace(/@/g, "&commat;");
        string = string.replace(/!/g, "&excl;");
        string = string.replace(/`/g, "&grave;");
        string = string.replace(/~/g, "&tilde;");*/
        //string = string.replace(/^/g, "&circ;");
        //string = string.replace(/</g, "&lt;");
        //string = string.replace(/>/g, "&gt;");
        var utftext = "";
        for (var n = 0; n < string.length; n++) {
            var c = string.charCodeAt(n);
            if (c < 128) {
                utftext += String.fromCharCode(c);
            } else if ((c > 127) && (c < 2048)) {
                utftext += String.fromCharCode((c >> 6) | 192);
                utftext += String.fromCharCode((c & 63) | 128);
            } else {
                utftext += String.fromCharCode((c >> 12) | 224);
                utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                utftext += String.fromCharCode((c & 63) | 128);
            }
        }
        return utftext;
    }

    // Public method for encoding
    return {
        encode: (typeof btoa == 'function') ? function(input) {
            return btoa(utf8Encode(input));
        } : function(input) {
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            input = utf8Encode(input);
            while (i < input.length) {
                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output = output +
                    keyStr.charAt(enc1) + keyStr.charAt(enc2) +
                    keyStr.charAt(enc3) + keyStr.charAt(enc4);
            }
            return output;
        }
    };
})();