/**
 * @author Rohit Thadani 
 */
Ext.define('Academia.view.facilitiesresources.resourcebooking.StudentResourceBookingGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentresourcebookinggrid',
	store: 'facilitiesresources.resourcebooking.StudentResourceBookingStore',
	/* requires : ['Academia.view.facilitiesresources.resourcebooking.ResourceFeedBackWindow' ], */
	title: getCommonTranslation('LIST_OF_SCHEDULED_EVENTS'), //List of scheduled events
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [/*{
        header: getCommonTranslation('EVENT_ID'), //Event ID
        dataIndex: 'id',
        flex: .1
    }, */{
    	header: getCommonTranslation('EVENT_NAME'), //Event Name
    	dataIndex: 'eventName',
    	sortable: true,
    	flex: .1
    }, {
    	header: getCommonTranslation('PURPOSE'), //Purpose
    	dataIndex: 'purpose',
    	flex: .1
    }, {
    	header: getCommonTranslation('CREATED_BY'), //Created By
    	dataIndex: 'bookedBy',
    	flex: .1,/*,
        renderer: function(object) {
            return comboRender(object, 'value');
        }*/
    }, {
    	header: getCommonTranslation('EVENT_DATE'), //Event Date
    	dataIndex: 'eventDate',
    	flex: .1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    },{
    	header: getCommonTranslation('FROM_TIME'), //Event Date
    	dataIndex: 'fromTime',
    	flex: .1,
    	renderer:function(date) {
    		return timeRender(date);
    	}
    }, {
    	header: getCommonTranslation('TO_TIME'), //Event Date
    	dataIndex: 'toTime',
    	flex: .1,
    	renderer:function(date) {
    		return timeRender(date);
    	}
    }, {
    	header: getFeeAndPaymentCommonTranslation('END_DATE'), //Event Date
    	dataIndex: 'endDate',
    	flex: .1,
    	renderer:function(date) {
    		return dateRender(date);
    	}
    }, {
    	header: getCommonTranslation('COMMITTEE_NAME'), //Created By
    	dataIndex: 'committeeName',
    	flex: .1,/*,
        renderer: function(object) {
            return comboRender(object, 'value');
        }*/
    },{
    	header: getCommonTranslation('VENUE'), //Created By
    	dataIndex: 'venue',
    	flex: .1,/*,
        renderer: function(object) {
            return comboRender(object, 'value');
        }*/
    }, {
    	header: getCommonTranslation('EVENT_REPEAT_ON'),
    	dataIndex: 'repeatOn',
    	flex: .1,
    	hidden: true,
    	renderer: function(value) {
    		var weekdayString = '';
    		if (!isNullOrEmpty(value)) {
    			var weekdayStringArr = value.split(',');
    			for (i in weekdayStringArr) {
    				weekdayString = weekdayString + ',' + getCommonTranslation(weekdayStringArr[i]);
    			}
    			weekdayString = weekdayString.substring(1, weekdayString.length);
    		}
    		return weekdayString;
    	}
    }],
    initComponent: function() {

    	var grid=this;                   

    	grid.addExportToolBarItems(grid);

    	this.callParent(arguments);     

    },
    tbar: [{
    	xtype: 'button',
    	itemId: 'btnView',
    	tooltip: getCommonTranslation('VIEW_RESOURCE_BOOKING_DETAILS'),
    	iconCls: 'view-icon'
    		//text : getCommonTranslation('VIEW')
    }],
    dockedItems: [{
    	xtype: 'toolbar',
    	dock: 'bottom',
    	items: [{
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		displayInfo: true,
    		emptyMsg: '<p>'+getCommonTranslation('EMPTY_RESOURCE_BOOKING_MESSAGE')+'</p>', //No scheduled events to display
    		store: 'facilitiesresources.resourcebooking.StudentResourceBookingStore'
    	}]
    }],
    showResourceFeedbackWindow: function() {
    	var winResourceFeedback = Ext.widget('resourcefeedbackwindow');
    	winResourceFeedback.show();
    }
});