var hostelLevelStore = Ext.create('Ext.data.Store', {
    fields: ['id', 'value'],
    data : [
        {"id":"Senior", "value":"Senior"},
        {"id":"Junior", "value":"Junior"},
        //...
    ]
});
var hostelCategoryStore = Ext.create('Ext.data.Store', {
    fields: ['id', 'value'],
    data : [
        {"id":"CATERED", "value":"Catered"},
        {"id":"SELF_CATERED", "value":"Self-catered"},
        //...
    ]
});

Ext.define('Academia.view.facilitiesresources.resourcemaster.ResourceBasicDetails',{
	extend:'Academia.view.common.DynamicFieldForm',
	alias:'widget.resourcebasicdetails',
	autoScroll:true,
	frame: true,
	titleCollapse: true,
	plugins : "formlabelrequired",
	
	items:[{
		xtype:'fieldcontainer',		
		defaults:{
			labelAlign:'top',
			width:226			 
		},
		layout:{
			type:'hbox'
		},
		items:[{
			xtype:'hidden',
			itemId:'id',
			name:'id'
		},{
			xtype:'hidden',
			name:'version'
		},{
			xtype:'hidden',
			itemId:'resourceGroup',
			name:'resourceGroup'
		},{
			xtype:'hidden',
			itemId:'category',
			name:'category'
		},{
			xtype:'hidden',
			itemId:'parentNodeId',
			name:'parent'
		},{
			xtype:'hidden',
			name:'type',
			itemId:'type'
		},{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('RESOURCE_TYPE'),
			store:'facilitiesresources.resourcebooking.ResourceTypeStore',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			emptyText:getCommonTranslation('SELECT_RESOURCE_TYPE'),
			itemId:'formComboResourceTypeId',
			name:'resourceType',		
			queryMode:'local',
			editable:false,		
			overrideSetValue:false
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('HOSTEL_LEVEL'),
			store:hostelLevelStore,
			displayField:'value',
			valueField:'id',			
			itemId:'hostelLevel',
			name:'hostelLevel',
			editable:false,
			width:226,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype:'nestedJsonCombo',
			fieldLabel: getTransportTranslation('SUB_TYPE'),
			name: 'vehicleSubTypeId',
			itemId:'vehicleSubTypeId',
			store: 'transport.vehicle.VehicleSubType',
			displayField: 'value',
			valueField: 'id',
			allowBlank: false,
			hidden:true,
			disabled: true,
			editable:false,		
			overrideSetValue:false
		}]
	},{
		xtype:'fieldcontainer',		
		defaults:{
			xtype:'textfield',
			labelAlign:'top',
			width:226,
			maxLength:100,
			enforceMaxLength : true,
			
		},
		layout:{
			type:'hbox'
		},
		items:[{
			fieldLabel:getCommonTranslation('RESOURCE_CODE'),
			name:'code',
			allowBlank:false
		},{
			fieldLabel:getCommonTranslation('RESOURCE_NAME'),
			name:'name',
			allowBlank:false
		},{
			fieldLabel:getCommonTranslation('SHORT_NAME'),
			name:'shortName',
			itemId:'shortName',
			maxLength:50,
			enforceMaxLength : true,
		},{
			fieldLabel:getCommonTranslation('RESOURCE_NAME_OTHER_LANGUAGE'),
			name:'resourceNameOtherLanguage',
			itemId:'resourceNameOtherLanguageId',
			maxLength:255,
			enforceMaxLength : true,
			hidden:true,
		}]
	},{
		xtype:'fieldcontainer',	
		defaults:{
			xtype:'textfield',
			labelAlign:'top',
			width:226	,
			maxLength:100,
			enforceMaxLength : true,
		},
		layout:{
			type:'hbox'
		},
		items:[{
			fieldLabel:getCommonTranslation('NAME_TO_PRINT'),
			name:'nameToBePrinted',
			itemId:'nameToPrint'
		},{
			fieldLabel:getCommonTranslation('LANDMARK'),
			name:'landMark',
			itemId:'landMark'
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('HOSTEL_CATEGORY'),
			store:hostelCategoryStore,
			displayField:'value',
			valueField:'id',			
			itemId:'hostelCategory',
			name:'hostelCategory',
			editable:false,
			width:226,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('RESOURCE_STATUS'),
			store:'facilitiesresources.resourcemaster.ResourceStatusStore',
			displayField:'name',
			valueField:'value',
			emptyText:getCommonTranslation('SELECT_RESOURCE_STATUS'),
			itemId:'formComboResourceStatusId',
			name:'status'
		},{
			xtype: 'livesearchcombo',
            name: 'concernedPerson',
            fieldLabel: getCommonTranslation('CONCERNED_PERSON'), //Concerned Person 
            itemId : 'concernedPerson',
            hidden:true,  //Only visible in case of 'External Resource'
            allowBlank:false,
            disabled:true,
			minChars:3,
			//forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength:45,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value} / {code}' +
					'</div>';
				}
			}
		
		}]
	},{
		xtype:'fieldcontainer',	
		defaults:{
			xtype:'textfield',
			labelAlign:'top',
			width:460			
		},
		layout:{
			type:'hbox'
		},
		items:[{
			xtype     : 'textareafield',
			grow      : true,
			name      : 'description',
			vtype: 'NospaceAsInput',
			fieldLabel: getCommonTranslation('DESCRIPTION')        
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('HOSTEL_TYPE'),
			store:Ext.create('Academia.store.hostel.managehostel.hostel.HostelTypeStore'),
			displayField:'value',
			valueField:'id',			
			itemId:'hostelType',
			name:'hostelType',
			width:226,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		}]
	},{
		xtype:'fieldcontainer',		
		defaults:{
			xtype:'textfield',
			labelAlign:'top',
			width:226
		},
		layout:{
			type:'hbox'
		},
		items:[ {
			xtype: 'checkboxfield',
			width: 'auto',
			labelAlign: 'right',
			boxLabel: getCommonTranslation('BOOKING_ALLOWED'),
			name: 'whetherBookingAllowed',
			checked : true,
			width:226,
			inputValue : true,
			uncheckedValue: false,	      
			itemId:'whetherBookingAllowed'
		},{
			xtype: 'checkboxfield',
			width: 'auto',
			label:'fgfgf',
			width:226,
			labelAlign: 'top',
			boxLabel: getCommonTranslation('RESOURCE_SHARING'),
			name: 'isSharingAllowed',
			inputValue : true,
			uncheckedValue: false,
			itemId:'isSharingAllowed',
		},{
			xtype:'customcombobox',
			fieldLabel:getCommonTranslation('CLUSTER_CODE'),
			store:Ext.create('Academia.store.hostel.managehostel.hostel.HostelClusterCodeStore'),
			displayField:'value',
			valueField:'id',			
			itemId:'clusterCode',
			name:'clusterCode',
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype:'button',
			hidden:true
		}]		
	}] 
});