/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.facultyCourseInterest.FacultyInterestReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.facultyinterestreportgrid',
	store : 'resourceutilization.FacultyInterestReportGridStore',
	title : getCommonTranslation('FACULTY_INTEREST_REPORT'),
	border: true,
	refreshStoreData:true,
	isGridConfigurable: true,
    enableColumnHide: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'resourceutilization.FacultyInterestReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	}, tbar: [{
		xtype: 'button',
		itemId: 'approveBtnId',
		tooltip: getCommonTranslation('APPROVE'),
		text: getCommonTranslation('APPROVE')
	},{
		xtype: 'button',
		itemId: 'declineBtnId',
		tooltip: getCommonTranslation('DECLINE'),
		text: getCommonTranslation('DECLINE')
	}],
	columns : [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyName',
        sortable:true,
        flex: .1
    },{
		header : getCommonTranslation('FACULTY_ID_OR_NAME'),
		dataIndex : 'value',
		flex : 1,
		sortable : true,
	},{
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'code',
        sortable:true,
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'secondValue',
        sortable: true,
        flex: 1
    },  {
        header: getCommonTranslation('COURSE_CESM_CODE'),
        dataIndex: 'sequenceNo',
        sortable:true,
        flex: 1,
    },{
        header: getCommonTranslation('COURSE_COMPONENT'),
        dataIndex: 'emailAddress',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('PROGRAM_CESM_CODE'),
        dataIndex: 'otherLanguage',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('INITIATOR'),
        dataIndex: 'firstName',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('INITIATOR_COMMENTS'),
        dataIndex: 'middleName',
        sortable:true,
        flex: 1,
        renderer: function(val, metaData) {
			if(!isNullOrEmpty(val)){
		    var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
		    metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

		    return '<div class="faculty-course-interest-comment-cell">' + encodedValue + '</div>';
			}
		}
    },{
        header: getCommonTranslation('DATE_REQUESTED'),
        dataIndex: 'date',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('HIGHTEST_QUALIFICATION'),
        dataIndex: 'highestQual',
        sortable:true,
        flex: 1,
        renderer:function(value,meta,record){
			return '<a href=#>'+getProgramandcourseTranslation('VIEW')+'</a>'
		}
    },{
        header: getCommonTranslation('APPROVAL_STATUS'),
        dataIndex: 'cityName',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('APPROVER_NAME'),
        dataIndex: 'nationalId',
        sortable:true,
        flex: 1
    },{
        header: getCommonTranslation('APPROVER_COMMENT'),
        dataIndex: 'addressText',
        sortable:true,
        flex: 1,
        renderer: function(val, metaData) {
			if(!isNullOrEmpty(val)){
		    var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
		    metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

		    return '<div class="faculty-course-interest-comment-cell">' + encodedValue + '</div>';
			}
		}
    },{
		header : getCommonTranslation('APPROVAL_DATE'),
		dataIndex : 'fromDate',
		flex : 1,
		sortable : true
	},{
        header: getCommonTranslation('ACTION_REASON'),
        dataIndex: 'pincode',
        sortable:true,
        flex: 1
    }]
});
