/*
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.facultyPortal.FacultyHomeworkAssignmentSearch' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.facultyhomeworkassignmentsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	items:[{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		style:{marginLeft:'10px'},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),	
			name : 'FACULTY_ACADEMIC_TERM',
			itemId : 'facultyacademicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			store: Ext.create('Academia.store.common.AcademicTermStore')
		},{
			xtype: 'customcombobox',
			name: 'faculty_course_name',
			itemId:'faculty_course_Id',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
			valueField:'courseId',
			displayField:'courseCodeName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			hideTrigger:false,
			minChars:3,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			queryParam:'name',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{courseCodeName}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultycourseVarient',
			itemId:'facultycourseVarient_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_COURSE_VARIANT'),
			store:Ext.create('Academia.store.course.coursevariants.ParameterCourseVariantStore'),
			displayField : 'courseVariantCode',
			valueField : 'id',
			disabled:true,
			forceSelection:true,
			typeAhead:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},

				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		style:{marginLeft:'10px'},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'facultyprogram',
			itemId : 'facultyprogramId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'valueCode',
			valueField : 'id',
//			queryMode : 'local',
			typeAhead : true,
			forceSelection:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			triggerAction: 'all',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'facultybatch',
			itemId : 'facultybatchId',
			fieldLabel: getCommonTranslation('BATCH'),
			store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			typeAhead : true,
			forceSelection : true
		},{
			xtype: 'customcombobox',
			name: 'facultyperiod',
			itemId : 'facultyperiodId',
			fieldLabel: getCommonTranslation('PERIOD'),
			store : Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'value',
			valueField : 'id',
			disabled : true,
			forceSelection : true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 226,
			style:{marginLeft:'10px'},
			labelAlign: 'top',
			name : 'facultysectionId',
			itemId : 'facultySection_ID',
			store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			disabled:true,
			forceSelection : true
		},{
			xtype: 'customcombobox',
			name:'facultystudentNameNew',
			itemId:'facultystudentNameNew_ID',
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			labelStyle: 'width: 250px;',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
		}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			style:{marginLeft:'10px'},
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'facultytopicTypeId',
				itemId:'facultytopicType_Id',
				fieldLabel: getCourseTxCommonTranslation('HW_TOPIC_TYPE'),
				store:'coursetransaction.coursereading.TopicType',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true
			},{
				xtype: 'customcombobox',
				name: 'facultytopicName',
				itemId:'facultytopicName_Id',
				fieldLabel: getCourseTxCommonTranslation('HW_TOPIC_NAME'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true
			}
			]},{
				xtype:'fieldset',
				title: getTransportTranslation('MORE_FILTERS'),
				layout:'vbox',
				frame:true,	
				collapsible:true,
				collapsed:true,
				style:{marginLeft:'15px'},
				style:{marginTop: '33px!important'},
				width:'100%',
				items: [{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						labelAlign:'top',
						width:223
					},
					items:[{
						xtype: 'customcombobox',
						name: 'facultyassignmentType',
						itemId:'facultyassignmentType_Id',
						fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_TYPE'),
						store:'coursetransaction.homework.HW_AssignmentTypeDropDown',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true
					},{
						xtype: 'customcombobox',
						name: 'facultyassignmentName',
						itemId:'facultyassignment_ItemId',
						fieldLabel: getCourseTxCommonTranslation('HW_ASSIGNMENT_NAME'),
						store:'coursetransaction.homework.AssignmentNameDropDown',
						displayField:'value',
						valueField:'id',
						forceSelection:true,
						typeAhead:true,
						queryParam:'searchName',
						minChars:3,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerAction: '',
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{code} / {value}' +
								'</div>';
							}
						}
					},{
						xtype:'combo',
						name: 'facultyassessmentType',
						itemId:'facultyassessmentTypeItemId_topicWise',
						fieldLabel : getExaminationTranslation('EVALUATION_TYPE'),
						valueField: 'id',
						displayField: 'id',
						typeAhead:true,
						forceSelection:true,
						queryMode:'local',
						store:['All','Random Code Assessment','Regular Assessment']
					}]
				},{
					xtype: 'fieldcontainer',
					width:'100%',
					layout: {
						type: 'hbox'
					},
					defaults :{
						labelAlign:'top',
						width:223
					},
					items:[  {
						xtype: 'datefield',
						name: 'facultyfromDate',
						itemId:'facultyfromDate',
						fieldLabel: getCourseTxCommonTranslation('HW_FROM_DATE'),
						endDateField : 'toDate',
						vtype : 'daterange',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}

					},{
						xtype: 'datefield',
						name: 'facultytoDate',
						itemId:'facultytoDate',
						fieldLabel: getCourseTxCommonTranslation('HW_TO_DATE'),
						startDateField : 'fromDate',
						vtype : 'daterange',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					}]
				}],
				listeners:{
					render: function(myfieldset){
						myfieldset.setMargin('-10px');
					}
				}
			},{
				xtype:'fieldcontainer',
				width: '100%',
				style:{
					marginLeft:'10px',
				},
				items:[{  
					xtype: 'button',
					itemId: 'searchBtn',
					text: getCommonTranslation('SEARCH'),
					ui:'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
});
