/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.MultipleSessionwiseCaptureAttendanceSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.multiplesessionwisecaptureattendancesearch',
	plugins : "formlabelrequired",
	frame: false,
	border:false,
	autoScroll:false,
	method : 'POST',
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'programId',
			itemId : 'session_programBatch_programId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width:460,
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				width : 226,
				fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				name:'newSessionNo',
				itemId: 'newSessionItemId',
				displayField: 'val',
				valueField: 'code',
				allowBlank:false,
				forceSelection:true,
				queryMode:'local'
			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('DATE'),
				name : 'dateOfAttendance',
				itemId:'session_dateOfAttendance_Id',
//				value: new Date(),
				maxValue : new Date(),
				vtype : 'daterange',
				allowBlank: false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				formBind : true,
				disabled:true,
				scale: CONSTANTS.BUTTONSIZE
			},
			{
					xtype: 'button',
					name:'GenrateQR',
				  text:getCommonTranslation('GENERATE_QR'),
					itemId: 'GENRATEQR',
					ui: 'CustomBtnSubmit',
					disabled:true,
					formBind : true,
					scale: CONSTANTS.BUTTONSIZE,
					
					 
				},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
