/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.facultyPortal.attendance.ProgramwiseCaptureAttendanceSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programwisecaptureattendancesearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items: [{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_PERIOD_SECTION'),
			name : 'facultyAttendanceProgram',
			itemId : 'facultyAttendanceProgramId',
			store:Ext.create('Academia.store.attendance.facultyportal.AttendanceProgramStore'),
			displayField:'value',
			valueField:'sectionId',
			width:460,
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('DATE'),
				name : 'completeDayDate',
				itemId:'completeDayDate_Id',
				maxValue : new Date(),
				vtype : 'daterange',
				allowBlank: false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout : 'hbox',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',	
				ui: 'CustomBtnSubmit',
				formBind : true,
				scale: CONSTANTS.BUTTONSIZE
			},
			{
					xtype: 'button',
					name:'GenrateQR',
				  text:getCommonTranslation('GENERATE_QR'),
					itemId: 'GENRATEQR',
					ui: 'CustomBtnSubmit',
					disabled:true,
					formBind : true,
					scale: CONSTANTS.BUTTONSIZE,
					
					 
				}
			,
			{
				xtype: 'button',
				text: getCourseTxCommonTranslation('RESET'),
				itemId: 'resetBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});
