var assignTopicStore = Ext.create('Academia.store.course.coursetopic.CourseTopicStore');
Ext.define('Academia.view.facultyPortal.detailScheduleFaculty.AssignTopicGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.assigntopicgrid',
	store: assignTopicStore,
	title: getProgramandcourseTranslation('ASSIGN_TOPIC'),
	border: true,
	autoScroll:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : assignTopicStore,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'topicSaveButton',
		text: getCommonTranslation('SAVE'),
		disabled:true
	}],
	columns: [{
		header:getCommonTranslation('TOPIC_SEQUENCE'),
		dataIndex: 'topicSequence',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('TOPIC_NAME'),
		dataIndex: 'topicName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('TOPIC_DESCRIPTION'),
		dataIndex: 'topicDescription',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: horizontal;line-height: 15px;max-height: 40px;min-width: 30ch;max-width: 103ch;';
	    		return val;
    		}
		}
	}]
});
