Ext.define('Academia.view.facultyPortal.detailScheduleFaculty.StudentCourseTopicCovered', {
	extend: 'Ext.window.Window',
	alias : 'widget.studentcoursetopiccovered',
	title: getProgramandcourseTranslation('TOPIC_DETAILS'),
	autoScroll: true,
	frame: true,
	autoScroll:true,
	modal:true,
	height: '50%',
	width: '70%',
	items: [{
	    xtype: 'grid',
	    itemId: 'assignedTopicDetailGrid',
	    border:true,
	    viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
	    store : 'course.coursetopic.AssignTopicDetailGridStore',
		columns : [{
			header:getCommonTranslation('TOPIC_SEQUENCE'),
			dataIndex: 'topicSequence',
			flex:.1,
			sortable:true
		},{
			header:getCommonTranslation('TOPIC_NAME'),
			dataIndex: 'topicName',
			flex:.1,
			sortable:true
		},{
			header:getCommonTranslation('TOPIC_DESCRIPTION'),
			dataIndex: 'topicDescription',
			flex:.1,
			sortable:true,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(isNullOrEmpty(val)){
		    		return "";
		    	} else {
		    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
		    		return val;
	    		}
			}
		},{
			header:getCommonTranslation('NO_OF_SESSION'),
			dataIndex: 'noOfSessions',
			flex:.1,
			sortable:true
		},{
			header:getCommonTranslation('TOPIC_MINUTES'),
			dataIndex: 'topicMinutes',
			flex:.1,
			sortable:true
		}],
		dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	        	xtype: 'custompagingtoolbar',
		        plugins:['pagesize'],
	        	displayInfo : true,		 
	        	emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				store : 'course.coursetopic.AssignTopicDetailGridStore'
	        }]
	    }]
	}]
});