/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.FDAddItemEntryForm',{
	extend:'Academia.view.common.IdGeneratorForm',
	formCode : 'fdadditementryform',
	alias: 'widget.fdadditementryform',
	title:getServiceRequestTranslation('FD_ADD_ITEM_ENTRY'),
	frame:true,
	plugins: "formlabelrequired",
	border: false,
	autoScroll: false,
	itemId:'fdadditementryformItemId',
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		},{
            xtype: 'hidden',
            itemId: 'statusItemId',
            name: 'status'
        }, {
			xtype: 'customcombobox',
			name:'entryType',
			itemId:'entryTypeItemId',
			store:'fdmanagement.EntryTypeStore',
			fieldLabel: getServiceRequestTranslation('FD_ENTRY_TYPE'),
			valueField: 'value',
			displayField: 'name',
			typeAhead:false,
			allowBlank:false,
			value:'Inward',
            forceSelection: true,
            editable: false,
            maxLength: 40
		},{
			xtype: 'customcombobox',
			name:'itemCategoryCode',
			itemId:'itemCategoryItemId',
			store:'course.readingmaterial.ReadingTypeStore',
			fieldLabel: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			allowBlank:false,
            forceSelection: true,
            editable: false,
            maxLength: 100
		},{
            xtype: 'fdinwardform',
            itemId: 'fdinwardformItemId',
            style: {
                marginLeft: '-2px',
                marginBottom: '-10px'
            },
		},{
			xtype: 'textfield',
			name:'outwardNo',
			itemId:'outwardNoItemId',
			fieldLabel: getServiceRequestTranslation('FD_OUTWARD_NO'),
			allowBlank:false,
			hidden:true,
            maxLength: 250,
			emptyText: getCommonTranslation('ID_AUTOGENERATE')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
        itemId: 'secondHboxItemId',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'textfield',
			name:'nameOfSenderId',
			itemId:'nameOfSenderItemId',
            allowBlank: false,
            /*validateOnBlur:true,*/
            //vtype:'NoSpaceAndSpecialCharactersAsInput',
            maxLength: 50,
            fieldLabel: getServiceRequestTranslation('FD_SENDER_NAME'),
		},{
			xtype: 'customcombobox',
			name: 'outwardSenderId',
			itemId:'outwardSenderIdItemId',
            fieldLabel: getServiceRequestTranslation('FD_SENDER_NAME'),
            //store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
            store: 'user.UserByALAndGroupId',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			hidden:true,
            maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'fieldcontainer',
			fieldLabel: getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
			name:'senderContactNoLabelId',
			itemId:'senderContactNoLabelItemId',
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'senderMobileCountryCode',
				itemId : 'senderMobileCountryCodeItemId',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:Ext.create('Academia.store.common.CountryStore'),
				triggerAction : 'all',
				//editable : false,
				forceSelection:true,
				width:  70,
				minChars: 1
			}, {
				xtype : 'numberfield',
				name : 'senderContactNo',
				itemId : 'senderContactNoItemId',
				minLength: 0,
                maxLength: 11,
				enforceMaxLength : true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				width : 146
			}]

		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'receiverNameId',
			itemId:'receiverNameItemId',
			fieldLabel: getServiceRequestTranslation('FD_RECEIVER_NAME'),
            //store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			store: 'user.UserByALAndGroupId',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
            maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'textfield',
			name:'deliverTo',
			itemId:'deliverToItemId',
			hidden:true,
            maxLength: 50,
            //vtype:'NoSpaceAndSpecialCharactersAsInput',
            allowBlank: false,
			fieldLabel: getServiceRequestTranslation('FD_DELIVER_TO'),
		},{
			xtype: 'fieldcontainer',
			fieldLabel: getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
			name:'receiverContactNoLabelId',
			itemId:'receiverContactNoLabelItemId',
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'receiverMobileCountryCode',
				itemId : 'receiverMobileCountryCodeItemId',
				valueField : 'isdCode',
				displayField : 'isdCode',
				store:Ext.create('Academia.store.common.CountryStore'),
				triggerAction : 'all',
			//	editable : false,
				forceSelection:true,
				width:  70,
				minChars: 1
			}, {
				xtype : 'numberfield',
				name : 'receiverContactNo',
				itemId : 'receiverContactNoItemId',
				minLength: 6,
                maxLength: 10,
				enforceMaxLength : true,
				hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				allowExponential:false,
				width : 146
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'textarea',
			name: 'deliveryAddress',
			itemId: 'deliveryAddressItemId',
			fieldLabel: getServiceRequestTranslation('FD_DELIVERY_ADDRESS'),
			width: 460,
			enforceMaxLength : true,
			hidden:true,
			maxLength:250
		}]

	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'inwardEntryById',
			itemId:'inwardEntryByItemId',
			fieldLabel: getServiceRequestTranslation('FD_INWARD_ENTRY_BY'),
            store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
            maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'outwardEntryById',
			itemId:'outwardEntryByItemId',
            fieldLabel: getServiceRequestTranslation('FD_OUTWARD_ENTRY_BY'),
            store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			allowBlank:false,
			forceSelection:true,
			hidden:true,
            maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'serviceProviderCode',
			itemId:'serviceProviderItemId',
			store:'coursetransaction.studymaterialdistributionnew.ServiceProviderSmdStr',
			fieldLabel: getServiceRequestTranslation('FD_SERVICE_PROVIDER'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
            forceSelection: true,
            editable: false,
            allowBlank: true,
            maxLength: 100
		},{
            /*xtype: 'numberfield',
			name:'noOfPieces',
			itemId:'noOfPiecesItemId',
			readOnly:true,
			value:1,
            maxLength: 10,
            fieldLabel: getServiceRequestTranslation('FD_NO_OF_PIECES'),*/
            xtype: 'displayfield',
            name: 'noOfPieces',
            itemId: 'noOfPiecesItemId',
            value: 1,
            fieldLabel: getServiceRequestTranslation('FD_NO_OF_PIECES')
		}]
	},{
		xtype: 'fieldcontainer',
		itemId:'docketNoContainerItemId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			defaults: {
				labelAlign: 'top',
                width: 226
			},
			items: [{
				xtype:'hidden',
				name:'docketId'
			},{
				xtype: 'textfield',
				name:'internalPacketNo',
				itemId:'internalPacketNoItemId',
				hidden:true,
                maxLength: 30,
				fieldLabel: getServiceRequestTranslation('FD_INTERNAL_PACKET_NO'),
			},{
				xtype: 'textfield',
				name:'docketNo',
				itemId:'docketNoItemId',
                maxLength: 30,
				fieldLabel: getServiceRequestTranslation('FD_DOCKET_NO'),
			},{
				xtype: 'button',
				itemId: 'addFilterBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			}]
        }]
    }, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'datefield',
				name: 'dateOfDelivery',
				itemId: 'dateOfDeliveryItemId',
				fieldLabel: getServiceRequestTranslation('FD_RECEIVING_DATE'),
				allowBlank: false,
				vtype: 'daterange',
				//value: new Date(),
				maxValue: new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'datefield',
				name: 'sentDate',
				itemId: 'sentDateItemId',
				fieldLabel: getServiceRequestTranslation('FD_SENT_DATE'),
				allowBlank: false,
				vtype: 'daterange',
				//value: new Date(),
				maxValue: new Date(),
				hidden:true,
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'checkboxfield',
				name: 'billReceived',
				itemId:'billReceivedItemId',
				boxLabel: getServiceRequestTranslation('FD_BILL_RECEIVED'),
				width: 'auto',
				labelAlign: 'right',
				style: {
					marginTop: '25px',
					marginLeft: '10px'
				},
				inputValue : true,
				uncheckedValue: false 
			},{
				xtype: 'checkboxfield',
				name: 'itemInsured',
				itemId:'itemInsuredItemId',
				boxLabel: getServiceRequestTranslation('FD_ITEM_INSURED'),
				width: 'auto',
				labelAlign: 'right',
				style: {
					marginTop: '25px',
					marginLeft: '10px'
				},
				hidden:true,
				inputValue : true,
				uncheckedValue: false 
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				name:'billNo',
				itemId:'billNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_BILL_NO'),
            allowBlank: false,
            maxLength: 40,
				hidden:true
			},{
				xtype: 'numberfield',
				name:'billAmount',
				itemId:'billAmountItemId',
				fieldLabel: getServiceRequestTranslation('FD_BILL_AMOUNT'),
				allowBlank: false,
				maxLength: 15,
				minValue: 0,
				hidden:true
			},{
				xtype: 'customcombobox',
				name:'insuredById',
				itemId:'insuredByIdItemId',
            fieldLabel: getServiceRequestTranslation('FD_INSURED_BY'),
				store:'fdmanagement.InsuranceType',
				valueField: 'id',
				displayField: 'value',
            forceSelection: true,
            editable: false,
            allowBlank: false,
            maxLength: 200,
				hidden:true
			},{
				xtype: 'textfield',
				name:'policyNo',
				itemId:'policyNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_POLICY_NO'),
            allowBlank: false,
            maxLength: 30,
				hidden:true
			},{
				xtype: 'numberfield',
				name:'insuranceAmount',
				itemId:'insuranceAmountItemId',
				fieldLabel: getServiceRequestTranslation('FD_INSURANCE_AMOUNT'),
				allowBlank: false,
				maxLength: 15,
				minValue: 0,
				hidden:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textarea',
				name: 'remarks',
				itemId: 'remarksItemId',
				fieldLabel: getServiceRequestTranslation('FD_REMARKS'),
				width: 460,
				enforceMaxLength : true,
				maxLength:250
			}]

		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getServiceRequestTranslation('FD_UPLOAD_DOCUMENT')+'</b>',
				style: {
					textDecoration: "underline"
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'fditementrydocumentgrid',
				itemId : 'fditementrydocumentgridItemId',
				style:{
					marginLeft:'0px'
				}
			},{
				xtype:'fdoutwarditementrydocumentgrid',
				itemId : 'fdoutwarditementrydocumentgridItemId',
				hidden: true,
				style:{
					marginLeft:'0px'
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SAVE'),
				itemId : 'saveFdadditementryformItemId',
				formBind : true,
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetFdadditementryformItemId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text:getCommonTranslation('UPLOAD_DOC'),
				itemId: 'itementryDocumentUploadId',
				ui: 'CustomBtnThird',
				scale : CONSTANTS.BUTTONSIZE
			}]
		}]
});
