/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.fdmanagement.FDManagementOutwardGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.fdmanagementoutwardgrid',
    store: 'fdmanagement.FDManagementOutwardStore',
    title: getServiceRequestTranslation('FD_OUTWARD_REGISTER'),
    border: true,
	cls: 'gridColumnCls',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'fdmanagementtabstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'fdmanagement.FDManagementOutwardStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation("ADD"),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation("EDIT"),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation("VIEW"),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation("DELETE"),
        glyph: ICONGLYPH.DELETEGLYPH
    }, {
        xtype: 'splitbutton',
        itemId: 'spBtnMoreActions',
        text: getFeeAndPaymentCommonTranslation('MOREACTIONS'),
        menu: [{
            text: getServiceRequestTranslation('FD_UPDATE_STATUS'),
            itemId: 'btnUpdateStatusItemId',
        }],
        listeners: {
            click: function() {
                this.showMenu();
            }
        }
    }],
    columns: [{
        header: getServiceRequestTranslation('FD_ENTRY_TYPE'),
		tooltip: getServiceRequestTranslation('FD_ENTRY_TYPE'),
        dataIndex: 'entryType',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
		tooltip:getServiceRequestTranslation('FD_ITEM_CATEGORY'),
        dataIndex: 'itemCategory',
        flex: 1,
		sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getServiceRequestTranslation('FD_OUTWARD_NO'),
		tooltip:getServiceRequestTranslation('FD_OUTWARD_NO'),
        dataIndex: 'outwardNo',
        flex: 1,
		sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_SENDER'),
        tooltip:getServiceRequestTranslation('FD_SENDER'),
		dataIndex: 'sentBy',
        flex: 1,
		sortable: true,
        renderer: function(value, meta, record) {
            return value.value;
        }
    }, {
        header: getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
        tooltip:getServiceRequestTranslation('FD_SENDER_CONTACT_NO'),
		dataIndex: 'senderContactNo',
        flex: 1,
		sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_DELIVER_TO'),
		tooltip:getServiceRequestTranslation('FD_DELIVER_TO'),
        dataIndex: 'deliverTo',
        flex: 1,
		sortable: true
    }, {
        header: getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
		tooltip:getServiceRequestTranslation('FD_RECEIVER_CONTACT_NO'),
        dataIndex: 'receiverContactNo',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_DELIVERY_ADDRESS'),
		tooltip:getServiceRequestTranslation('FD_DELIVERY_ADDRESS'),
        dataIndex: 'studentAddress',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('FD_INTERNAL_PACKET_AND_DOCKET_NO'),
        tooltip:getServiceRequestTranslation('FD_INTERNAL_PACKET_AND_DOCKET_NO'),
		dataIndex: 'fdOutwardItemDetails',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }, {
        header: getServiceRequestTranslation('FD_SENT_DATE'),
		tooltip:getServiceRequestTranslation('FD_SENT_DATE'),
        dataIndex: 'sentDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('FD_INSURANCE_DETAILS'),
		tooltip:getServiceRequestTranslation('FD_INSURANCE_DETAILS'),
        dataIndex: 'isItemInsured',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value) && value)
                return "<a href='#'>View</a>";
            else
                return '-';
        }
    }, {
        header: getServiceRequestTranslation('FD_DELIVERY_STATUS'),
		tooltip:getServiceRequestTranslation('FD_DELIVERY_STATUS'),
        dataIndex: 'packetStatus',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value == 'Delivered' || value == 'Returned') {
                    return "<a href='#'>" + value + "</a>";
                }
            }
            return value;
        }
    }, {
        header: getServiceRequestTranslation('FD_DELIVERY_DATE'),
		tooltip:getServiceRequestTranslation('FD_DELIVERY_DATE'),
        dataIndex: 'deliveredDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        },
    }, {
        header: getServiceRequestTranslation('FD_RETURN_DATE'),
		tooltip:getServiceRequestTranslation('FD_RETURN_DATE'),
        dataIndex: 'returnedDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        },
        hidden: true
    }, {
        header: getServiceRequestTranslation('FD_ATTACHMENTS'),
		tooltip:getServiceRequestTranslation('FD_ATTACHMENTS'),
        dataIndex: 'documents',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value.length > 0) {
                    return "<a href='#'>" + value.length + "</a>";
                }
            }
            return '0';
        }
    }]
});