/**
 * @author Priyanshi Sharma
 */

Ext.define('Academia.view.fdmanagement.ImportFDInwardOutwardUploadForm',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.importfdinwardoutwarduploadform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
//	cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	//plugins : "formlabelrequired",
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
		margin: 0,
		itemId:'FDInwardOutwardRadioGroupItemId',
	},{
		xtype:'fieldcontainer',
		width:'auto',
		layout : 'hbox',
		items: [{
			xtype: 'customcombobox',
			name:'fdUploadTemplateFor',
			itemId:'fdUploadTemplateFor',
			labelAlign: 'top',
			store:'fdmanagement.FDTemplateForStore',
			fieldLabel : getCommonTranslation('TEMPLATE_FOR'),	
			valueField: 'value',
			displayField: 'name',
			value:'Inward',
			editable: false,
			maxLength: 40,
			width: 230
		},{
			xtype: 'customcombobox',
			name: 'importUtilityMasterId',
			itemId:'moduleName',
			labelAlign: 'top',
			store:'importutility.ModuleName',
			fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			readOnly:true,
			hidden:true,
			width: 300,
		}]
	},{ 	
		xtype:'fieldcontainer',
		items: [{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 460,
			labelAlign: 'top',
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadFileField',
			name : 'file',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
	                    if (!baseController.isValidFileExtensionForLoader(extension)) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
	                    }
	                }
	            }
	        }
		}]},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});








