/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.fdmanagement.facultyPortal.FDMEFilter',{
	extend : 'Ext.form.Panel',
	alias : 'widget.fdmefilter',
	autoScroll : true,
	frame : false,
	cls : 'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [{
		xtype: 'fieldcontainer',        
		width: 236,
        itemId: 'fdmefilterManuallyId',
		items:[{
			xtype: 'radiogroup',
            style: {
                marginLeft: '-2px !important'
            },
			itemId:'itemEntryTypeItemId',
			labelAlign: 'top',
			columns: 2,
			vertical: true,
			items: [{ 
                boxLabel: getServiceRequestTranslation('FD_SENT'),
                name: 'itemEntryType',
                inputValue: getServiceRequestTranslation('FD_SENT')
			},{
                boxLabel: getServiceRequestTranslation('FD_RECEIVED'),
                name: 'itemEntryType',
                inputValue: getServiceRequestTranslation('FD_RECEIVED'),
                checked: true
			}]
		},]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'itemCategoryCode',
			itemId:'itemCategoryItemId',
			store:'course.readingmaterial.ReadingTypeStore',
			fieldLabel: getServiceRequestTranslation('FD_ITEM_CATEGORY'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
            forceSelection: true,
            editable: false,
            maxLength: 100
		},{
            xtype: 'customcombobox',
			name:'inwardNo',
			itemId:'inwardNoItemId',
			fieldLabel: getServiceRequestTranslation('FD_INWARD_NO'),
            store: 'fdmanagement.FDItemSmartSearchByInwardNoStore',
            valueField: 'value',
            displayField: 'value',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            maxLength: 30,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
		},{
            xtype: 'customcombobox',
			name:'outwardNo',
			itemId:'outwardNoItemId',
			fieldLabel: getServiceRequestTranslation('FD_OUTWARD_NO'),
            store: 'fdmanagement.FDOutwardItemSmartSearchByOutwardNoStore',
            valueField: 'value',
            displayField: 'value',
            queryParam: 'name',
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            hideTrigger: false,
            hidden: true,
            maxLength: 30,
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
        title: getServiceRequestTranslation('MORE_FILTERS'),
		titleCollapse: true,
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name:'serviceProviderCode',
				itemId:'serviceProviderItemId',
				store:'coursetransaction.studymaterialdistributionnew.ServiceProviderSmdStr',
				fieldLabel: getServiceRequestTranslation('FD_SERVICE_PROVIDER'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:false,
                forceSelection: true,
                editable: false,
                maxLength: 40
			},{
                xtype: 'customcombobox',
				name:'docketNo',
				itemId:'docketNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_DOCKET_NO'),
                store: 'fdmanagement.FDItemSmartSearchByDocketNoStore',
                valueField: 'value',
                displayField: 'value',
                queryParam: 'name',
                triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                enableKeyEvents: 'true',
                minChars: 3,
                typeAhead: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
                hideTrigger: false,
                maxLength: 30,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'docketNoOutward',
                itemId: 'docketNoOutwardItemId',
                fieldLabel: getServiceRequestTranslation('FD_DOCKET_NO'),
                store: 'fdmanagement.FDOutwardItemSmartSearchByDocketNoStore',
                valueField: 'value',
                displayField: 'value',
                queryParam: 'name',
                triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                enableKeyEvents: 'true',
                minChars: 3,
                typeAhead: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
                hideTrigger: false,
                maxLength: 30,
                hidden: true,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
			}]
		},{
			xtype : 'fieldcontainer',
			width: '100%',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'inwardEntryById',
				itemId:'inwardEntryByItemId',
				fieldLabel: getServiceRequestTranslation('FD_INWARD_ENTRY_BY'),
                store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
                maxLength: 100,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
                xtype: 'customcombobox',
				name:'billNo',
				itemId:'billNoItemId',
				fieldLabel: getServiceRequestTranslation('FD_BILL_NO'),
                store: 'fdmanagement.FDItemSmartSearchByBillNoStore',
                valueField: 'value',
                displayField: 'value',
                queryParam: 'name',
                triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                enableKeyEvents: 'true',
                minChars: 3,
                typeAhead: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
                hideTrigger: false,
                maxLength: 40,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
			},{
                xtype: 'customcombobox',
				name:'internalPacketNo',
				itemId:'internalPacketNoItemId',
                fieldLabel: getServiceRequestTranslation('FD_INTERNAL_PACKET_NO'),
                store: 'fdmanagement.FDOutwardItemSmartSearchByInternalPacketNoStore',
                valueField: 'value',
                displayField: 'value',
                queryParam: 'name',
                triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                enableKeyEvents: 'true',
                minChars: 3,
                typeAhead: false,
                forceSelection: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                triggerAction: '',
                hideTrigger: false,
                maxLength: 30,
				hidden:true,
                listConfig: {
                    listeners: {
                        beforeshow: function(picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
			},{
				xtype: 'customcombobox',
				name: 'outwardEntryById',
				itemId:'outwardEntryByItemId',
				fieldLabel: getServiceRequestTranslation('FD_OUTWARD_ENTRY_BY'),
                store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				hidden:true,
                maxLength: 100,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getServiceRequestTranslation('FD_RECEIVING_DATE')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{ 
				xtype : 'fieldcontainer',
				width: '100%',
				layout:'hbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'datefield',
					name: 'fromDate',
					itemId: 'fromDateItemId',
					vtype: 'daterange',
					endDateField: 'toDateItemId',
					fieldLabel: getServiceRequestTranslation('FD_FROM_DATE'),
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				},{
					xtype: 'datefield',
					name: 'toDate',
					itemId: 'toDateItemId',
					vtype: 'daterange',
					startDateField: 'fromDateItemId',
					fieldLabel: getServiceRequestTranslation('FD_TO_DATE'),
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					}
				}]
            }]
        }]
    }, {
		xtype : 'fieldcontainer',
		width : 'auto',
		items : [ {
			xtype : 'button',
            text: getCommonTranslation('SEARCH'),
			itemId : 'searchBtnFdmefilterItemId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'resetBtnFdmefilterItemId',
            text: getCommonTranslation('RESET'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
});
