/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.feeandpayment.ConfigureFeeHeadsList', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.configurefeeheadslist',
	store : 'feeandpayment.ConfigureFeeHeadList',
	border: true,
	cls:'enqgridsummarycls managePaymentCls',
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    features: [{
        id: 'group',
        ftype: 'groupingsummary',
        groupHeaderTpl: '{name}',
        hideGroupedHeader: false,
        enableGroupingMenu: false,
        showSummaryRow : false
    },{
        ftype: 'summary',
        dock: 'bottom'
    }],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'configurefeeheadsequenceLink',
		text: getFeeAndPaymentCommonTranslation('SAVE_PRIORITY'),
		tooltip: getFeeAndPaymentCommonTranslation('SAVE_PRIORITY')
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getFeeAndPaymentCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT'),
			itemId:'manageDiscountLink'
		},{
			text:getFeeAndPaymentCommonTranslation('MANAGE_BILLING_SCHEDULE'),
			itemId:'schedulePaymentLink'
		},{
			text:getFeeAndPaymentCommonTranslation('MANAGE_DEPENDEND_FEE_HEADS'),
			itemId:'manageDependendFeeHeadsLink'
		}
		,{
			text:getFeeAndPaymentCommonTranslation('MANAGE_FINE_SCHEDULE'),
			itemId:'manageFineSchedule'
		}],
		 listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		text: getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'),
		dataIndex: 'fee_HEAD_NAME',
		flex: 1,
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
        summaryRenderer: function(value, summaryData, data) {
        	var text = "Total";
        	if(data.internalId.indexOf('summary') > 0){
        		text = "Total";
        		return text;
        	}
        }
	}, {
		text: getFeeAndPaymentCommonTranslation('FEE_AMOUNT'),
		dataIndex: 'fee_AMOUNT',
		sortable: true,
		flex: 1,
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(record.get("currencyId")))	
				return currencyRenderer(value,record.get("currencyId"));
		},
	//	align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryType: 'sum',
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			var decimalPointTwo = Ext.util.Format.numberRenderer('0.00')
            return  decimalPointTwo(value);
            //above two line ==>V2D-276897 
		}
	}, {
		text: getFeeAndPaymentCommonTranslation('PAYMENT_PERIOD'),
		dataIndex: 'payment_PERIOD',
		sortable: true,
		flex: 1,
		renderer:function(value){
			if(value == 'SESSIONS'){
				return getCommonTranslation('SESSIONS');
			}
			else if(value == 'PARTICIPANT'){
				return getCommonTranslation('PARTICIPANT');
			}
			else if(value == 'ADHOC_PERIODS'){
				return getCommonTranslation('ADHOC_PERIODS');
			}
			else if(value == 'FIXED_TIME_PERIODS'){
				return getCommonTranslation('FIXED_TIME_PERIODS');
			}
			else if(value == 'PROGRAM_PERIOD'){
				return getCommonTranslation('PROGRAM_PERIOD');
			}
			else if(value == 'ONE_TIME'){
				return getCommonTranslation('ONE_TIME');
			}else if(value == 'INSTALLMENTS'){
				return getCommonTranslation('INSTALLMENTS');
			}
		}
	}, {
		text: getFeeAndPaymentCommonTranslation('NO_OF_FEE_PAYMENT'),
		dataIndex: 'no_OF_FEE_PAYMENT',
		sortable: true,
		flex: 1
	},{
		text: getFeeAndPaymentCommonTranslation('PDC_ALLOWED'),
		dataIndex: 'whether_INSTALL_POST_DATED',
		sortable: true,
		hidden:true,
		flex: 1,
		//disabled:true,
		renderer:function(value){
			if(value){
				return getFeeAndPaymentCommonTranslation('YES');
			}else{
				return getFeeAndPaymentCommonTranslation('NO');
			}
		}
	},{
		text: getFeeAndPaymentCommonTranslation('WHETHER_DISCOUNT_APPLICABLE'),
		dataIndex: 'discount_TYPE',
		sortable: true,
		flex: 1,
		renderer:function(value){
			if(value == getFeeAndPaymentCommonTranslation('PERCENTAGE')){
				return getCommonTranslation('PERCENTAGE');
			}
			else if(value == getFeeAndPaymentCommonTranslation('FIXED_AMOUNT')){
				return getCommonTranslation('FIXED_AMOUNT');
			}
			else if(value == getFeeAndPaymentCommonTranslation('ADHOC')){
				return getCommonTranslation('ADHOC');
			}
		}
	},{
		xtype:'actioncolumn',
		text : getFeeAndPaymentCommonTranslation('SETTLEMENT_PRIORITY'),
		flex: 1,
		menuText: getFeeAndPaymentCommonTranslation('SETTLEMENT_PRIORITY'),
		items: [{
			xtype: 'button',
			itemId: 'upButton',
			iconCls: Ext.baseCSSPrefix + 'form-itemselector-up',  // Use a URL in the icon config
			tooltip: 'UP',
			handler: function(grid, rowIndex, colIndex) {
				if(rowIndex != 0) {
					var record = grid.getStore().getAt(rowIndex);
					var recordFeeHeadSequenceName = record.data.groupingFeeHeadSequenceName;
	            	var previousRecord = grid.getStore().getAt(rowIndex-1);
	            	var previousRecordFeeHeadSequenceName = previousRecord.data.groupingFeeHeadSequenceName;
	            	var rec =grid.getStore().data.items;
	            	var temp=0;
	            	if(recordFeeHeadSequenceName=='Fee Heads'){
	            		temp = record.data.feeHeadSequence;
	            		record.data.feeHeadSequence=previousRecord.data.feeHeadSequence;
	            		previousRecord.data.feeHeadSequence = temp;

	            		temp = record.data.groupingFeeHeadSequence;
	            		record.data.groupingFeeHeadSequence=previousRecord.data.groupingFeeHeadSequence;
	            		previousRecord.data.groupingFeeHeadSequence = temp;

	            	}else{
	            		if(record.data.groupingFeeHeadSequence!=previousRecord.data.groupingFeeHeadSequence)
	            		{
	            			for(var i in rec)
	            			{
	            				var groupingFeeHeadSequenceName = rec[i].data.groupingFeeHeadSequenceName;
	            				if(previousRecordFeeHeadSequenceName==groupingFeeHeadSequenceName)
	            				{
	            					rec[i].data.groupingFeeHeadSequence=rec[i].get('groupingFeeHeadSequence')+1;
	            					rec[i].data.groupingFeeHeadSequenceName=rec[i].data.groupingFeeHeadSequence+". "+(rec[i].data.groupingFeeHeadName!=null?rec[i].data.groupingFeeHeadName:"");
	            					rec[i].data.feeHeadSequence=rec[i].data.feeHeadSequence+1;
	            				}
	            				if(recordFeeHeadSequenceName==groupingFeeHeadSequenceName)
	            				{
	            					rec[i].data.groupingFeeHeadSequence=rec[i].get('groupingFeeHeadSequence')-1;
	            					rec[i].data.groupingFeeHeadSequenceName=rec[i].data.groupingFeeHeadSequence+". "+(rec[i].data.groupingFeeHeadName!=null?rec[i].data.groupingFeeHeadName:"");
	            					rec[i].data.feeHeadSequence=rec[i].data.feeHeadSequence-1;
	            				}
	            			}
	            		}else if(previousRecord.data.groupingFeeHeadSequenceName==record.data.groupingFeeHeadSequenceName)
	            		{
	            			temp = record.data.feeHeadSequence;
	            			record.data.feeHeadSequence=previousRecord.data.feeHeadSequence;
	            			previousRecord.data.feeHeadSequence = temp;
	            		}
	            	}
	            	grid.getStore().sort();
	            	if(previousRecord.data.groupingFeeHeadSequenceName==record.data.groupingFeeHeadSequenceName)
	            	{
	            		grid.getStore().remove(record, true);
	                    grid.getStore().insert(rowIndex-1, record);
	                    grid.getStore().remove(previousRecord, true);
	                    grid.getStore().insert(rowIndex, previousRecord);
	            	}
				} else {
					showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('UPERRORMESSAGE'));
				}
			}
		},{
			xtype: 'button',
			itemId: 'downButton',
			iconCls: Ext.baseCSSPrefix + 'form-itemselector-down',
			tooltip: 'DOWN',
			handler: function(grid, rowIndex, colIndex) {
				lastRowIndex = grid.getStore().getCount()-1;
				if(rowIndex != lastRowIndex) {
					var record = grid.getStore().getAt(rowIndex);
					var recordFeeHeadSequenceName = record.data.groupingFeeHeadSequenceName;
	            	var nextRecord = grid.getStore().getAt(rowIndex+1);
	            	var nextRecordFeeHeadSequenceName = nextRecord.data.groupingFeeHeadSequenceName;
	            	var rec =grid.getStore().data.items;
	            	var temp=0;
	            	if(recordFeeHeadSequenceName=='Fee Heads'){
	            		temp = record.data.feeHeadSequence;
	            		record.data.feeHeadSequence=nextRecord.data.feeHeadSequence;
	            		nextRecord.data.feeHeadSequence=temp;

	            		temp = record.data.groupingFeeHeadSequence;
	            		record.data.groupingFeeHeadSequence=nextRecord.data.groupingFeeHeadSequence;
	            		nextRecord.data.groupingFeeHeadSequence=temp;

	            	}else{
	            		if(record.data.groupingFeeHeadSequence!=nextRecord.data.groupingFeeHeadSequence)
	            		{
	            			for(var i in rec)
	            			{
	            				var groupingFeeHeadSequenceName = rec[i].data.groupingFeeHeadSequenceName;
	            				if(nextRecordFeeHeadSequenceName==groupingFeeHeadSequenceName)
	            				{
	            					rec[i].data.groupingFeeHeadSequence=rec[i].get('groupingFeeHeadSequence')-1;
	            					rec[i].data.groupingFeeHeadSequenceName=rec[i].data.groupingFeeHeadSequence+". "+(rec[i].data.groupingFeeHeadName!=null?rec[i].data.groupingFeeHeadName:"");
	            					rec[i].data.feeHeadSequence=rec[i].data.feeHeadSequence-1;
	            				}
	            				if(recordFeeHeadSequenceName==groupingFeeHeadSequenceName)
	            				{
	            					rec[i].data.groupingFeeHeadSequence=rec[i].get('groupingFeeHeadSequence')+1;
	            					rec[i].data.groupingFeeHeadSequenceName=rec[i].data.groupingFeeHeadSequence+". "+(rec[i].data.groupingFeeHeadName!=null?rec[i].data.groupingFeeHeadName:"");
	            					rec[i].data.feeHeadSequence=rec[i].data.feeHeadSequence+1;
	            				}
	            			}
	            		}else if(nextRecord.data.groupingFeeHeadSequenceName==record.data.groupingFeeHeadSequenceName)
	            		{
	            			temp = record.data.feeHeadSequence;
	            			record.data.feeHeadSequence=nextRecord.data.feeHeadSequence;
	            			nextRecord.data.feeHeadSequence=temp;
	            		}
	            	}
	            	grid.getStore().sort();
	            	if(nextRecord.data.groupingFeeHeadSequenceName==record.data.groupingFeeHeadSequenceName)
	            	{
	            		grid.getStore().remove(record, true);
	                    grid.getStore().insert(rowIndex+1, record);
	                    grid.getStore().remove(nextRecord, true);
	                    grid.getStore().insert(rowIndex, nextRecord);
	            	}
				} else {
					showErrorMessage(getCommonTranslation('REORDER'), getErrorTranslation('DOWNERRORMESSAGE'));
				}
			}
		}],
		summaryRenderer: function(value, summaryData, data) {
			/*	var text = "Total";
	        	if(data.internalId.indexOf('summary') > 0){
	        		text = "Grand Total";
	        		return text;*/
			return value;
		}
	}]
});
