/**
 * @author Amit G
 */

Ext.define('Academia.view.feeandpayment.FnpPaymentPlanDocumentSubmittedWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.fnppaymentplandocumentsubmittedwin',
	title:getFeeAndPaymentCommonTranslation('DOCUMENT_TO_BE_SUBMITTED'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
	            xtype: 'nestedJsonCombo',
	            name: 'documentType',
	            fieldLabel: getFeeAndPaymentCommonTranslation('DOCUMENT_NAME'),
	            allowBlank: false,
	            //store: 'Academia.store.common.DocumentTypeStore',
	            store: Ext.create('Academia.store.common.DocumentTypeStore'),
	            displayField: 'value',
	            valueField: 'id',
	            width: 452,
	            editable: false,
	            itemId: 'documentTypeCombo'
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				name : 'applicability',
				fieldLabel : getAdmissionTranslation('APPLICABILITY'),
	            allowBlank: false,
	            store: 'feeandpayment.paymentPlanEnrollment.PaymentPlanDocumentStore',
	            displayField: 'value',
	            valueField: 'id',
	            editable: false,
	        },{
	            xtype: 'textfield',
	            name: 'remark',
	            id: 'remark',
	            fieldLabel: getCommonTranslation('REMARK')
	        }]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});