/**
 * @author Manisha Wagh
 * This component is used for document List Grid at student portal
 */
Ext.define('Academia.view.feeandpayment.FnpStudentPaymentPlanDocumentSubmittedGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.fnpstudentpaymentplandocumentsubmittedgrid',
    collapsible: true,
    title:getFeeAndPaymentCommonTranslation('DOCUMENTS_TO_BE_SUBMITTED'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        disabled:false,
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        disabled:false,
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }],
    columns: [{
		text : getAdmissionTranslation('DOCUMENT_NAME'),
		dataIndex: 'documentType.value',
		sortable : true,
		flex: .4,
		/*renderer: function(obj) {
			return columnObjRender(obj, 'value');
		}*/
		
		renderer:function(value){
//			return '<a href=#>'+value+'</a>'
			return value;
		}
	}, {
		text : getAdmissionTranslation('APPLICABILITY'),
		dataIndex : 'applicability',
		sortable : true,
		flex: .3,
		renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}
	},
	{

		text : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		sortable : true,
		flex: .3,
		/*renderer: function(obj) {
			return getAdmissionTranslation(obj);
		}*/
		renderer : function(value){
			if(value!=null && value=='SUBMITTED'){
				return getCommonTranslation('SUBMITTED');
			}else{
				return getCommonTranslation('PENDING');
			}
		}
	
	},{
        header: getFeeAndPaymentCommonTranslation('REMARK'),
        dataIndex: 'remark',
        //align: 'center',
        sortable: true,
        flex: .2,
		renderer:function(record, value, index){
			if(!isNullOrEmpty(index.data.remark)){
				return "<a href='#'>View</a>";	
			}else{
				return "";				
			}
		}
    },{
		text : getCommonTranslation('DOCUMENT_UPLOADED'),
		dataIndex: 'documentType.value',
		sortable : true,
		flex: .4,
		
		renderer:function(value, record, index){
			if(index.data.status=="SUBMITTED"){
				return '<a href=#>'+index.data.documentType.value+'</a>'
			}else{
				return "";				
			}
		}
	
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
      //  return Ext.create('Academia.store.feeandpayment.StudentDocumentToBeSubmittedStore');
    	   return Ext.create('Academia.store.feeandpayment.OtherDocumentToBeSubmittedGridStore');
    }
});