/**
 * @author p kumar
 */
Ext.define('Academia.view.feeandpayment.PaymentPlanMappingResultGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.paymentplanmappingresultgrid',
	store: 'feeandpayment.stoPaymentPlanMappingGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.stoPaymentPlanMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMY'),
		dataIndex: 'academy',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('LOCATION'),
		dataIndex: 'location',
		flex:1,
		sortable:true
		
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
        header: getCommonTranslation('DEFAULT_PAYMENT_PLAN'),
        dataIndex: 'whetherDefault',
        flex: 1,
        sortable: true,
        renderer: function(value) {
            if (!isNullOrEmpty(value) && value == true) {
                return 'Yes';
            }else{
            	return 'No';
            }
        }
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SEAT_TYPE'),
		dataIndex: 'seatTypeName',
		flex:1,
		sortable:true
	},{
		header:  getFeeAndPaymentCommonTranslation('APPROVAL_STATUS'),
		dataIndex: 'approvalStatus',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('MAPPING_STATUS'),
		dataIndex: 'mappingStatus',
		flex:1,
		sortable:true
	}]
});
