/**
 * @author Prakash Soni
 */

Ext.define('Academia.view.feeandpayment.StudentPaymentPlanDetailRecordPanel',{
	extend: 'Ext.form.FormPanel',
	customFieldEntity:CONSTANTS.FEE_PLAN_CUSTOM_FIELD,
	alias: 'widget.studentpaymentplandetailrecordpanel',
	itemId:'feeplanformid',
	frame: true,
	method: 'POST',
	standardSubmit: false,
//	collapsible: true,
	border: true,
	title:getFeeAndPaymentCommonTranslation('ENROLLED_PAYMENT_PLAN'),
	cls: 'scheduleInstallmentGridCls',
	autoScroll: true,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'hidden',
		name: 'planId',
		itemId:'planId'
	},{
		xtype: 'hidden',
		name: 'currencyId',
		itemId:'currencyId'
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 226,
			labelAlign: 'top',
			xtype: 'displayfield'
		},
		items:[{
			width: 456,
			xtype: 'text',
			itemId:'enrollmentMessage',
			name: 'enrollmentMessage',
			hidden:true,
			text: 'You have not been enrolled into any payment plan yet!'

		},{
			name: 'paymentPlanId',
			itemId:'paymentPlanItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_ID')
		},{
			name: 'noOfInstallments',
			itemId:'noOfInstallmentsItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('NO_OF_INSTALMENTS')
		},{
			name: 'paymentPlanName',
			itemId:'paymentPlanNameItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_NAME')
		},{
			xtype: 'button',
			text: getFeeAndPaymentCommonTranslation('UN_ENROLL'),
			ui: 'CustomBtnCancel',
			width:100,
			scale: CONSTANTS.BUTTONSIZE,
			itemId: 'UnenrollButton',
		},
		{
			xtype: 'displayfield',
			itemId:'unEnrollmentMessage',
			name: 'unEnrollmentMessage'
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			width: 226,
			labelAlign: 'top',
			xtype: 'displayfield'
		},
		items:[{
			name: 'currencyName',
			itemId:'currencyNameItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('CURRENCY')

		},{
			name: 'enrollmentChangeDate',
			itemId:'enrollmentChangeDateItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('ENROLLMENT_CHANGE_DATE'),
			hidden:true
		},{
			name: 'paymentPlanChangeDate',
			itemId:'paymentPlanChangeDateItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_PLAN_CHANGE_DATE')
		},{
			name: 'fineRule',
			itemId:'fineRuleItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('FINE_RULE')
		}]

	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		style: {'marginTop': '20px' },
		width: 'auto',
		defaults: {
			width: 226,
			xtype: 'displayfield'
		},
		itemId: 'approvalStatusItemIdContainer',
		hidden:true,
		items: [{
			xtype: 'displayfield',
			name:'approvalStatus',
			itemId: 'approvalStatusItemId',
			value:'Status: Waiting for Approval',
			style: {'border':'1px solid'},
			cls:'paymentPlanDisplayFieldCls'

		}]

	},
	{
		xtype:'fieldcontainer',
//		layout:'hbox',
		width: '100%',
		style:{ 'margin-top': '10px'},
		items:[
			{
				xtype:'panel',
//				layout:'hbox',
				width: '100%',
				style:{ 'margin-top': '10px', 'margin-left': '-10px'},
				items:[{
					xtype:'tabpanel',
					plain: true,
					itemId:'structureOneItemId',
					style:{ 'border-style': 'none'},
					frame: false,
					border:true,
					items:[{
						xtype : 'studentpaymentplaninstallmentdetailstructure1',  // alias name from scren
						title: getFeeAndPaymentCommonTranslation('INSTALLEMENT_DETAILS'),
						tabCls: 'right-tab',
						border:false,
					},{
						xtype : 'studentpaymentplandocstructure',  // alias name from scren
						title: getCommonTranslation('DOCUMENTS_DETAILS'),
						tabCls: 'right-tab',
						border:false,
					}]
				}
				]	
			},
			{	
				xtype: 'displayfield',
				name: 'enrollmentStatusMassage',
				itemId:'enrollmentStatusMassage',
				hidden: true
			}

			]
	}]
});
