/**
 *  @author swapnil.patil
 */


Ext.define('Academia.view.feeandpayment.ViewStudentActualAccountStatementGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.viewstudentactualaccountstatementgrid',
	store : 'feeandpayment.ViewActualAccountStatementGridStore',
	title: getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	tbar: ['->',{
		xtype: 'button',
		itemId: 'btnPrint',
		//icon: 'resources/images/print1.png',
		text:getCommonTranslation('EXPORTREPORTS')
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	columns: [{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_DATE'),
		dataIndex : 'transactionDate',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(store.data.items[0].data.whetherDisplayTotal != false) {
				return getFeeAndPaymentCommonTranslation('TOTAL');
			}
			//      return getFeeAndPaymentCommonTranslation('TOTAL');
		}
	},{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_NUMBER'),
		dataIndex : 'transactionNo',
		flex:1,
		renderer:function(value,rec){
			//var id=rec.record.data.id;
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('TRANSACTION_TYPE'),
		dataIndex : 'category',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}
		}
	},/*{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'code',
		flex:1
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex:1
	},*/{
		header : getFeeAndPaymentCommonTranslation('DESCRIPTION'),
		dataIndex : 'narration',
		flex:2
	},{
		header : getFeeAndPaymentCommonTranslation('DEBIT'),
		dataIndex : 'debitAmount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
				//return value;
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('CREDIT'),
		dataIndex : 'creditAmount',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
				//return value;
			} else {
				return "";
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('BALANCE'),
		dataIndex : 'balanceAmount',
		flex:1,
		summaryType: 'max',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				if(!isNullOrEmpty(record.data.debitCreditCode)){
					return currencyRenderer(value,record.get("currencyId"))+" "+record.data.debitCreditCode;
				} else {
					return currencyRenderer(value,record.get("currencyId"));
				}
			} else {
				return "";
			}
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && store.data.items[0].data.whetherDisplayTotal != false){

				var store = this.getStore();
				if(!isNullOrEmpty(store)){
					var arrStoreItems = store.data.items;
					var lastRecord = arrStoreItems[arrStoreItems.length-1];
					if(!isNullOrEmpty(lastRecord)){
						if(!isNullOrEmpty(lastRecord.data.debitCreditCode)){
							return currencyRenderer(lastRecord.get("balanceAmount"),lastRecord.get("currencyId"))+" "+lastRecord.data.debitCreditCode;
						} else {
							return currencyRenderer(lastRecord.get("balanceAmount"),lastRecord.get("currencyId"));
						}
					} else {
						return "";
					}
				}
			} else {
				return "";
			}
		}
	}]
});
