/**
 *  @author Ravi.patidar
 */

Ext.define('Academia.view.feeandpayment.adjustment.Allbillslist', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.allbillslist',
	title : getFeeAndPaymentCommonTranslation('BILL_RECEIVABLE_LABEL'),
	store: 'feeandpayment.adjustment.AllBillsList',
	isGridConfigurable: true,
	enableColumnHide: false,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: false,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var balanceAmount = record.get("amountToBeAdjusted");
			if (balanceAmount>0) {
				var baseCSSPrefix = Ext.baseCSSPrefix;
				metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
				return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
			} else {
				return '';
			} 
		}
	},
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		itemId: 'nextBtnAllBillBtn',
		disabled:true,
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		itemId: 'saveBtnAllBillBtn',
		text:getCommonTranslation('SAVE'),
		tooltip: getCommonTranslation('SAVE')
	}],
	columns: [{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'code',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'printName',
		flex : 1,
		hidden:true
	},{
		header : getCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1	 
	},{
		header : getCommonTranslation('BILL_DATE'),
		dataIndex : 'billingDate',
		flex : 1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('DUE_DATE'),
		dataIndex : 'dueDate',
		flex : 1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('BILL_TYPE'),
		dataIndex : 'billType',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                    
		} 
	},{
		header : getCommonTranslation('STUDENT_BILLABLE_AMOUNT'),
		dataIndex : 'billableAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('ALREADY_ADJUSTED_AMOUNT'),
		dataIndex : 'adjustedAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex : 'balanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE'),
		dataIndex : 'currencyExchangeRate',
		flex : 1
	},{
		header : getCommonTranslation('CONVERTED_BALANCE_AMOUNT'),
		dataIndex : 'convertedBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}                    
		}
	},{
		header : getCommonTranslation('AMOUNT_TO_BE_ADJUSTED'),
		dataIndex : 'amountToBeAdjusted',
		flex : 1,
		editing:true,
		itemId : 'amountToBeAdjusted',
		editor : {
			xtype:'numberfield',
			name: 'amountToBeAdjusted',
			itemId:'amountToBeAdjusted',
			mouseWheelEnabled:false,
			allowDecimals:true,
			enableKeyEvents:true,
			hideTrigger:true,
			minValue:0
		},    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return value;
			} else {
				meta.tdCls = 'gridInputCustomStyle'; 
				return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
			}                        
		}
	},{
		header : getCommonTranslation('VIEW_ADJUSTMENTS'),
		dataIndex : 'adjustmentDetails',
		flex : 1,
		renderer : function(value){
			return  '<a href="#">'+"View"+'</a>';
		},
	},{
		header : getCommonTranslation('FEE_HEAD_DETAILS'),
		dataIndex : 'feeHeadDetails',
		flex : 1,
		renderer : function(value){
			return  '<a href="#">'+"View"+'</a>';
		},
	},{

		header : getCommonTranslation('SINGLE_FEE_HEAD'),
		dataIndex : 'singleFeeHeadName',
		flex : 1,
		hidden : true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return getCommonTranslation(value);
			}                    
		} 
	
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
	}]
});