/**
 * @author Manisha Wagh
 */

var templateFor = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"REGULAR", "name":"Regular"},
        {"value":"REPEAT", "name":"Repeat"}] 
});

Ext.define('Academia.view.feeandpayment.creditfeemapping.ImportCreditFeeMappingDownloadForm',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.importcreditfeemappingdownloadform',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			width: 698,
			store:'common.AcademyLocationNameSeparated',
			allowBlank : false,
			queryParam: "qry",
			valueField : 'id',
			forceSelection : true,
			displayField : 'value',
			hideTrigger:false,
			typeAhead:true,
			triggerAction: 'all',
			minChars:3,			
			emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'academicTerm',
			itemId:'academicTermId',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
//			translationKey:'COURSE_DEPARTMENT',
			store:Ext.create('Academia.store.feeandpayment.creditfeemapping.CreditFeeMappingAcademicTermStore'),
			editable: true,
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'programGroup',
			itemId:'ProgramGroupItemId',
			fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
			store:'program.ProgramGroupStore',
			editable: true,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
			allowBlank : true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead:true,
			hideTrigger:false,	 
			queryParam:'programGrpName',
			triggerAction: 'all',
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'templateFor',
			itemId:'templateForId',
			fieldLabel: getCommonTranslation('TEMPLATE_FOR'),
			store:templateFor,
			editable: false,
			valueField: 'value',
			displayField: 'name',
			value:'REGULAR',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			}
		}]
	},{
		xtype: 'fieldcontainer',
		style:{marginTop:'23px !important',marginLeft:'-5px !important'},
		items: [{
			xtype:'button',
			itemId:'creditFeeMappingDownload',
			text:getFeeAndPaymentCommonTranslation('DOWNLOAD_RECEIPTS_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}
	]
});
