/**
 * @author Rajkumar.patidar
 */
var store = Ext.create('Ext.data.JsonStore', {
    fields: ['name', 'data1'],
    data: [
        {'name':'Nashik (83000)', 'data1':83000},
        {'name':'Pune (279000)', 'data1':279000},
        {'name':'Mumbai (430500)', 'data1':430500}
                                                        
    ]});

Ext.define('Academia.view.feeandpayment.dashboardAndReports.discountStatistics.DiscountStatisticsByLocationChart' ,{
	extend: 'Ext.chart.Chart',
	requires: ['Ext.chart.*', 'Ext.Window', 'Ext.layout.container.Fit', 'Ext.fx.target.Sprite', 'Ext.window.MessageBox'],
    style: 'background:#fff',
    alias : 'widget.discountstatisticsbylocationchart',
    animate: true,
    shadow: false,
    width: 300,
	height: 300,
    store: store,
    series: [{
        type: 'pie',
        field: 'data1',
        showInLegend: true,
       // title:getFeeAndPaymentCommonTranslation('STATISTICS_BY_LOCATIONS'),
        tips: {
          trackMouse: true,
          width: 140,
          height: 28,
          renderer: function(storeItem, item) {
            //calculate percentage.
            var total = 0;
            store.each(function(rec) {
                total += rec.get('data1');
            });
            this.setTitle(storeItem.get('name') + ': ' + Math.round(storeItem.get('data1') / total * 100) + '%');
          }
        },
        highlight: {
          segment: {
            margin: 0
          }
        },
        label: {
            field: 'name',
            display: 'rotate',
            contrast: true,
            font: '15px Arial'
        }
    }]
});
