/**
 * @Author Bhanu PS
 */
Ext.define('Academia.view.feeandpayment.discounts.MapFeePlanStructure', { 
	extend: 'Ext.form.Panel',
	alias : 'widget.mapfeeplanstructure',
	autoScroll: false,
	modal: true,
	autoScroll:false,
	frame:true,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items : [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'vbox'
			},
			items:[{
				xtype: 'fieldcontainer',
				frame:true,
				layout: {
					type: 'hbox'
				},
				defaults :{
					labelAlign: 'top'
				},
				items:[{
					xtype:'displayfield',
					name:'dicountCode',
					itemId:'dicountCode',
					fieldLabel:getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE')
				}]
			},{
				xtype: 'fieldcontainer',
				layout: {
					type: 'hbox'
				},
				items : [{
					xtype: 'fieldcontainer',
					itemId:'programBatchContainerId',
					items:[{
						xtype : 'fieldcontainer',
						width: '100%',
						itemId:'programBatchContainer',
						layout : 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items : [{  
							xtype: 'customcombobox',
							name: 'feePlanType',
							itemId:'feePlanType',
							fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PLAN_TYPE'),
							valueField: 'id',
							displayField: 'value',
							allowBlank:false,
							typeAhead:true,
							forceSelection:true,
							style:{
								marginRight:'10px !important'
							},
							listeners: {
								render: function(combo) {
									var store = Ext.create('Academia.store.feeandpayment.FeePlanTypeStore');
									combo.bindStore(store);
								},
								select:function(obj,record){
									var typeId = record[0].get("id");
									var  stage = obj.nextSibling();
									stage.reset();
									stage.setDisabled(false);
									var store = stage.getStore();
									store.proxy.extraParams = {
											feePlanTypeId : typeId
									};
									store.load();
								}
							},
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							}
						},{
							xtype: 'customcombobox',
							name: 'stage',
							itemId:'stage',
							fieldLabel: getFeeAndPaymentCommonTranslation('STAGE'),
							valueField: 'id',
							displayField: 'value',
							typeAhead:true,
							disabled:true,
							allowBlank:false,
							forceSelection:true,
							listeners: {
								render: function(combo) {
									var store = Ext.create('Academia.store.feeandpayment.FeePlanStageType');
									combo.bindStore(store);
								}
							}
						},{
							xtype: 'button',
							itemId: 'addFilterBtn',
							cls: 'CustomBodyBtnSettings',
							text: getCommonTranslation('ADDBUTTONTEXT'),
							tooltip: getCommonTranslation('ADD'),
							style:{
								marginTop:'30px !important'
							}
						}]
					}]
				}]
			},{
				xtype: 'fieldcontainer',
				frame:true,
				layout: {
					type: 'hbox'
				},
				defaults :{
					labelAlign: 'top'
				},
				items:[{
					xtype: 'button',
					text: getCommonTranslation('SAVE'),
					itemId: 'mappingSaveBtn',
					hidden:false,
					formBind: true,
					ui: 'CustomBtnSubmit'
				}]
			}]
		}]
	}]
});