/**
 *  @author Rajkumar.patidar
 */

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
	clicksToEdit: 1,
	listeners : {
		beforeedit:function( editor, context, e ){ 
		}
	}
});

var feeConcessionDetailsStore = 'feeandpayment.feerequest.FeeConcessionDetails';
Ext.define('Academia.view.feeandpayment.feerequest.FeeReqBillWaiverGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feereqbillwaivergrid',
	store : 'feeandpayment.feerequest.FeeConcessionDetails',
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	title : getFeeAndPaymentCommonTranslation('LIST_OF_FEE_REQUEST'),
	selType:'checkboxmodel',
	selModel: {
		showHeaderCheckbox: false,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'feeandpayment.feerequest.FeeConcessionDetails',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnSave',
		text:getFeeAndPaymentCommonTranslation('SAVE'),
		tooltip: getFeeAndPaymentCommonTranslation('SAVE'),
		//glyph: ICONGLYPH.ADDGLYPH
	}],
	columns: [{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'code',
		flex:1
	},{
		header : getCommonTranslation('BILL_NO'),
		dataIndex : 'billNo',
		flex : 1
	},{
		header : getCommonTranslation('FEE_HEAD'),
		dataIndex : 'feeHeadName',
		flex : 1
	},{
		header : getCommonTranslation('AMOUNT'),
		dataIndex : 'totalBalanceAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('DISCOUNT_ALREADY_GIVEN'),
		dataIndex : 'discountAmount',
		flex : 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}                    
		} 
	},{
		header : getCommonTranslation('AMOUNT_WAIVER_REQUESTED'),
		dataIndex : 'waiverAmountRequested',
		flex : 1,
		//hidden:true,
		editor : {
			xtype:'numberfield',
			name: 'waiverAmountRequested',
			itemId:'waiverAmountRequested',
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			minValue:0
		  },    
		    renderer:function(value,meta){
		    	if(!isNullOrEmpty(value)) {
	                return value;
	            } else {
	            	meta.tdCls='gridInputCustomStyle';
	                return getCommonTranslation('CLICK_TO_ENTER');
	            }
		}
	},{
		header : getCommonTranslation('INSTALLMENT_REQUEST'),
		dataIndex : 'installmentRequest',
		//hidden:true,
		flex : 1,
		renderer:function(value){
			return  '<a href="#">Request</a>';
		}
	},{
		header : getCommonTranslation('REMARK'),
		dataIndex : 'remark',
		flex : 1,
		editor : {
			xtype:'textarea',
			name: 'remark',
			itemId:'remark',
			height:40
		  },    
		    renderer:function(value,meta){
		    	if(!isNullOrEmpty(value)){
	                return value;
	            } else {
	            	meta.tdCls='gridInputCustomStyle';
	                return getCommonTranslation('CLICK_TO_ENTER');
	            }
		}
	}],
	plugins: [cellEditing]
});