/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.feeandpayment.feerequest.StudentFeeReqInstallmentWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentfeereqinstallmentwin',
	modal: true,
	autoScroll:true,
	maxHeight:500,
	title:getFeeAndPaymentCommonTranslation('INSTALLMENT'),
	items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items:[{
			xtype:'hidden',
			name:'id',
			itemId:'id'
		},{
			xtype:'hidden',
			name:'feePlanSubmissionSchedule',
			itemId:'feePlanSubmissionSchedule'
		},{
			xtype:'hidden',
			name:'billFeePlanRuleStageId',
			itemId:'billFeePlanRuleStageId'
		},{
			xtype:'hidden',
			name:'feeStageHeadConfigId',
			itemId:'feeStageHeadConfigId'			
		},{
			xtype:'hidden',
			name:'waiverAmountRequested',
			itemId:'waiverAmountRequested'
		},{
			xtype:'hidden',
			name:'gridType',
			itemId:'gridType'
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top',
				xtype:'displayfield'
			},
			items:[{
				name:'studentId',
				itemId:'studentId',
				fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_ID')
			},{
				name:'studentName',
				itemId:'studentName',
				fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_NAME')
			},{
				name:'billNo',
				itemId:'billNo',
				fieldLabel:getFeeAndPaymentCommonTranslation('BILL_NO')
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
				
			},
			items:[{
				xtype:'displayfield',
				name:'feeHead',
				itemId:'feeHead',
				fieldLabel:getFeeAndPaymentCommonTranslation('FEE_HEAD')
			},{
				xtype:'displayfield',
				name:'amount',
				itemId:'amount',
				submitValue: true,
				fieldLabel:getFeeAndPaymentCommonTranslation('AMOUNT')
			},{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('REQUEST_DATE'),
				itemId:'requestDate',
				name:'requestDate',
				allowBlank:false,
//				value:new Date(),
				maxValue:new Date(),
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
	},{
		xtype:'panel',
		itemId: 'installmentPanel',
		style:{margin:'0px'},
		width: '100%',
		items:[{
			xtype: 'fieldcontainer',
			width: '100%',
			layout: {
				type: 'hbox',
				align: 'bottom',
				width: 226
			},
			items: [{
				xtype:'datefield',
				fieldLabel:getFeeAndPaymentCommonTranslation('INSTALLMENT_DUE_DATE'),
				itemId:'installmentDueDate',
				name:'installmentDueDate',
				labelAlign: 'top',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				allowBlank: false,
//				value:new Date(),
				minValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			},{
				xtype: 'numberfield',
				itemId: 'installmentAmount',
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTALLMENT_AMOUNT'),
				labelAlign: 'top',
				name: 'installmentAmount',
				minValue: 0,
                allowDecimals:false,
                allowBlank: false,
	        	hideTrigger:true,
	        	mouseWheelEnabled:false
			}, {
				xtype: 'textfield',
				itemId: 'installmentStatus',
				readOnly:true,
				value:'PENDING',
				fieldLabel: getFeeAndPaymentCommonTranslation('INSTALLMENT_STATUS'),
				labelAlign: 'top',
				name: 'installmentStatus',
				allowBlank: false
			},{
				/*xtype: 'button',
				width:100,
				itemId: 'btnAddInstallment',
				text: getCommonTranslation('ADD'),
				tooltip: getCommonTranslation('ADD'),
				buttonAlign: 'bottom',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE*/
				
				xtype: 'button',
				itemId: 'btnAddInstallment',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD')
				
			}] 
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype:'textareafield',
			fieldLabel: getFeeAndPaymentCommonTranslation('REMARK'),
			name: 'remark',
			itemId:'remark',
			width: 460,
		}]
	},{
		xtype:'fieldcontainer',
		//width:'100%',
		//cls:'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'saveBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'cancelBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
  }]
});