/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.payment.FeeOfflinePaymentDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeofflinepaymentdocumentlistgrid',
	store :Ext.create('Academia.store.feeandpayment.payment.OfflinePaymentDocumentListStore'),
	border: true,
	autoScroll: true,
	height:'80%',
	frame:false,
	itemId:'feeOfflinePaymentDocumentGridId',
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	},'->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'name',
		flex:1,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});