/**
 * @author Amit G
 */
Ext.define('Academia.view.feeandpayment.paymentPlanEnrollment.VWPlanEnrolProgramSelectedValueForm', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.vwplanenrolprogramselectedvalueform',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	items: [ {
		xtype : 'fieldcontainer',
		 layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
		items : [ {
			xtype: 'hidden',
			name: 'paymentPlanId',
			itemId: 'paymentPlanIdEnroll',
		},{
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programId',
			fieldLabel: getFeeAndPaymentCommonTranslation('PROGRAM'),
			store:Ext.create('Academia.store.feeandpayment.paymentPlanEnrollment.StoFnpProgramByPaymentPlanStore'),
			valueField: 'id',
			displayField: 'valueCode',
			typeAhead:true,
			forceSelection:true,
			hideTrigger:false,	 
			queryParam:'qry',
			triggerAction: 'all',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batch',
			disabled:true,
			fieldLabel: getFeeAndPaymentCommonTranslation('BATCH'),
			itemId:'batchId',
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
		},{
			xtype: 'customcombobox',
			name: 'seatType',
			disabled:true,
			itemId:'seatTypeId',
			fieldLabel: getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
			store: 'enquiry.ProgramBatchSeatTypeStore',
			valueField: 'id',
			displayField: 'value'
		},{
			xtype: 'customcombobox',
			name: 'status',
			fieldLabel: getFeeAndPaymentCommonTranslation('STATUS'),
			itemId:'statusId',
			store: Ext.create('Academia.store.feeandpayment.paymentPlanEnrollment.PaymentPlanRequestRecievedStatusStore'),
		    valueField: 'id',
			displayField: 'value',
			name:'status'
		}]
	},{
    	xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchEnrollButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetEnrollButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});