/**
 * @author Ranga
 */
Ext.define('Academia.view.feeandpayment.reports.FeeHeadBasedCollectionReportGrid', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.feeheadbasedcollectionreportgrid',
	store : 'feeandpayment.reports.FeeHeadBasedReportStore',
	title : getFeeAndPaymentCommonTranslation('FEE_HEAD_BASED_COLLECTION_REPORT'),
	border : true,
	width : 1450,
	autoScroll : false,
	refreshStoreData : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	features : [ {
		ftype : 'summary',
		showSummaryRow : CONSTANTS.SHOW_SUMMARY_ROW
	} ],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : 'feeandpayment.reports.FeeHeadBasedReportStore',
			emptyMsg : getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);
	},
	columns : [
		       {
		    	    header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
	    		    dataIndex : 'academyLocationName',
	    		    flex:1,
	    		    hidden:true
              },
		      {
	        	   header : getFeeAndPaymentCommonTranslation('ADMISSION_ID'),
	        	   dataIndex : 'admissionCode',
	        	   flex : 1,
	        	   /*summaryRenderer : function(value, summaryData,
	        			   dataIndex) {
	        		   return getFeeAndPaymentCommonTranslation('TOTAL');
	        	   }*/
	        	   summaryRenderer: function(value, metaData, record, row, col, store, gridView)  {
						if(store.data.items[0].data.conversionType == "AL" || store.data.items[0].data.conversionType == "ORG") {
						// a = currencyRenderer('',store.data.items[0].data.acadLocBaseCurrencyId).split(" ");
							return getFeeAndPaymentCommonTranslation('Total (In ' + store.data.items[0].data.currencyName +')');
						}
						else {
							return getFeeAndPaymentCommonTranslation('TOTAL');
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
	        	   dataIndex : 'studentID',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
	        	   dataIndex : 'printName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('PROGRAM_CODE'),
		           dataIndex : 'programCode',
		           flex:1,
		           hidden:true
              },{
	        	   header : getFeeAndPaymentCommonTranslation('PROGRAM'),
	        	   dataIndex : 'programName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('BATCH'),
	        	   dataIndex : 'batchName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('SECTION'),
	        	   dataIndex : 'section',
	        	   flex : 1,
	        	   hidden:true
	           },
	           {
	        	   header : getFeeAndPaymentCommonTranslation('SEAT_TYPE'),
	        	   dataIndex : 'seatName',
	        	   flex : 1
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
	        	   dataIndex : 'totalBillAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	   /*summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('BILL_AMOUNT_PAID'),
	        	   dataIndex : 'settledAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	  /* summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           },{
	        	   header : getFeeAndPaymentCommonTranslation('OUT_STANDING'),
	        	   dataIndex : 'totalOutstandingAmount',
	        	   flex : 1,
	        	   summaryType : 'sum',
	        	   align : CONSTANTS.AMOUNT_COLUMN_ALIGN,
	        	   renderer : function(value, metaData, record,
	        			   row, col, store, gridView) {
	        		   if (!isNullOrEmpty(record.get("currencyId"))) {
	        			   return currencyRenderer(value, record
	        					   .get("currencyId"));
	        		   }
	        	   },
	        	  /* summaryRenderer : function(value, summaryData,
	        			   dataIndex, rowIndex, colIndex, store,
	        			   view) {
	        		   return value;
	        	   }*/
	        	   summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
						if(store.data.items[0].data.conversionType == 'AL' || store.data.items[0].data.conversionType == 'ORG'){
							return currencyRenderer(value,store.data.items[0].data.currencyId);
						}
						else {
							return value;
						}
					}
	           }]
});
