	/**
	 * @author Nitin gaikwad
	 */
	Ext.define('Academia.view.feeandpayment.reports.InstruemntDetailReportForm', {
		extend : 'Ext.form.FormPanel',
		alias : 'widget.instruemntdetailreportform',
		autoScroll : false,
		frame : false,
		cls : 'customSearchPanel',
		method : 'GET',
		standardSubmit : false,
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		plugins:"formlabelrequired",
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[ {
		    	   xtype: 'customcombobox',
					name: 'paymentMode',
					itemId:'paymentMode',
					fieldLabel: getFeeAndPaymentCommonTranslation('PAYMENT_MODE'),
					store:Ext.create('Academia.store.feeandpayment.FeePaymentMode'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true 
		       },{
					xtype: 'customcombobox',
					name: 'receiptStatus',
					itemId:'receiptStatus',
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_STATUS'),
					store:'feeandpayment.receipts.ReceiptStatus',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},{
					xtype: 'customcombobox',
					name: 'instrumentNumber',
					itemId:'instrumentNumberId',
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_NO'),
					store:'feeandpayment.payment.InstrumentNumberSmartSearchStore',
					valueField: 'value',
					displayField: 'value',
					triggerAction: 'all',
	                forceSelection: true,
	                //allowBlank: false,
	                queryParam:'name',
					forceSelection:true,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			typeAhead:false,
	    			hideTrigger:false,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				}
	    			}
				}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'customcombobox',
				name : 'intakeYear',
				itemId: 'intakeYear',
				fieldLabel : getFeeAndPaymentCommonTranslation('INTAKE_YEAR'),
				store: Ext.create('Academia.store.common.IntakeYearStore'),
				valueField : 'id',
				displayField : 'value',
				allowBlank : true,
				width:226
			}, {
				xtype: 'customcombobox',
				name: 'userType',
				itemId: 'userType',
				store: 'feeandpayment.dashboardAndReports.FeeFindAllBillTypedUser',
				fieldLabel: getCommonTranslation('USER_TYPE'),
				valueField: 'value',
				displayField: 'value',
				typeAhead: false,
				queryMode : 'local'
			},{
				xtype: 'customcombobox',
				name: 'applicant',
				itemId:'applicant',
				hidden:true,
				fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.reports.ApplicantIntake'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}/{printName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'student',
				itemId:'student',
				fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
				store: Ext.create('Academia.store.feeandpayment.reports.Student'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{

    			xtype: 'customcombobox',
    			name: 'user',
    			itemId:'userId',
    			hidden:true,
    			fieldLabel: getFeeAndPaymentCommonTranslation('USER_CODE_NAME'),
    			store: 'feeandpayment.reports.InstrumentReportUserFindAllStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'codeOrName',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}/{nameToBePrinted}' +
    					'</div>';
    				}
    			}
    		
            }]

		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
					xtype: 'statusCombo',
					name: 'STATUS',
					itemId:'statusComboItemId',
					value:null
	        }]
		},{
			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('INSTUMENT_DETAILS')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'datefield',
					name: 'fromdate',
					itemId:'fromdate',
					format: 'd/m/Y',
					listeners: {
						render: function(field) {
							 var today = new Date();
					         var defaultDate = Ext.Date.add(today, Ext.Date.DAY, -30);
					         	field.setValue(defaultDate);
							 return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'todate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE_FROM')
				},{
					xtype: 'datefield',
					name: 'todate',
					itemId:'todate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'fromdate',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('INSTRUMENT_DATE_TILL')
				}]
			}]
		},{

			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('RECEIPT_DETAILS_LABEL_ON_INSTRUMENT_UI')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'datefield',
					name: 'receiptDateFrom',
					itemId:'receiptDateFrom',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'receiptDateTo',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_DATE_FROM')
				},{
					xtype: 'datefield',
					name: 'receiptDateTo',
					itemId:'receiptDateTo',
					listeners: {
	            	  render: function(field) {
	            		  return dateFormatRender(field);
	            	  }
	              },
	            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'receiptDateFrom',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('RECEIPT_DATE_TILL')
				}]
			}]
		
		},
		
		{

			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getFeeAndPaymentCommonTranslation('SETTLEMENT_DETAILS_LABEL_ON_INSTRUMENT_UI')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width: '100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'datefield',
					name: 'settlementDateFrom',
					itemId:'settlementDateFrom',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'settlementDateTo',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_DATE_FROM')
				},{
					xtype: 'datefield',
					name: 'settlementDateTo',
					itemId:'settlementDateTo',
					listeners: {
	            	  render: function(field) {
	            		  return dateFormatRender(field);
	            	  }
	              },
	            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'settlementDateFrom',
					editable:false,
					fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_DATE_TILL')
				}]
			}]
		
		},

		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	});
