var imagestore1 = Ext.create('Ext.data.Store', {
	fields: ['name', 'size', 'file', 'status']
});


Ext.define('Academia.view.filemanagement.FileUploadMultipleDragAndDrop', {
	extend : 'Ext.grid.Panel',
	alias: 'widget.fileuploadmultipledraganddrop',
	title: 'Multiple upload',
	store: 'filemanagement.MultiFileTempStore',
	multiSelect: true,
	id: 'UploadGrid',
	border:true,
	columns: [
		{
			header: "id",
			itemId:'documentItemId',
			dataIndex: 'code',
			flex: 2,
			hidden:true
		},{
		header: getCommonTranslation('NAME'),
		dataIndex: 'name',
		flex: 2
	}, {
		header: getCommonTranslation('SIZE'),
		dataIndex: 'size',
		flex: 1,
		renderer: Ext.util.Format.fileSize
	}, {
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex: 1,
		renderer: function(value, metaData, record, rowIndex, colIndex, imagestore){
			if(value === "Ready"){
				return value;
			}else{
				if(value=== "Uploading"){
					return 'Uploading..';
					/*var id = Ext.id();
					Ext.defer(function () {
						var pb = Ext.widget('progressbar', {
							renderTo: id,
							id:'update_progressBare',
							interval: 500, //bar will move fast!
							duration: 50000,
							increment: 15,
							text: 'Uploading...',
							scope: this,
						});
						pb.textEl.removeCls("x-progress-text x-progress-text-back");
						pb.textEl.addCls("inProgressCss-progress-text");
					}, 50);*/
					//return Ext.String.format('<div id="{0}"></div>', id);
				}else{
					return 'Uploaded';
					/*var id = Ext.id();
					Ext.defer(function () {
						var pb = Ext.widget('progressbar', {
							renderTo: id,
							interval: 500, //bar will move fast!
							duration: 50000,
							increment: 15,
							text: 'Uploaded',
							scope: this,
						});
						pb.textEl.removeCls("x-progress-text x-progress-text-back");
						pb.textEl.addCls("inProgressCss-progress-text");
					}, 50);
					return Ext.String.format('<div id="{0}"></div>', id);*/
				}
			}
		}
	}],

	viewConfig: {
		emptyText: getCommonTranslation('DROP_FILES_HERE'),
		deferEmptyText: false,
		stripeRows : CONSTANTS.STRIPEROWS
	},
	listeners: {
		drop: {
			element: 'el',
			fn: 'drop'
		},

		dragstart: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragenter: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragover: {
			element: 'el',
			fn: 'addDropZone'
		},

		dragleave: {
			element: 'el',
			fn: 'removeDropZone'
		},

		dragexit: {
			element: 'el',
			fn: 'removeDropZone'
		},

	},

	noop: function(e) {
		e.stopEvent();
	},

	addDropZone: function(e) {
		if (!e.browserEvent.dataTransfer || Ext.Array.from(e.browserEvent.dataTransfer.types).indexOf('Files') === -1) {
			return;
		}

		e.stopEvent();

		this.addCls('drag-over');
	},

	removeDropZone: function(e) {
		var el = e.getTarget(),
		thisEl = this.getEl();

		e.stopEvent();


		if (el === thisEl.dom) {
			this.removeCls('drag-over');
			return;
		}

		while (el !== thisEl.dom && el && el.parentNode) {
			el = el.parentNode;
		}

		if (el !== thisEl.dom) {
			this.removeCls('drag-over');
		}

	},

	drop: function(e) {
		var imagestore = this.getStore('filemanagement.MultiFileTempStore');
		Ext.Array.forEach(Ext.Array.from(e.browserEvent.dataTransfer.files), function(file) {
			imagestore.add({
				file: file,
				name: file.name,
				size: file.size,
				status: 'Ready'
			});
		});
		//Ext.getCmp('UploadGrid').getView().refresh();
		
		this.removeCls('drag-over');
		e.stopEvent();
	},

	tbar: [{
		    xtype: 'filefield',
	        allowBlank: true,
	        itemId:'filefieldDragAndDrop',
	        buttonOnly : true,
	        buttonText: getCommonTranslation('BROWSE')
	},{
		text: getCommonTranslation('UPLOAD'),
		itemId:'filefieldUploadto'
	}, {
		text: getCommonTranslation('DELETE'),
		itemId:'deletefilefieldUpload'
	}]
});


