/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.hostel.hostelApplicationSetup.AddHostelApplicationSetup' ,{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.addHostelApplicationSetup',
	plain: true,
	cls: 'adddNewCeremonyFormBox', 
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	title: getCommonTranslation("ADD_NEW_HOSTEL_APPLICATION_SETUP"),
	bodyPadding: 10,
	items: [{
        xtype: 'hiddenfield',
        name: 'setupId',
        itemId: 'setupId'
    },
		{
			xtype:'form',
			plugins:"formlabelrequired",
			layout: {
				type: 'table',
				columns: 4, // Define a 4-column layout
			},
			width: '100%',
			defaults: {
				xtype: 'textfield',
				allowBlank: false, // To make fields mandatory
				labelAlign: 'top',
				margin: '5',
				width: 250
			},
			items:[
				{
					fieldLabel: getCommonTranslation("HOSTEL_SETUP_CODE"),
					name: 'setupCode',
					itemId:'setupCode'
				},{ 
					fieldLabel: getCommonTranslation("HOSTEL_SETUP_NAME"),
					name: 'setupName',
					itemId:'setupName'
				},
				{

					xtype: 'customcombobox',
					name:'userType',
					store: Ext.create('Ext.data.Store', {
						fields: ['id', 'name'],
						data : [
							{"id":"STUDENT", "name":getCommonTranslation('STUDENT')},
							{"id":"APPLICANT", "name":getCommonTranslation('APPLICANT')}
							]
					}),
					itemId:'userType',
					fieldLabel: getCommonTranslation('USER_TYPE'),
					displayField: 'name',
					valueField: 'id',
					editable:false
				},
				{

					xtype: 'customcombobox',
					name:'hostelSetupType',
					store: Ext.create('Ext.data.Store', {
						fields: ['id', 'name'],
						data : [
							{"id":"HOSTEL_GENERAL_SETUP", "name":getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION')},
							{"id":"WAITING_LIST_SETUP", "name":getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION')}
							]
					}),
					itemId:'hostelSetupType',
					fieldLabel: getCommonTranslation('APPLICATION_TYPE'),
					displayField: 'name',
					    valueField: 'id',
					editable:false
				},
				{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
					name: 'accountTermId',
					itemId: 'accountTermId',
					displayField : 'value',
					valueField : 'id',
					store:'common.AcademicTermStore',
					editable: false,
					forceSelection:true,
					msgTarget: 'qtip',
					editable:false
				},
				{
					xtype: 'datefield',
					name: 'applicationStartDate',
					itemId:'applicationStartDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'applicationEndDate',
					editable:false,
					fieldLabel:getCommonTranslation('APPLICATION_START_DATE')
				},{
					xtype: 'datefield',
					name: 'applicationEndDate',
					itemId:'applicationEndDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'applicationStartDate',
					editable:false,
					fieldLabel:getCommonTranslation('APPLICATION_END_DATE')

				},
				{ 
					xtype: 'datefield',
					name: 'adminStartDate',
					itemId:'adminStartDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'adminEndDate',
					editable:false,
					fieldLabel:getCommonTranslation('ADMIN_START_DATE')
				},

				// Third row
				{ 
					xtype: 'datefield',
					name: 'adminEndDate',
					itemId:'adminEndDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'adminStartDate',
					editable:false,
					fieldLabel:getCommonTranslation('ADMIN_END_DATE')
				},{
					xtype: 'radiogroup',
					fieldLabel: '<div class="nowrap-labelCls" data-qtip="' + getCommonTranslation('APPLICATION_CANCELLATION_POSSIBLE_FROM_SP') + '">' +
			        getCommonTranslation('APPLICATION_CANCELLATION_POSSIBLE_FROM_SP')+ '</div>',
			        labelSeparator:'',
					itemId:'IsApplicationCancellationFromSP',
					allowBlank:true,
					columns: 2,
					items: [
						{ boxLabel: getCommonTranslation("YES"), name: 'IsApplicationCancellationFromSP', inputValue: true},
						{ boxLabel: getCommonTranslation("NO"), name: 'IsApplicationCancellationFromSP', inputValue: false, checked: true  }
						]
				},{ 
					xtype: 'datefield',
					name: 'applicationCancellationFromDate',
					itemId:'applicationCancellationFromDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					endDateField: 'applicationCancellationToDate',
					editable:false,
					hidden:true,
					allowBlank: true,
					fieldLabel:getCommonTranslation('APPLICATION_CANCEL_FROM_DATE')
				},
				{ 
					xtype: 'datefield',
					name: 'applicationCancellationToDate',
					itemId:'applicationCancellationToDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					startDateField: 'applicationCancellationFromDate',
					editable:false,
					hidden:true,
					allowBlank: true,
					fieldLabel:getCommonTranslation('APPLICATION_CANCEL_TO_DATE')
				},
				{
					xtype: 'radiogroup',
					fieldLabel: getCommonTranslation("OFFER_APPLICABLE"),
					itemId:'offerApplicable',
					columns: 2,
					hidden:true,
					disabled:true,
					items: [
						{ boxLabel: getCommonTranslation("YES"), name: 'offerApplicable', inputValue: true},
						{ boxLabel: getCommonTranslation("NO"), name: 'offerApplicable', inputValue: false, checked: true  }
						]
				},
				{ 
					xtype: 'datefield',
					name: 'offerLetterStartDate',
					itemId:'offerLetterStartDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					endDateField: 'offerLetterEndDate',
					editable:false,
					fieldLabel:getCommonTranslation('OFFER_LETTER_START_DATE'),
					hidden:true,
					allowBlank:true,
					disabled:true
				},
				{ 
					xtype: 'datefield',
					name: 'offerLetterEndDate',
					itemId:'offerLetterEndDate',
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
					vtype: 'daterange',
					startDateField: 'offerLetterStartDate',
					editable:false,
					fieldLabel:getCommonTranslation('OFFER_LETTER_END_DATE'),
					allowBlank:true,
					hidden:true,
					disabled:true
				},

				// Fourth row
				{ 
					xtype: 'numberfield',
					name: 'maxDaysToAcceptOffer',
					fieldLabel:getCommonTranslation('MAX_DAYS_ACCEPT_OFFER'),
					itemId: 'maxDaysToAcceptOffer',
					minValue:0,
					maxValue: 999,
					enableKeyEvents: true,
					hidden:true,
					disabled:true,
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					allowBlank:true,
					listeners:{
						keypress: function (field, e) {
							// Prevent input if not a number (keyCode 48-57 for numbers 0-9)
							// or not backspace (keyCode 8), delete (keyCode 46)
							if (e.getKey() < 48 || e.getKey() > 57) {
								e.preventDefault();
							}
						}
					}
				},{ 
					xtype: 'numberfield',
					name: 'notificationBeforeOfferExpires',
					fieldLabel:getCommonTranslation('NOTIFICATION_BEFORE_OFFER_EXPIRES_IN_DAYS'),
					itemId: 'notificationBeforeOfferExpires',
					minValue:0,
					maxValue: 999,
					enableKeyEvents: true,
					hidden:true,
					disabled:true,
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					allowBlank:true,
					listeners:{
						keypress: function (field, e) {
							// Prevent input if not a number (keyCode 48-57 for numbers 0-9)
							// or not backspace (keyCode 8), delete (keyCode 46)
							if (e.getKey() < 48 || e.getKey() > 57) {
								e.preventDefault();
							}
						}
					}
				},
				{

					xtype: 'customcombobox',
					name: 'applicationDroolRule',
					fieldLabel: getCommonTranslation('APPLICATION_RULE_APPLICABLE'),
					store: Ext.create('Ext.data.Store', {
						fields: ['id', 'value'],
						data: []
					}),
					itemId: 'applicationRuleApplicable',
					valueField: 'id',
					displayField: 'value',
					allowBlank:true
				},
				{ 

					xtype: 'customcombobox',
					name: 'status',
					fieldLabel: getCommonTranslation('STATUS'),
					store: Ext.create('Ext.data.Store', {
						fields: ['id', 'name'],
						data : [
							{"id":true, "name":getCommonTranslation('ACTIVE')},
							{"id":false, "name":getCommonTranslation('INACTIVE')}
							]
					}),
					itemId: 'status',
					valueField: 'id',
					displayField: 'name',
					value:true,
					listeners:{
						afterrender:function(cmp){
							Ext.defer(function(){
								cmp.setValue(true);
							},50)

						}
					}
				},
				{
					xtype:'form',
					width: 250,
					items:[{
						 xtype : 'filefield',
		                    ui: 'CustomBtnCancel',
		                    cls:"readdmissionFile",
		                    width: 250,
		                    fieldLabel : getCommonTranslation('TC_Document'),
		                    buttonText : getCommonTranslation('BROWSE'),
		                    itemId : 'TC_Document',
		                    name : 'file',
		                    validateOnChange : true,
		                    labelAlign:'top',
		                    disabled:true,
		                    hidden:true,
		                    allowBlank: false
					}]
				}
				]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveHostelSetup',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtnItemId',
				ui: 'CustomBtnCancel',
				hidden:true,
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}
		]
});
