/**
 * @author Bhanu Pratap Singh
 */

var applicantionType =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"WITHOUT_RESIDENCE_APPLICATION", "name":getCommonTranslation('WITHOUT_RESIDENCE_APPLICATION')},
        {"value":"WITH_RESIDENCE_APPLICATION", "name":getCommonTranslation('WITH_RESIDENCE_APPLICATION')}]
});
Ext.define('Academia.view.hostel.hostelapplication.UploadAllocationLoaderForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.uploadallocationloaderform',
	autoScroll: false,
	frame: false,
	standardSubmit: false,
	//cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	
	items: [{
		xtype:'uploadoptionradiogroup',
		width: 300,
        margin: 0,
		itemId:'uploadmarksUploadOptionRadioGroupItemId',
		
	},
	{
		xtype: 'radiogroup',
		itemId:'eventQuestionGroupId',
		name: 'eventQuestion',
		labelAlign:'top',			
		columns: 3,
		vertical: true,
		items : [ {
			boxLabel: getCommonTranslation('APPLICANT'),
			name: 'studentHostel',
			inputValue: 'forApplicantFormTemplate',
			checked: true
		},{
			boxLabel: getCommonTranslation('STUDENT'),
			name: 'studentHostel',
			inputValue: 'forStudentFormTemplate',
			

		}]
	    },
	    {
	    	xtype: 'customcombobox',
			name: 'type',
			itemId:'typeItemId',
			allowBlank:false,
			store: applicantionType,
        	valueField: 'value',
        	displayField: 'name', 
        	editable: false,
        	querymode: 'local',
			fieldLabel: getCommonTranslation('TYPE'),
			typeAhead:false,
			forceSelection:true,
			hidden:true		
	    },
	{
		xtype: 'customcombobox',
		name: 'importUtilityMasterId',
		width: 280,
		itemId:'moduleName',
		store:'importutility.ModuleName',
		fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
		valueField: 'id',
		displayField: 'value',
		typeAhead:true,
		forceSelection:true,
		allowBlank:false
	},{
		xtype : 'filefield',
		ui : 'CustomBtnThird',
		width: 460,
		fieldLabel : getCommonTranslation('UPLOAD_FILE'),
		buttonText : getCommonTranslation('BROWSE_FILE'),
		itemId : 'uploadFileField',
		name : 'file',
		allowBlank:false,
		validateOnChange : true,
		listeners:{
            change: function(fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
	},{ 	
		xtype:'fieldcontainer',
		width:'auto',
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'markEntryUpload',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]});
