/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.hrm.availability.AvailabilitySettingStructure', {
   extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.availabilitysettingstructure',
     store: 'hrm.timesheet.AvailabilitySettingStore',
    title: getCommonTranslation('EMPLOYEE_AVAILABILITY'),
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    selType: 'checkboxmodel',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.timesheet.AvailabilitySettingStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAddAvailability',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},'->',],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex:'acdemyLocationName',
        flex: 1
    }, {
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex:'academicTermName',
        flex: 1
    }, {
        header: getCommonTranslation('START_DATE'),
        dataIndex:'startDate',
        flex: 1,
        renderer: function(record) {
        	 return dateRender(record);;
        }
    },{
    	header: getCommonTranslation('END_DATE'),
    	dataIndex:'endDate',
    	flex: 1,
    	renderer: function(record) {
    		return dateRender(record);;
        }
    }]
});