/**
 */
Ext.define('Academia.view.hrm.employeePortal.HRMMyTimesheetGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmmytimesheetgrid',
    store: 'hrm.timesheet.HRMTimesheetGridStore',
    title: getPersonModuleTranslation('HRM_EMPLOYEE_TIMESHEET'),
    border: true,
    //selType: 'checkboxmodel',
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    /*selModel: {
        showHeaderCheckbox: true,
        checkOnly: true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
        allowDeselect: false
    },*/
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.timesheet.HRMTimesheetGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'),
        dataIndex: 'timeSheetPeriodName',
        flex: 1,
        sortable: true
    }, {
        header: getPersonModuleTranslation('HRM_TIMESHEET_PAY_DAYS'),
        dataIndex: 'timeSheetDays',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_TOTAL_WORKING_DAYS'),
        dataIndex: 'totalDays',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_PRESENTS'),
        dataIndex: 'totalPresent',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_ABSENTS'),
        dataIndex: 'totalAbsent',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_LEAVES'),
        dataIndex: 'totalLeaves',
        flex: 1
    },{
    	header: getPersonModuleTranslation('Compensatory Leaves'),
    	dataIndex: 'totalCompensatoryLeave',
    	flex: 1,
    	sortable: false
    },{
        header: getPersonModuleTranslation('LOP'),
        dataIndex: 'totalLOP',
        flex: 1,
        sortable: false
    },{
        header: getPersonModuleTranslation('Others'),
        dataIndex: 'markingTypeStatusCount',
        flex: 1,
        sortable: false
    },/* {
        header: getPersonModuleTranslation('HRM_PAYDAYS'),
        dataIndex: 'totalPayDays',
        flex: 1,
        sortable: true,
    },*/ {
        header: getPersonModuleTranslation('HRM_TIMESHEET'),
        dataIndex: 'timesheet',
        flex: 1,
        sortable: true,
        renderer: function(value, metadata, record) {
            var msg = "";
            if (!isNullOrEmpty(record.data.timeSheetStatus)) {
                    msg = '<a href="#">' + 'View' + '</a>';
            } 
            return msg;
    }}, {
        header: getPersonModuleTranslation('STATUS'),
        dataIndex: 'timeSheetStatus',
        flex: 1,
        sortable: true
    }],
});