/**
 * @author Varsha Gour
 */
Ext.define('Academia.view.hrm.report.HRMAttendancePunchLogReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmattendancepunchlogreportgrid',
    store: 'hrm.report.HRMAttendancePunchLogReportGridStore', // TODO change store
    title: getPersonModuleTranslation('HRM_ATTENDANCE_PUNCH_LOG_REPORT'),
    border: true,
    refreshStoreData: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.report.HRMAttendancePunchLogReportGridStore', // TODO change store
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getPersonModuleTranslation('HRM_EMP_ID'),
        dataIndex: 'employeeCode',
        flex: 1,
        sortable: false
    }, {
        header: getPersonModuleTranslation('NAME'),
        dataIndex: 'employeeName',
        flex: 1,
        sortable: false
    }, {
        header: getCommonTranslation('GENDER'),
        dataIndex: 'gender',
        flex: 1,
        sortable: true,
    }, {
        header: getEnquiryTranslation('DEPARTMENT'),
        dataIndex: 'department',
        flex: 1,
        sortable: false,
    }, {
        header: getPersonModuleTranslation('DESIGNATION'),
        dataIndex: 'designation',
        flex: 1
    }, {
        header: getCommonTranslation('GROUP_TYPE'),
        dataIndex: 'groupName',
        flex: 1
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'attendancePunchDate',
        flex: 1,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return value;
        	}
        	else{
        		return '';
        	}
        }
    }, {
        header: getCommonTranslation('CALENDAR_DAY'),
        dataIndex: 'punchDay',
        flex: 1,
        sortable: true,
    }, {
        header: getCBTranslation('attendance_machine_log_punchTime'),
        dataIndex: 'attendancePunchTime',
        flex: 1,
        sortable: true,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return value;
        	}
        	else{
        		return '';
        	}
        }
    }],
});