/**
 * @author Ankur Jaiswal
 * 
 */
Ext.define('Academia.view.hrm.timesheet.HRMTimesheetFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.hrmtimesheetfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'timesheetPeriodId',
            itemId: 'timesheetPeriodItemId',
            fieldLabel: getPersonModuleTranslation('HRM_TIMESHEET_PERIOD'),
            displayField: 'value',
            valueField: 'id',
            store: 'hrm.timesheet.TimesheetPeriodStore',
            allowBlank: false,
            typeAhead: false,
            editable: false
        }, {
            xtype: 'customcombobox',
            name: 'employeeId',
            itemId: 'employeeItemId',
            fieldLabel: getPersonModuleTranslation('HRM_EMPLOYEE_ID'),
            store: 'hrm.timesheet.HRMTEmployeeSmartSearchStore',
            valueField: 'id',
            displayField: 'valueCode',
            queryParam: 'codeOrName',
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            minChars: 3,
            typeAhead: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            // triggerAction: '',
            hideTrigger: false,
            maxLength: 100,
            listConfig: {
                listeners: {
                    beforeshow: function(
                        picker) {
                        picker.minWidth = picker
                            .up('combobox')
                            .getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{studentCode} / {studentName}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('DEPARTMENT'),
            name: 'department',
            itemId: 'departmentItemId',
            store: 'department.DepartmentAcademyLocationWiseStore',
            valueField: 'id',
            // allowBlank: false,
            displayField: 'value',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getCommonTranslation('GROUP'),
            name: 'userGroupId',
            itemId: 'userGroupItemId',
            store: 'userGroup.UserGroupStore',
            valueField: 'id',
            displayField: 'userGroupName',
            // allowBlank: false,
            editable: false,
            queryMode: 'local'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchHRMTimesheetFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetHRMTimesheetFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});